/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.features.gondolas;

import androidx.compose.runtime.internal.StabilityInferred;
import com.mineinabyss.components.gondolas.Gondola;
import com.mineinabyss.components.gondolas.UnlockedGondolas;
import com.mineinabyss.features.gondolas.GondolaData;
import com.mineinabyss.features.gondolas.GondolaType;
import com.mineinabyss.features.gondolas.GondolasHelpersKt;
import com.mineinabyss.features.gondolas.LoadedGondolas;
import com.mineinabyss.geary.datatypes.Entity;
import com.mineinabyss.geary.helpers.EngineHelpersKt;
import com.mineinabyss.geary.modules.Geary;
import com.mineinabyss.geary.papermc.tracking.entities.ConversionKt;
import com.mineinabyss.idofront.messaging.LoggingKt;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0011H\u0007J \u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\tH\u0002J \u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\tH\u0002R&\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/mineinabyss/features/gondolas/GondolasListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "playerZoneEntry", "", "Ljava/util/UUID;", "Lkotlin/Pair;", "", "", "justWarped", "", "lastErrorTime", "errorCooldown", "", "onPlayerMove", "", "Lorg/bukkit/event/player/PlayerMoveEvent;", "showError", "player", "Lorg/bukkit/entity/Player;", "gondola", "Lcom/mineinabyss/components/gondolas/Gondola;", "now", "handleWarpCooldown", "data", "Lcom/mineinabyss/features/gondolas/GondolaData;", "mineinabyss-features"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nGondolasListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GondolasListener.kt\ncom/mineinabyss/features/gondolas/GondolasListener\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Entity.kt\ncom/mineinabyss/geary/datatypes/Entity\n*L\n1#1,74:1\n183#2,2:75\n147#3,5:77\n*S KotlinDebug\n*F\n+ 1 GondolasListener.kt\ncom/mineinabyss/features/gondolas/GondolasListener\n*L\n29#1:75,2\n35#1:77,5\n*E\n"})
public final class GondolasListener
implements Listener {
    @NotNull
    private final Map<UUID, Pair<String, Long>> playerZoneEntry = new LinkedHashMap();
    @NotNull
    private final Set<UUID> justWarped = new LinkedHashSet();
    @NotNull
    private final Map<UUID, Long> lastErrorTime = new LinkedHashMap();
    private final int errorCooldown;
    public static final int $stable = 8;

    public GondolasListener() {
        this.errorCooldown = 5000;
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public final void onPlayerMove(@NotNull PlayerMoveEvent $this$onPlayerMove) {
        void this_$iv$iv;
        Object v0;
        Object element$iv2;
        long now;
        block7: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)$this$onPlayerMove, (String)"<this>");
            if (!$this$onPlayerMove.hasExplicitlyChangedBlock()) {
                return;
            }
            Map<String, Gondola> gondolas = LoadedGondolas.INSTANCE.getLoaded();
            now = System.currentTimeMillis();
            Sequence sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)gondolas.entrySet()), arg_0 -> GondolasListener.onPlayerMove$lambda$0($this$onPlayerMove, arg_0));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv2 : $this$firstOrNull$iv) {
                GondolaData it = (GondolaData)element$iv2;
                boolean bl = false;
                if (!(it.getType() != GondolaType.NONE)) continue;
                v0 = element$iv2;
                break block7;
            }
            v0 = null;
        }
        GondolaData gondolaData = v0;
        if (gondolaData == null) {
            PlayerMoveEvent $this$onPlayerMove_u24lambda_u242 = $this$onPlayerMove;
            boolean bl = false;
            this.playerZoneEntry.remove($this$onPlayerMove_u24lambda_u242.getPlayer().getUniqueId());
            this.justWarped.remove($this$onPlayerMove_u24lambda_u242.getPlayer().getUniqueId());
            return;
        }
        GondolaData nearbyGondolaData = gondolaData;
        Player player = $this$onPlayerMove.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Entity this_$iv = ConversionKt.toGeary((org.bukkit.entity.Entity)((org.bukkit.entity.Entity)player));
        boolean $i$f$get = false;
        element$iv2 = this_$iv;
        KClass kClass$iv$iv = Reflection.getOrCreateKotlinClass(UnlockedGondolas.class);
        boolean $i$f$get2 = false;
        Object object = this_$iv$iv.get-VKZWuLQ(EngineHelpersKt.componentId((Geary)this_$iv$iv.getWorld(), (KClassifier)((KClassifier)kClass$iv$iv)));
        if (!(object instanceof UnlockedGondolas)) {
            object = null;
        }
        UnlockedGondolas unlockedGondolas = (UnlockedGondolas)object;
        if (unlockedGondolas == null) {
            return;
        }
        UnlockedGondolas unlockedGondolas2 = unlockedGondolas;
        if (!unlockedGondolas2.getKeys().contains(nearbyGondolaData.getId())) {
            Player player2 = $this$onPlayerMove.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"getPlayer(...)");
            this.showError(player2, nearbyGondolaData.getGondola(), now);
            return;
        }
        if (this.justWarped.contains($this$onPlayerMove.getPlayer().getUniqueId())) {
            return;
        }
        Player player3 = $this$onPlayerMove.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player3, (String)"getPlayer(...)");
        this.handleWarpCooldown(player3, nearbyGondolaData, now);
    }

    private final void showError(Player player, Gondola gondola, long now) {
        long lastTime;
        Long l = this.lastErrorTime.get(player.getUniqueId());
        long l2 = lastTime = l != null ? l : 0L;
        if (now - lastTime >= (long)this.errorCooldown) {
            LoggingKt.error((CommandSender)((CommandSender)player), (Object)gondola.getRawNoAccessMessage());
            Long l3 = now;
            this.lastErrorTime.put(player.getUniqueId(), l3);
        }
    }

    private final void handleWarpCooldown(Player player, GondolaData data, long now) {
        Pair<String, Long> entry = this.playerZoneEntry.get(player.getUniqueId());
        Pair<String, Long> pair = entry;
        if (!Intrinsics.areEqual((Object)(pair != null ? (String)pair.getFirst() : null), (Object)data.getId())) {
            this.playerZoneEntry.put(player.getUniqueId(), (Pair<String, Long>)TuplesKt.to((Object)data.getId(), (Object)now));
        } else if (now - ((Number)entry.getSecond()).longValue() >= data.getGondola().getWarpCooldown()) {
            GondolasHelpersKt.gondolaWarp(data.getGondola(), player, data.getType());
            this.playerZoneEntry.remove(player.getUniqueId());
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
            this.justWarped.add(uUID);
        } else {
            long remainingSeconds = (data.getGondola().getWarpCooldown() - (now - ((Number)entry.getSecond()).longValue())) / (long)1000;
            player.sendActionBar("Warping in " + remainingSeconds + " seconds...");
        }
    }

    private static final GondolaData onPlayerMove$lambda$0(PlayerMoveEvent $this_onPlayerMove, Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        String id = (String)entry.getKey();
        Gondola gondola = (Gondola)entry.getValue();
        Location location = $this_onPlayerMove.getPlayer().getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        return GondolasHelpersKt.getClosestGondolaData(gondola, location, id);
    }
}

