/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.features.gondolas;

import com.mineinabyss.components.gondolas.Gondola;
import com.mineinabyss.features.gondolas.GondolaData;
import com.mineinabyss.features.gondolas.GondolaType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e\u001a\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0014"}, d2={"gondolaWarp", "", "gondola", "Lcom/mineinabyss/components/gondolas/Gondola;", "player", "Lorg/bukkit/entity/Player;", "gondolaType", "Lcom/mineinabyss/features/gondolas/GondolaType;", "locContains", "", "loc", "Lorg/bukkit/Location;", "point", "radius", "", "getClosestGondolaData", "Lcom/mineinabyss/features/gondolas/GondolaData;", "location", "id", "", "mineinabyss-features"})
public final class GondolasHelpersKt {
    public static final void gondolaWarp(@NotNull Gondola gondola, @NotNull Player player, @NotNull GondolaType gondolaType) {
        Intrinsics.checkNotNullParameter((Object)gondola, (String)"gondola");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)((Object)gondolaType), (String)"gondolaType");
        Location loc = gondolaType == GondolaType.LOWER ? gondola.getUpperLoc() : gondola.getLowerLoc();
        player.teleportAsync(loc);
    }

    public static final boolean locContains(@NotNull Location loc, @NotNull Location point, double radius) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return loc.distanceSquared(point) <= radius * radius;
    }

    @NotNull
    public static final GondolaData getClosestGondolaData(@NotNull Gondola gondola, @NotNull Location location, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)gondola, (String)"gondola");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        double radius = gondola.getWarpZoneRange();
        Location upperLoc = gondola.getUpperLoc();
        Location lowerLoc = gondola.getLowerLoc();
        if (GondolasHelpersKt.locContains(upperLoc, location, radius)) {
            return new GondolaData(id, gondola, GondolaType.UPPER);
        }
        if (GondolasHelpersKt.locContains(lowerLoc, location, radius)) {
            return new GondolaData(id, gondola, GondolaType.LOWER);
        }
        return new GondolaData(id, gondola, GondolaType.NONE);
    }
}

