/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.features.tools.sickle;

import com.mineinabyss.features.helpers.ItemDrop;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"harvestPlant", "", "block", "Lorg/bukkit/block/Block;", "player", "Lorg/bukkit/entity/Player;", "mineinabyss-features"})
@SourceDebugExtension(value={"SMAP\nSickleListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SickleListener.kt\ncom/mineinabyss/features/tools/sickle/SickleListenerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1863#2,2:104\n1#3:106\n*S KotlinDebug\n*F\n+ 1 SickleListener.kt\ncom/mineinabyss/features/tools/sickle/SickleListenerKt\n*L\n92#1:104,2\n*E\n"})
public final class SickleListenerKt {
    public static final boolean harvestPlant(@NotNull Block block, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInMainHand(...)");
        ItemStack handItem = itemStack;
        BlockData blockData = block.getBlockData();
        Intrinsics.checkNotNullExpressionValue((Object)blockData, (String)"getBlockData(...)");
        BlockData data = blockData;
        if (handItem.getType() == Material.SHEARS) {
            return false;
        }
        if (handItem.getType() == block.getType()) {
            return false;
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Material.WHEAT, (Object)SetsKt.setOf((Object)new ItemDrop(Material.WHEAT, new IntRange(1, 3), false, 4, null))), TuplesKt.to((Object)Material.CARROTS, (Object)SetsKt.setOf((Object)new ItemDrop(Material.CARROT, new IntRange(1, 3), false, 4, null))), TuplesKt.to((Object)Material.POTATOES, (Object)SetsKt.setOf((Object)new ItemDrop(Material.POTATO, new IntRange(1, 3), false, 4, null))), TuplesKt.to((Object)Material.BEETROOTS, (Object)SetsKt.setOf((Object)new ItemDrop(Material.BEETROOT, new IntRange(1, 3), false, 4, null))), TuplesKt.to((Object)Material.NETHER_WART, (Object)SetsKt.setOf((Object)new ItemDrop(Material.NETHER_WART, new IntRange(1, 3), false, 4, null))), TuplesKt.to((Object)Material.COCOA, (Object)SetsKt.setOf((Object)new ItemDrop(Material.COCOA_BEANS, new IntRange(1, 3), false, 4, null))), TuplesKt.to((Object)Material.MELON, (Object)SetsKt.setOf((Object)new ItemDrop(Material.MELON_SLICE, new IntRange(1, 3), false, 4, null))), TuplesKt.to((Object)Material.PUMPKIN, (Object)SetsKt.setOf((Object)new ItemDrop(Material.PUMPKIN, new IntRange(1, 1), false)))};
        Map blockList = MapsKt.mapOf((Pair[])pairArray);
        Set set = (Set)blockList.get(block.getType());
        if (set == null) {
            return false;
        }
        Set drops = set;
        if (data instanceof Ageable) {
            if (((Ageable)data).getAge() != ((Ageable)data).getMaximumAge()) {
                return false;
            }
            if (!new BlockBreakEvent(block, player).callEvent()) {
                return false;
            }
            ((Ageable)data).setAge(0);
            block.setBlockData(data);
        } else {
            if (!new BlockBreakEvent(block, player).callEvent()) {
                return false;
            }
            block.setType(Material.AIR);
        }
        Iterable $this$forEach$iv = drops;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemDrop drop = (ItemDrop)element$iv;
            boolean bl = false;
            block.getWorld().dropItemNaturally(block.getLocation(), new ItemStack(drop.getMaterial(), drop.getApplyFortune() ? SickleListenerKt.harvestPlant$applyFortune(handItem, RangesKt.random((IntRange)drop.getDropAmount(), (Random)((Random)Random.Default))) : RangesKt.random((IntRange)drop.getDropAmount(), (Random)((Random)Random.Default))));
        }
        return true;
    }

    private static final int harvestPlant$applyFortune(ItemStack handItem, int count) {
        if (!Tag.ITEMS_HOES.getValues().contains(handItem.getType())) {
            return count;
        }
        Integer n = handItem.getEnchantmentLevel(Enchantment.FORTUNE);
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it > 0 ? n : null;
        if (n2 == null) {
            return count;
        }
        int level = n2;
        return Random.Default.nextDouble() > (double)(2 / (level + 2)) ? count + RangesKt.random((IntRange)new IntRange(2, level + 1), (Random)((Random)Random.Default)) : count;
    }
}

