/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.features.okibotravel;

import co.touchlab.kermit.BaseLogger;
import co.touchlab.kermit.Severity;
import com.bergerkiller.bukkit.tc.TrainCarts;
import com.bergerkiller.bukkit.tc.controller.MinecartGroup;
import com.bergerkiller.bukkit.tc.controller.spawnable.SpawnableGroup;
import com.bergerkiller.bukkit.tc.pathfinding.PathConnection;
import com.bergerkiller.bukkit.tc.pathfinding.PathNode;
import com.bergerkiller.bukkit.tc.pathfinding.PathWorld;
import com.bergerkiller.bukkit.tc.properties.standard.type.CollisionOptions;
import com.mineinabyss.components.okibotravel.OkiboLineStation;
import com.mineinabyss.features.AbyssContextKt;
import com.mineinabyss.features.helpers.di.Features;
import com.mineinabyss.features.okibotravel.OkiboTravelConfig;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u001a\u0019\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\t\u001a\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u0005*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\"\u0015\u0010\n\u001a\u00020\u000b*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\"\u0017\u0010\r\u001a\u0004\u0018\u00010\u0005*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"spawnOkiboCart", "", "player", "Lorg/bukkit/entity/Player;", "station", "Lcom/mineinabyss/components/okibotravel/OkiboLineStation;", "destination", "costTo", "", "(Lcom/mineinabyss/components/okibotravel/OkiboLineStation;Lcom/mineinabyss/components/okibotravel/OkiboLineStation;)Ljava/lang/Integer;", "isSubStation", "", "(Lcom/mineinabyss/components/okibotravel/OkiboLineStation;)Z", "parentStation", "getParentStation", "(Lcom/mineinabyss/components/okibotravel/OkiboLineStation;)Lcom/mineinabyss/components/okibotravel/OkiboLineStation;", "nextStation", "mineinabyss-features"})
@SourceDebugExtension(value={"SMAP\nHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Helpers.kt\ncom/mineinabyss/features/okibotravel/HelpersKt\n+ 2 Logger.kt\nco/touchlab/kermit/Logger\n+ 3 BaseLogger.kt\nco/touchlab/kermit/BaseLogger\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,49:1\n71#2,3:50\n74#2:62\n54#3,9:53\n1755#4,3:63\n295#4,2:66\n1#5:68\n*S KotlinDebug\n*F\n+ 1 Helpers.kt\ncom/mineinabyss/features/okibotravel/HelpersKt\n*L\n29#1:50,3\n29#1:62\n29#1:53,9\n40#1:63,3\n41#1:66,2\n*E\n"})
public final class HelpersKt {
    /*
     * WARNING - void declaration
     */
    public static final void spawnOkiboCart(@NotNull Player player, @NotNull OkiboLineStation station, @NotNull OkiboLineStation destination) {
        void this_$iv$iv;
        void $this$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)station, (String)"station");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        OkiboLineStation okiboLineStation = HelpersKt.nextStation(station, destination);
        if (okiboLineStation == null || (okiboLineStation = okiboLineStation.getLocation()) == null || (okiboLineStation = okiboLineStation.toVector()) == null || (okiboLineStation = okiboLineStation.subtract(station.getLocation().toVector())) == null || (okiboLineStation = okiboLineStation.normalize()) == null) {
            Vector vector = station.getLocation().getDirection();
            okiboLineStation = vector;
            Intrinsics.checkNotNullExpressionValue((Object)vector, (String)"getDirection(...)");
        }
        OkiboLineStation direction = okiboLineStation;
        SpawnableGroup spawnGroup = SpawnableGroup.parse((TrainCarts)TrainCarts.plugin, (String)"OkiboCartPaid");
        SpawnableGroup.SpawnLocationList spawnLocations = spawnGroup.findSpawnLocations(station.getLocation(), (Vector)direction, SpawnableGroup.SpawnMode.DEFAULT);
        MinecartGroup train = spawnGroup.spawn(spawnLocations);
        train.head().addPassengerForced((Entity)player);
        train.getProperties().setDestination(destination.getId());
        String[] stringArray = new String[]{"paid"};
        train.getProperties().addTags(stringArray);
        train.getProperties().setOwner(player.getName(), true);
        train.getProperties().setSpeedLimit(1.0);
        train.getProperties().setSlowingDown(false);
        train.getProperties().setCollision(CollisionOptions.CANCEL);
        train.getProperties().setPlayerTakeable(false);
        train.getProperties().setManualMovementAllowed(true);
        stringArray = (String[])AbyssContextKt.getAbyss().getLogger();
        String messageString$iv = "A train has been spawned at " + station.getId() + " and is heading to " + destination.getId() + "!";
        Throwable throwable$iv = null;
        String tag$iv = $this$iv.getTag();
        boolean $i$f$i = false;
        BaseLogger baseLogger = (BaseLogger)$this$iv;
        Severity severity$iv$iv = Severity.Info;
        boolean $i$f$log = false;
        if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
            this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
        }
    }

    @Nullable
    public static final Integer costTo(@NotNull OkiboLineStation $this$costTo, @NotNull OkiboLineStation destination) {
        Intrinsics.checkNotNullParameter((Object)$this$costTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        PathWorld trainWorld = TrainCarts.plugin.getPathProvider().getWorld($this$costTo.getLocation().getWorld());
        PathNode pathNode = trainWorld.getNodeByName($this$costTo.getId());
        if (pathNode == null && (pathNode = trainWorld.getNodeAtRail($this$costTo.getLocation().getBlock())) == null) {
            return null;
        }
        PathNode startNode = pathNode;
        PathNode pathNode2 = trainWorld.getNodeByName(destination.getId());
        if (pathNode2 == null && (pathNode2 = trainWorld.getNodeAtRail(destination.getLocation().getBlock())) == null) {
            return null;
        }
        PathNode destNode = pathNode2;
        PathConnection pathConnection = startNode.findConnection(destNode);
        return pathConnection != null ? Integer.valueOf(MathKt.roundToInt((double)(pathConnection.distance * ((OkiboTravelConfig)Features.INSTANCE.getOkiboLine().getConfig()).getCostPerKM() / (double)1000))) : null;
    }

    public static final boolean isSubStation(@NotNull OkiboLineStation $this$isSubStation) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isSubStation, (String)"<this>");
            Iterable $this$any$iv = ((OkiboTravelConfig)Features.INSTANCE.getOkiboLine().getConfig()).getOkiboStations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    OkiboLineStation it = (OkiboLineStation)element$iv;
                    boolean bl2 = false;
                    if (!it.getSubStations().contains($this$isSubStation)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public static final OkiboLineStation getParentStation(@NotNull OkiboLineStation $this$parentStation) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$parentStation, (String)"<this>");
            Iterable $this$firstOrNull$iv = ((OkiboTravelConfig)Features.INSTANCE.getOkiboLine().getConfig()).getOkiboStations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                OkiboLineStation it = (OkiboLineStation)element$iv;
                boolean bl = false;
                if (!it.getSubStations().contains($this$parentStation)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public static final OkiboLineStation nextStation(@NotNull OkiboLineStation $this$nextStation, @NotNull OkiboLineStation destination) {
        Object v3;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$nextStation, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            PathWorld it = TrainCarts.plugin.getPathProvider().getWorld($this$nextStation.getLocation().getWorld());
            boolean bl = false;
            PathNode pathNode = it.getNodeByName($this$nextStation.getId());
            if (pathNode == null) {
                return null;
            }
            PathNode pathNode2 = it.getNodeByName(destination.getId());
            if (pathNode2 == null) {
                return null;
            }
            Pair pair = TuplesKt.to((Object)pathNode, (Object)pathNode2);
            PathNode startNode = (PathNode)pair.component1();
            PathNode endNode = (PathNode)pair.component2();
            PathConnection[] pathConnectionArray = startNode.findRoute(endNode);
            Intrinsics.checkNotNullExpressionValue((Object)pathConnectionArray, (String)"findRoute(...)");
            String nextStation = ((PathConnection)ArraysKt.first((Object[])((Object[])pathConnectionArray))).destination.getName();
            Iterable iterable = ((OkiboTravelConfig)Features.INSTANCE.getOkiboLine().getConfig()).getAllStations();
            for (Object t : iterable) {
                OkiboLineStation it2 = (OkiboLineStation)t;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it2.getId(), (Object)nextStation)) continue;
                v3 = t;
                break block3;
            }
            v3 = null;
        }
        return v3;
    }
}

