/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.features.npc.shopkeeping;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.CompositionLocal;
import androidx.compose.runtime.RecomposeScopeImplKt;
import androidx.compose.runtime.ScopeUpdateScope;
import androidx.compose.runtime.internal.ComposableLambdaKt;
import com.mineinabyss.components.PlayerData;
import com.mineinabyss.components.PlayerDataKt;
import com.mineinabyss.components.npc.shopkeeping.ShopCurrency;
import com.mineinabyss.components.npc.shopkeeping.ShopTrade;
import com.mineinabyss.components.npc.shopkeeping.ShopTradeAction;
import com.mineinabyss.components.npc.shopkeeping.TradeAction;
import com.mineinabyss.features.AbyssContextKt;
import com.mineinabyss.features.helpers.CoinFactory;
import com.mineinabyss.features.helpers.LuckPermsHelpersKt;
import com.mineinabyss.guiy.components.ItemKt;
import com.mineinabyss.guiy.components.SpacerKt;
import com.mineinabyss.guiy.components.canvases.InventoryKt;
import com.mineinabyss.guiy.layout.RowKt;
import com.mineinabyss.guiy.modifiers.Modifier;
import com.mineinabyss.guiy.modifiers.click.ClickModifierKt;
import com.mineinabyss.guiy.modifiers.click.ClickScope;
import com.mineinabyss.idofront.messaging.LoggingKt;
import com.mineinabyss.idofront.serialization.BaseSerializableItemStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.luckperms.api.model.data.NodeMap;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.Node;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001c\u0010\u0007\u001a\u00020\u0006*\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u0001\u001a\u001b\u0010\u000b\u001a\t\u0018\u00010\u0001\u00a2\u0006\u0002\b\f*\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u0001\u001a&\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0018\u00010\u0001\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\u00100\u000f*\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u0001\u001a\u0014\u0010\u0011\u001a\u00020\u0006*\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u0001\u001a\u001e\u0010\u0012\u001a\u0004\u0018\u00010\u0001*\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0013\u001a\u00020\u0006\u001a.\u0010\u0014\u001a\u00020\u0015*\u0017\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\t0\u00190\u000f2\u0006\u0010\u001a\u001a\u00020\bH\u0007\u00a2\u0006\u0002\u0010\u001b\u00a8\u0006\u001c"}, d2={"getShopTradeCoin", "Lorg/bukkit/inventory/ItemStack;", "type", "Lcom/mineinabyss/components/npc/shopkeeping/ShopCurrency;", "stack", "cost", "", "getShopTradeCost", "Lorg/bukkit/entity/Player;", "currencyType", "currencyStack", "getFirstSimilarItem", "Lorg/jetbrains/annotations/Nullable;", "item", "getSimilarItems", "", "Lkotlin/jvm/internal/EnhancedNullability;", "getSimilarItemAmount", "adjustItemStackAmountFromCost", "c", "handleTrades", "", "Lcom/mineinabyss/components/npc/shopkeeping/ShopTrade;", "Lkotlinx/serialization/Serializable;", "with", "Lcom/mineinabyss/components/npc/shopkeeping/ShopTradeSerializer;", "player", "(Ljava/util/List;Lorg/bukkit/entity/Player;Landroidx/compose/runtime/Composer;I)V", "mineinabyss-features"})
@SourceDebugExtension(value={"SMAP\nShopHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShopHelpers.kt\ncom/mineinabyss/features/npc/shopkeeping/ShopHelpersKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Button.kt\ncom/mineinabyss/features/helpers/ui/composables/ButtonKt\n+ 6 CompositionLocal.kt\nandroidx/compose/runtime/CompositionLocal\n*L\n1#1,155:1\n1310#2,2:156\n3829#2:158\n4344#2,2:159\n1#3:161\n1863#4,2:162\n1863#4:164\n1864#4:184\n13#5,7:165\n20#5,11:173\n74#6:172\n*S KotlinDebug\n*F\n+ 1 ShopHelpers.kt\ncom/mineinabyss/features/npc/shopkeeping/ShopHelpersKt\n*L\n59#1:156,2\n60#1:158\n60#1:159,2\n65#1:162,2\n85#1:164\n85#1:184\n90#1:165,7\n90#1:173,11\n90#1:172\n*E\n"})
public final class ShopHelpersKt {
    @Nullable
    public static final ItemStack getShopTradeCoin(@NotNull ShopCurrency type, @Nullable ItemStack stack, int cost) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> {
                ItemStack v0 = CoinFactory.INSTANCE.getOrthCoin();
                if (v0 != null) {
                    yield v0.asQuantity(cost);
                }
                yield null;
            }
            case 2 -> {
                ItemStack v2 = CoinFactory.INSTANCE.getMittyToken();
                if (v2 != null) {
                    yield v2.asQuantity(cost);
                }
                yield null;
            }
            case 3 -> {
                ItemStack v3 = stack;
                if (v3 != null) {
                    yield v3.asQuantity(cost);
                }
                yield null;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final int getShopTradeCost(@NotNull Player $this$getShopTradeCost, @NotNull ShopCurrency currencyType, @Nullable ItemStack currencyStack) {
        Intrinsics.checkNotNullParameter((Object)$this$getShopTradeCost, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)currencyType, (String)"currencyType");
        return switch (WhenMappings.$EnumSwitchMapping$0[currencyType.ordinal()]) {
            case 1 -> PlayerDataKt.getPlayerData((Player)$this$getShopTradeCost).getOrthCoinsHeld();
            case 2 -> PlayerDataKt.getPlayerData((Player)$this$getShopTradeCost).getMittyTokensHeld();
            case 3 -> ShopHelpersKt.getSimilarItemAmount($this$getShopTradeCost, currencyStack);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Nullable
    public static final ItemStack getFirstSimilarItem(@NotNull Player $this$getFirstSimilarItem, @Nullable ItemStack item) {
        Object object;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$getFirstSimilarItem, (String)"<this>");
            ItemStack[] itemStackArray = $this$getFirstSimilarItem.getInventory().getContents();
            Intrinsics.checkNotNullExpressionValue((Object)itemStackArray, (String)"getContents(...)");
            Object[] $this$firstOrNull$iv = itemStackArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ItemStack i = (ItemStack)element$iv;
                boolean bl = false;
                ItemStack itemStack = i;
                if (!(itemStack != null ? itemStack.isSimilar(item) : false)) continue;
                object = element$iv;
                break block1;
            }
            object = null;
        }
        return (ItemStack)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ItemStack> getSimilarItems(@NotNull Player $this$getSimilarItems, @Nullable ItemStack item) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getSimilarItems, (String)"<this>");
        ItemStack[] itemStackArray = $this$getSimilarItems.getInventory().getContents();
        Intrinsics.checkNotNullExpressionValue((Object)itemStackArray, (String)"getContents(...)");
        Object[] $this$filter$iv = itemStackArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            ItemStack i = (ItemStack)element$iv$iv;
            boolean bl = false;
            if (!(i != null && i.isSimilar(item))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public static final int getSimilarItemAmount(@NotNull Player $this$getSimilarItemAmount, @Nullable ItemStack item) {
        Intrinsics.checkNotNullParameter((Object)$this$getSimilarItemAmount, (String)"<this>");
        Iterable iterable = ShopHelpersKt.getSimilarItems($this$getSimilarItemAmount, item);
        int n = 0;
        for (Object t : iterable) {
            void it;
            ItemStack itemStack = (ItemStack)t;
            int n2 = n;
            boolean bl = false;
            void v0 = it;
            int n3 = v0 != null ? v0.getAmount() : 0;
            n = n2 + n3;
        }
        return n;
    }

    @Nullable
    public static final ItemStack adjustItemStackAmountFromCost(@NotNull Player $this$adjustItemStackAmountFromCost, @Nullable ItemStack item, int c) {
        Intrinsics.checkNotNullParameter((Object)$this$adjustItemStackAmountFromCost, (String)"<this>");
        int cost = 0;
        cost = c;
        if (item == null || ShopHelpersKt.getSimilarItemAmount($this$adjustItemStackAmountFromCost, item) < c) {
            return null;
        }
        Iterable $this$forEach$iv = ShopHelpersKt.getSimilarItems($this$adjustItemStackAmountFromCost, item);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemStack stack = (ItemStack)element$iv;
            boolean bl = false;
            if (stack == null) continue;
            int amount = stack.getAmount();
            if (amount > cost) {
                stack.subtract(cost);
                return stack;
            }
            cost -= amount;
            stack.subtract(amount);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Composable
    public static final void handleTrades(@NotNull List<ShopTrade> $this$handleTrades, @NotNull Player player, @Nullable Composer $composer, int $changed) {
        block8: {
            Intrinsics.checkNotNullParameter($this$handleTrades, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            $composer = $composer.startRestartGroup(-93119647);
            int $dirty = $changed;
            if (($changed & 6) == 0) {
                $dirty |= $composer.changedInstance($this$handleTrades) ? 4 : 2;
            }
            if (($changed & 0x30) == 0) {
                $dirty |= $composer.changedInstance((Object)player) ? 32 : 16;
            }
            if (($dirty & 0x13) != 18 || !$composer.getSkipping()) {
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventStart((int)-93119647, (int)$dirty, (int)-1, (String)"com.mineinabyss.features.npc.shopkeeping.handleTrades (ShopHelpers.kt:82)");
                }
                PlayerData data = PlayerDataKt.getPlayerData((Player)player);
                Iterable $this$forEach$iv = $this$handleTrades;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ItemStack coin;
                    void onClick$iv;
                    void this_$iv$iv;
                    BaseSerializableItemStack currencyStack;
                    ShopTrade shopTrade = (ShopTrade)element$iv;
                    boolean bl = false;
                    BaseSerializableItemStack item = shopTrade.component1();
                    BaseSerializableItemStack currency = shopTrade.component2();
                    ShopCurrency currencyType = shopTrade.component3();
                    int cost = shopTrade.component4();
                    ShopTradeAction tradeAction = shopTrade.component5();
                    ItemStack tradeItem = BaseSerializableItemStack.toItemStack$default((BaseSerializableItemStack)item, null, (int)1, null);
                    BaseSerializableItemStack baseSerializableItemStack = currency;
                    if (baseSerializableItemStack == null || (baseSerializableItemStack = BaseSerializableItemStack.toItemStack$default((BaseSerializableItemStack)baseSerializableItemStack, null, (int)1, null)) == null) {
                        if (currencyType == ShopCurrency.ITEM) continue;
                        baseSerializableItemStack = null;
                    }
                    if (ShopHelpersKt.getShopTradeCoin(currencyType, (ItemStack)(currencyStack = baseSerializableItemStack), cost) == null) continue;
                    Function0 function0 = () -> ShopHelpersKt.handleTrades$lambda$6$lambda$4(player, currencyType, (ItemStack)currencyStack, cost, data, tradeAction, tradeItem);
                    boolean $changed$iv = false;
                    boolean $i$f$Button = false;
                    $composer.startReplaceableGroup(562664606);
                    Modifier modifier$iv = (Modifier)Modifier.Companion;
                    boolean enabled$iv = true;
                    boolean playSound$iv = true;
                    CompositionLocal compositionLocal = (CompositionLocal)InventoryKt.getLocalInventory();
                    boolean $changed$iv$iv = false;
                    boolean $i$f$getCurrent = false;
                    ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)2023513938, (String)"CC:CompositionLocal.kt#9igjgp");
                    Object object = $composer.consume((CompositionLocal)this_$iv$iv);
                    ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
                    Inventory inv$iv = (Inventory)object;
                    RowKt.Row((Modifier)ClickModifierKt.clickable$default((Modifier)modifier$iv, (boolean)false, (Function1)((Function1)new Function1<ClickScope, Unit>(inv$iv, playSound$iv, enabled$iv, (Function0<Unit>)onClick$iv){
                        final /* synthetic */ Inventory $inv;
                        final /* synthetic */ boolean $playSound;
                        final /* synthetic */ boolean $enabled;
                        final /* synthetic */ Function0<Unit> $onClick;
                        {
                            this.$inv = $inv;
                            this.$playSound = $playSound;
                            this.$enabled = $enabled;
                            this.$onClick = $onClick;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(ClickScope $this$clickable) {
                            void $this$filterIsInstanceTo$iv$iv;
                            Intrinsics.checkNotNullParameter((Object)$this$clickable, (String)"$this$clickable");
                            List list = this.$inv.getViewers();
                            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getViewers(...)");
                            Iterable $this$filterIsInstance$iv = list;
                            boolean $i$f$filterIsInstance = false;
                            Iterator<T> iterator = $this$filterIsInstance$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$filterIsInstanceTo = false;
                            for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                                if (!(element$iv$iv instanceof Player)) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            List viewers = (List)destination$iv$iv;
                            if (this.$playSound) {
                                if (this.$enabled) {
                                    $this$forEach$iv = viewers;
                                    $i$f$forEach = false;
                                    for (T element$iv : $this$forEach$iv) {
                                        Player it = (Player)element$iv;
                                        boolean bl = false;
                                        it.playSound(it.getLocation(), Sound.ITEM_ARMOR_EQUIP_GENERIC, 1.0f, 1.0f);
                                    }
                                } else {
                                    $this$forEach$iv = viewers;
                                    $i$f$forEach = false;
                                    for (T element$iv : $this$forEach$iv) {
                                        Player it = (Player)element$iv;
                                        boolean bl = false;
                                        it.playSound(it.getLocation(), Sound.BLOCK_LEVER_CLICK, 1.0f, 1.0f);
                                    }
                                }
                            }
                            if (this.$enabled) {
                                this.$onClick.invoke();
                            }
                        }
                    }), (int)1, null), null, null, (Function2)((Function2)ComposableLambdaKt.composableLambda((Composer)$composer, (int)-1484475990, (boolean)true, (Object)new Function2<Composer, Integer, Unit>(enabled$iv, coin, tradeItem){
                        final /* synthetic */ boolean $enabled;
                        final /* synthetic */ ItemStack $coin$inlined;
                        final /* synthetic */ ItemStack $tradeItem$inlined;
                        {
                            this.$enabled = $enabled;
                            this.$coin$inlined = itemStack;
                            this.$tradeItem$inlined = itemStack2;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @Composable
                        public final void invoke(Composer $composer, int $changed) {
                            if (($changed & 3) != 2 || !$composer.getSkipping()) {
                                void $composer2;
                                if (ComposerKt.isTraceInProgress()) {
                                    ComposerKt.traceEventStart((int)-1484475990, (int)$changed, (int)-1, (String)"com.mineinabyss.features.helpers.ui.composables.Button.<anonymous> (Button.kt:27)");
                                }
                                boolean bl = false;
                                Composer composer = $composer;
                                boolean it = this.$enabled;
                                boolean bl2 = false;
                                $composer2.startReplaceableGroup(1161438080);
                                ItemKt.Item((ItemStack)this.$coin$inlined, null, (Composer)$composer2, (int)0, (int)2);
                                SpacerKt.Spacer((Integer)1, null, null, (Composer)$composer2, (int)6, (int)6);
                                ItemKt.Item((ItemStack)this.$tradeItem$inlined, null, (Composer)$composer2, (int)0, (int)2);
                                $composer2.endReplaceableGroup();
                                if (ComposerKt.isTraceInProgress()) {
                                    ComposerKt.traceEventEnd();
                                }
                            } else {
                                $composer.skipToGroupEnd();
                            }
                        }
                    })), (Composer)$composer, (int)3072, (int)6);
                    $composer.endReplaceableGroup();
                }
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventEnd();
                }
            } else {
                $composer.skipToGroupEnd();
            }
            ScopeUpdateScope scopeUpdateScope = $composer.endRestartGroup();
            if (scopeUpdateScope == null) break block8;
            scopeUpdateScope.updateScope((arg_0, arg_1) -> ShopHelpersKt.handleTrades$lambda$7($this$handleTrades, player, $changed, arg_0, arg_1));
        }
    }

    private static final Unit handleTrades$lambda$6$lambda$4(Player $player, ShopCurrency $currencyType, ItemStack $currencyStack, int $cost, PlayerData $data, ShopTradeAction $tradeAction, ItemStack $tradeItem) {
        if (ShopHelpersKt.getShopTradeCost($player, $currencyType, $currencyStack) < $cost) {
            CommandSender commandSender = (CommandSender)$player;
            String string = $currencyType.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            LoggingKt.error((CommandSender)commandSender, (Object)("You don't have enough " + string + "'s!"));
            $player.playSound((Entity)$player, Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            return Unit.INSTANCE;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[$currencyType.ordinal()]) {
            case 1: {
                $data.setOrthCoinsHeld($data.getOrthCoinsHeld() - $cost);
                break;
            }
            case 2: {
                $data.setMittyTokensHeld($data.getMittyTokensHeld() - $cost);
                break;
            }
            case 3: {
                ShopHelpersKt.adjustItemStackAmountFromCost($player, $currencyStack, $cost);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$1[$tradeAction.getAction().ordinal()]) {
            case 1: {
                if ($player.getInventory().firstEmpty() != -1) {
                    ItemStack[] itemStackArray = new ItemStack[]{$tradeItem};
                    $player.getInventory().addItem(itemStackArray);
                    $player.playSound((Entity)$player, Sound.ENTITY_VILLAGER_CELEBRATE, 1.0f, 1.0f);
                    break;
                }
                LoggingKt.error((CommandSender)((CommandSender)$player), (Object)"Your inventory is full!");
                $player.playSound((Entity)$player, Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                break;
            }
            case 2: {
                if ($player.performCommand($tradeAction.getValue($player))) {
                    $player.playSound((Entity)$player, Sound.ENTITY_VILLAGER_CELEBRATE, 1.0f, 1.0f);
                    break;
                }
                LoggingKt.error((CommandSender)((CommandSender)$player), (Object)"Failed to execute command!");
                break;
            }
            case 3: {
                AbyssContextKt.getAbyss().getPlugin().getServer().dispatchCommand((CommandSender)AbyssContextKt.getAbyss().getPlugin().getServer().getConsoleSender(), $tradeAction.getValue($player));
                break;
            }
            case 4: {
                String permission = ShopTradeAction.getValue$default((ShopTradeAction)$tradeAction, null, (int)1, null);
                if (!$player.hasPermission(permission)) {
                    NodeMap nodeMap;
                    User user = LuckPermsHelpersKt.getLuckPerms().getUserManager().getUser($player.getUniqueId());
                    if (user != null && (nodeMap = user.data()) != null) {
                        nodeMap.add((Node)Node.builder((String)permission).build());
                    }
                    $player.playSound((Entity)$player, Sound.ENTITY_VILLAGER_CELEBRATE, 1.0f, 1.0f);
                    break;
                }
                LoggingKt.error((CommandSender)((CommandSender)$player), (Object)"You already have this permission!");
                $player.playSound((Entity)$player, Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$0[$currencyType.ordinal()]) {
            case 1: {
                $data.setOrthCoinsHeld($data.getOrthCoinsHeld() - $cost);
                ItemStack itemStack = Unit.INSTANCE;
                break;
            }
            case 2: {
                $data.setMittyTokensHeld($data.getMittyTokensHeld() - $cost);
                ItemStack itemStack = Unit.INSTANCE;
                break;
            }
            case 3: {
                ItemStack itemStack = ShopHelpersKt.adjustItemStackAmountFromCost($player, $currencyStack, $cost);
                if (itemStack != null) break;
                return Unit.INSTANCE;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit handleTrades$lambda$7(List $this_handleTrades, Player $player, int $$changed, Composer $composer, int $force) {
        ShopHelpersKt.handleTrades($this_handleTrades, $player, $composer, RecomposeScopeImplKt.updateChangedFlags((int)($$changed | 1)));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ShopCurrency.values().length];
            try {
                nArray[ShopCurrency.ORTH_COIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShopCurrency.MITTY_TOKEN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShopCurrency.ITEM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TradeAction.values().length];
            try {
                nArray[TradeAction.GIVE_ITEM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeAction.PLAYER_COMMAND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeAction.CONSOLE_COMMAND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeAction.GRANT_PERMISSION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

