/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.features.layers;

import androidx.compose.runtime.internal.StabilityInferred;
import com.destroystokyo.paper.event.player.PlayerPostRespawnEvent;
import com.mineinabyss.components.layer.Layer;
import com.mineinabyss.deeperworld.event.PlayerAscendEvent;
import com.mineinabyss.deeperworld.event.PlayerChangeSectionEvent;
import com.mineinabyss.deeperworld.event.PlayerDescendEvent;
import com.mineinabyss.deeperworld.services.PlayerManager;
import com.mineinabyss.deeperworld.world.section.Section;
import com.mineinabyss.deeperworld.world.section.SectionUtils;
import com.mineinabyss.features.helpers.LayerUtilsKt;
import com.mineinabyss.features.hubstorage.HubStorageHelpersKt;
import com.mineinabyss.geary.actions.ActionGroupContext;
import com.mineinabyss.geary.actions.Condition;
import com.mineinabyss.geary.actions.ConditionKt;
import com.mineinabyss.geary.datatypes.Entity;
import com.mineinabyss.geary.papermc.features.common.cooldowns.Cooldown;
import com.mineinabyss.geary.papermc.features.common.cooldowns.Cooldowns;
import com.mineinabyss.geary.papermc.tracking.entities.ConversionKt;
import com.mineinabyss.idofront.textcomponents.MiniMessageHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.title.Title;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.level.border.WorldBorder;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0007J\f\u0010\t\u001a\u00020\u0007*\u00020\nH\u0007J\f\u0010\u000b\u001a\u00020\u0007*\u00020\fH\u0002J\f\u0010\r\u001a\u00020\u0007*\u00020\bH\u0007J\f\u0010\r\u001a\u00020\u0007*\u00020\nH\u0007J\f\u0010\u000e\u001a\u00020\u0007*\u00020\u000fH\u0007J\f\u0010\u0010\u001a\u00020\u0007*\u00020\u0011H\u0007J\f\u0010\u0012\u001a\u00020\u0007*\u00020\u0013H\u0007J\u0014\u0010\u0014\u001a\u00020\u0007*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\f\u0010\u0018\u001a\u00020\u0007*\u00020\u0019H\u0007J\f\u0010\u001a\u001a\u00020\u0007*\u00020\u001bH\u0007J\f\u0010\u001c\u001a\u00020\u0007*\u00020\u001dH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/mineinabyss/features/layers/LayerListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "titleCooldown", "Lcom/mineinabyss/geary/papermc/features/common/cooldowns/Cooldown;", "onPlayerAscend", "", "Lcom/mineinabyss/deeperworld/event/PlayerAscendEvent;", "onPlayerDescend", "Lcom/mineinabyss/deeperworld/event/PlayerDescendEvent;", "sendTitleOnLayerChange", "Lcom/mineinabyss/deeperworld/event/PlayerChangeSectionEvent;", "onPlayerChangeSection", "onPlayerTeleport", "Lorg/bukkit/event/player/PlayerTeleportEvent;", "onPlayerRespawn", "Lcom/destroystokyo/paper/event/player/PlayerPostRespawnEvent;", "onPlayerJoin", "Lorg/bukkit/event/player/PlayerJoinEvent;", "sendWorldBorderPackets", "Lorg/bukkit/entity/Player;", "section", "Lcom/mineinabyss/deeperworld/world/section/Section;", "appendLayerToDeathMessage", "Lorg/bukkit/event/entity/PlayerDeathEvent;", "onFoodChange", "Lorg/bukkit/event/entity/FoodLevelChangeEvent;", "onLiquidFlow", "Lorg/bukkit/event/block/BlockFromToEvent;", "mineinabyss-features"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nLayerListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayerListener.kt\ncom/mineinabyss/features/layers/LayerListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1#2:115\n*E\n"})
public final class LayerListener
implements Listener {
    @NotNull
    private final Cooldown titleCooldown = new Cooldown(DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.SECONDS), null, "mineinabyss:layer_title", null);
    public static final int $stable = 8;

    @EventHandler
    public final void onPlayerAscend(@NotNull PlayerAscendEvent $this$onPlayerAscend) {
        Intrinsics.checkNotNullParameter((Object)$this$onPlayerAscend, (String)"<this>");
        this.sendTitleOnLayerChange((PlayerChangeSectionEvent)$this$onPlayerAscend);
    }

    @EventHandler(ignoreCancelled=true)
    public final void onPlayerDescend(@NotNull PlayerDescendEvent $this$onPlayerDescend) {
        Intrinsics.checkNotNullParameter((Object)$this$onPlayerDescend, (String)"<this>");
        this.sendTitleOnLayerChange((PlayerChangeSectionEvent)$this$onPlayerDescend);
    }

    private final void sendTitleOnLayerChange(PlayerChangeSectionEvent $this$sendTitleOnLayerChange) {
        Layer layer;
        Player player = $this$sendTitleOnLayerChange.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        if (!PlayerManager.Companion.playerCanTeleport(player)) {
            return;
        }
        Player player2 = $this$sendTitleOnLayerChange.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"getPlayer(...)");
        Entity entity = ConversionKt.toGearyOrNull((org.bukkit.entity.Entity)((org.bukkit.entity.Entity)player2));
        if (entity == null) {
            return;
        }
        Entity gearyPlayer = entity;
        if (!Cooldowns.Companion.isComplete(gearyPlayer, "mineinabyss:layer_title")) {
            return;
        }
        Layer layer2 = LayerUtilsKt.getLayer($this$sendTitleOnLayerChange.getFromSection());
        if (layer2 == null) {
            return;
        }
        Layer fromLayer = layer2;
        Layer it = layer = LayerUtilsKt.getLayer($this$sendTitleOnLayerChange.getToSection());
        boolean bl = false;
        Object object = !Intrinsics.areEqual((Object)it, (Object)fromLayer) ? layer : null;
        if (object == null) {
            return;
        }
        Layer toLayer = object;
        long l = DurationKt.toDuration((double)2.5, (DurationUnit)DurationUnit.SECONDS);
        int n = Duration.getNanosecondsComponent-impl((long)l);
        long l2 = Duration.getInWholeSeconds-impl((long)l);
        java.time.Duration duration = java.time.Duration.ofSeconds(l2, n);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"toComponents-impl(...)");
        l = DurationKt.toDuration((double)0.5, (DurationUnit)DurationUnit.SECONDS);
        n = Duration.getNanosecondsComponent-impl((long)l);
        l2 = Duration.getInWholeSeconds-impl((long)l);
        java.time.Duration duration2 = java.time.Duration.ofSeconds(l2, n);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"toComponents-impl(...)");
        l = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS);
        n = Duration.getNanosecondsComponent-impl((long)l);
        l2 = Duration.getInWholeSeconds-impl((long)l);
        java.time.Duration duration3 = java.time.Duration.ofSeconds(l2, n);
        Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"toComponents-impl(...)");
        Title.Times times = Title.Times.times((java.time.Duration)duration, (java.time.Duration)duration2, (java.time.Duration)duration3);
        Intrinsics.checkNotNullExpressionValue((Object)times, (String)"times(...)");
        Title.Times times2 = times;
        $this$sendTitleOnLayerChange.getPlayer().showTitle(Title.title((Component)MiniMessageHelpersKt.miniMsg$default((String)toLayer.getName(), null, (int)1, null), (Component)MiniMessageHelpersKt.miniMsg$default((String)toLayer.getSub(), null, (int)1, null), (Title.Times)times2));
        ConditionKt.execute((Condition)((Condition)this.titleCooldown), (ActionGroupContext)new ActionGroupContext(gearyPlayer));
    }

    @EventHandler
    public final void onPlayerChangeSection(@NotNull PlayerAscendEvent $this$onPlayerChangeSection) {
        Intrinsics.checkNotNullParameter((Object)$this$onPlayerChangeSection, (String)"<this>");
        Player player = $this$onPlayerChangeSection.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        this.sendWorldBorderPackets(player, $this$onPlayerChangeSection.getToSection());
    }

    @EventHandler
    public final void onPlayerChangeSection(@NotNull PlayerDescendEvent $this$onPlayerChangeSection) {
        Intrinsics.checkNotNullParameter((Object)$this$onPlayerChangeSection, (String)"<this>");
        Player player = $this$onPlayerChangeSection.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        this.sendWorldBorderPackets(player, $this$onPlayerChangeSection.getToSection());
    }

    @EventHandler
    public final void onPlayerTeleport(@NotNull PlayerTeleportEvent $this$onPlayerTeleport) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$onPlayerTeleport, (String)"<this>");
            Location location = $this$onPlayerTeleport.getTo();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getTo(...)");
            Section section = SectionUtils.getSection((Location)location);
            if (section == null) {
                Location location2 = $this$onPlayerTeleport.getFrom();
                Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"getFrom(...)");
                section = SectionUtils.getSection((Location)location2);
            }
            if (section == null) break block1;
            Section it = section;
            boolean bl = false;
            Player player = $this$onPlayerTeleport.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
            this.sendWorldBorderPackets(player, it);
        }
    }

    @EventHandler
    public final void onPlayerRespawn(@NotNull PlayerPostRespawnEvent $this$onPlayerRespawn) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$onPlayerRespawn, (String)"<this>");
            Location location = $this$onPlayerRespawn.getRespawnedLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getRespawnedLocation(...)");
            Section section = SectionUtils.getSection((Location)location);
            if (section == null) break block0;
            Section it = section;
            boolean bl = false;
            Player player = $this$onPlayerRespawn.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
            this.sendWorldBorderPackets(player, it);
        }
    }

    @EventHandler
    public final void onPlayerJoin(@NotNull PlayerJoinEvent $this$onPlayerJoin) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$onPlayerJoin, (String)"<this>");
            Location location = $this$onPlayerJoin.getPlayer().getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
            Section section = SectionUtils.getSection((Location)location);
            if (section == null) break block0;
            Section it = section;
            boolean bl = false;
            Player player = $this$onPlayerJoin.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
            this.sendWorldBorderPackets(player, it);
        }
    }

    private final void sendWorldBorderPackets(Player $this$sendWorldBorderPackets, Section section) {
        WorldBorder settings = new WorldBorder();
        settings.setCenter(SectionUtils.getCenterLocation((Section)section).getX(), SectionUtils.getCenterLocation((Section)section).getZ());
        settings.setSize((double)(section.getRegion().getMax().getX() - section.getRegion().getMin().getX()) + 2.0);
        Player player = $this$sendWorldBorderPackets.getPlayer();
        Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type org.bukkit.craftbukkit.entity.CraftPlayer");
        ServerGamePacketListenerImpl connection = ((CraftPlayer)player).getHandle().connection;
        connection.send((Packet)new ClientboundSetBorderCenterPacket(settings));
        connection.send((Packet)new ClientboundSetBorderSizePacket(settings));
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public final void appendLayerToDeathMessage(@NotNull PlayerDeathEvent $this$appendLayerToDeathMessage) {
        TextComponent textComponent;
        Intrinsics.checkNotNullParameter((Object)$this$appendLayerToDeathMessage, (String)"<this>");
        Location location = $this$appendLayerToDeathMessage.getPlayer().getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        Section section = SectionUtils.getSection((Location)location);
        if (section == null || (section = LayerUtilsKt.getLayer(section)) == null) {
            return;
        }
        Section layerOfDeath = section;
        PlayerDeathEvent playerDeathEvent = $this$appendLayerToDeathMessage;
        Component component = $this$appendLayerToDeathMessage.deathMessage();
        if (component != null) {
            void it;
            Component component2 = component;
            PlayerDeathEvent playerDeathEvent2 = playerDeathEvent;
            boolean bl = false;
            ComponentLike[] componentLikeArray = new ComponentLike[]{it, Component.space(), layerOfDeath.getDeathMessage()};
            textComponent = Component.textOfChildren((ComponentLike[])componentLikeArray);
            playerDeathEvent = playerDeathEvent2;
        } else {
            textComponent = null;
        }
        playerDeathEvent.deathMessage((Component)textComponent);
    }

    @EventHandler
    public final void onFoodChange(@NotNull FoodLevelChangeEvent $this$onFoodChange) {
        Intrinsics.checkNotNullParameter((Object)$this$onFoodChange, (String)"<this>");
        HumanEntity humanEntity = $this$onFoodChange.getEntity();
        Player player = humanEntity instanceof Player ? (Player)humanEntity : null;
        if (player == null) {
            return;
        }
        Player player2 = player;
        if (HubStorageHelpersKt.isInHub((org.bukkit.entity.Entity)player2) && player2.getFoodLevel() > $this$onFoodChange.getFoodLevel()) {
            $this$onFoodChange.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onLiquidFlow(@NotNull BlockFromToEvent $this$onLiquidFlow) {
        Object object;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)$this$onLiquidFlow, (String)"<this>");
                Location location = $this$onLiquidFlow.getBlock().getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
                object = SectionUtils.getSection((Location)location);
                if (object == null || (object = LayerUtilsKt.getLayer((Section)object)) == null) break block5;
                Integer n = object.getLiquidFlowLimit();
                int it = ((Number)n).intValue();
                boolean bl = false;
                object = it > -1 ? n : null;
                if (object != null) break block6;
            }
            return;
        }
        int liquidFlowLimit = (Integer)object;
        int height = 0;
        while ($this$onLiquidFlow.getBlock().getRelative(BlockFace.UP, height).getType() == $this$onLiquidFlow.getBlock().getType()) {
            ++height;
        }
        if (height >= liquidFlowLimit) {
            $this$onLiquidFlow.setCancelled(true);
        }
    }
}

