/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.features.core;

import androidx.compose.runtime.internal.StabilityInferred;
import com.mineinabyss.features.AbyssContextKt;
import com.mineinabyss.features.AbyssFeatureConfig;
import com.mineinabyss.idofront.location.LocationUtilsKt;
import io.papermc.paper.event.player.PlayerFailMoveEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.type.BubbleColumn;
import org.bukkit.block.data.type.Light;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0007J\f\u0010\u0007\u001a\u00020\u0005*\u00020\bH\u0007J\f\u0010\t\u001a\u00020\u0005*\u00020\nH\u0007J\f\u0010\u000b\u001a\u00020\u0005*\u00020\fH\u0002J\f\u0010\r\u001a\u00020\u0005*\u00020\fH\u0002J2\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000f0\u001aH\u0002R\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0011R\u0018\u0010\u0012\u001a\u00020\u000f*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lcom/mineinabyss/features/core/CoreListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onMoveWrongly", "", "Lio/papermc/paper/event/player/PlayerFailMoveEvent;", "onMove", "Lorg/bukkit/event/vehicle/VehicleMoveEvent;", "playerMove", "Lorg/bukkit/event/player/PlayerMoveEvent;", "handleWaterfall", "Lorg/bukkit/entity/Player;", "handleBubbleColumn", "isFlowing", "", "Lorg/bukkit/block/Block;", "(Lorg/bukkit/block/Block;)Z", "isBubbleColumn", "findLocationAround", "Lorg/bukkit/Location;", "radius", "", "scale", "", "predicate", "Lkotlin/Function1;", "mineinabyss-features"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nCoreListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoreListener.kt\ncom/mineinabyss/features/core/CoreListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n808#2,11:110\n1863#2:121\n1864#2:123\n1#3:122\n*S KotlinDebug\n*F\n+ 1 CoreListener.kt\ncom/mineinabyss/features/core/CoreListener\n*L\n32#1:110,11\n32#1:121\n32#1:123\n*E\n"})
public final class CoreListener
implements Listener {
    public static final int $stable;

    @EventHandler
    public final void onMoveWrongly(@NotNull PlayerFailMoveEvent $this$onMoveWrongly) {
        Intrinsics.checkNotNullParameter((Object)$this$onMoveWrongly, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$onMoveWrongly.getFailReason().ordinal()]) {
            case 1: {
                $this$onMoveWrongly.setLogWarning(false);
                break;
            }
            case 2: {
                $this$onMoveWrongly.setLogWarning(false);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public final void onMove(@NotNull VehicleMoveEvent $this$onMove) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$onMove, (String)"<this>");
        List list = $this$onMove.getVehicle().getPassengers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPassengers(...)");
        Iterable $this$filterIsInstance$iv = list;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Player)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Location it;
            Location location;
            Player player = (Player)element$iv;
            boolean bl = false;
            if (player.getGameMode().isInvulnerable()) continue;
            Location location2 = player.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"getLocation(...)");
            Location location3 = this.findLocationAround(location2, 1, 0.3, (Function1<? super Location, Boolean>)((Function1)arg_0 -> CoreListener.onMove$lambda$4$lambda$0(this, arg_0)));
            if (location3 != null) {
                it = location = location3;
                boolean bl2 = false;
                this.handleWaterfall(player);
            }
            Location location4 = player.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location4, (String)"getLocation(...)");
            location3 = this.findLocationAround(location4, 1, 0.3, (Function1<? super Location, Boolean>)((Function1)arg_0 -> CoreListener.onMove$lambda$4$lambda$2(this, arg_0)));
            if (location3 != null) {
                it = location = location3;
                boolean bl3 = false;
                this.handleBubbleColumn(player);
            }
            if (player.isInWaterOrBubbleColumn()) continue;
            player.setMaximumAir(300);
        }
    }

    @EventHandler
    public final void playerMove(@NotNull PlayerMoveEvent $this$playerMove) {
        Location it;
        Location location;
        Intrinsics.checkNotNullParameter((Object)$this$playerMove, (String)"<this>");
        if ($this$playerMove.getPlayer().getGameMode().isInvulnerable() || !$this$playerMove.hasExplicitlyChangedBlock()) {
            return;
        }
        Location location2 = $this$playerMove.getPlayer().getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"getLocation(...)");
        Location location3 = this.findLocationAround(location2, 1, 0.3, (Function1<? super Location, Boolean>)((Function1)arg_0 -> CoreListener.playerMove$lambda$5(this, arg_0)));
        if (location3 != null) {
            it = location = location3;
            boolean bl = false;
            Player player = $this$playerMove.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
            this.handleWaterfall(player);
        }
        Location location4 = $this$playerMove.getPlayer().getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location4, (String)"getLocation(...)");
        location3 = this.findLocationAround(location4, 1, 0.3, (Function1<? super Location, Boolean>)((Function1)arg_0 -> CoreListener.playerMove$lambda$7(this, arg_0)));
        if (location3 != null) {
            it = location = location3;
            boolean bl = false;
            Player player = $this$playerMove.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
            this.handleBubbleColumn(player);
        }
        if (!$this$playerMove.getPlayer().isInWaterOrBubbleColumn()) {
            $this$playerMove.getPlayer().setMaximumAir(300);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleWaterfall(Player $this$handleWaterfall) {
        void $this$handleWaterfall_u24lambda_u249;
        Vector vector;
        $this$handleWaterfall.damage(1.0E-4);
        $this$handleWaterfall.setHealth(RangesKt.coerceAtLeast((double)($this$handleWaterfall.getHealth() - 0.25 * ((AbyssFeatureConfig)AbyssContextKt.getAbyss().getConfig()).getCore().getWaterfallDamageMultiplier()), (double)0.0));
        $this$handleWaterfall.getWorld().spawnParticle(Particle.CLOUD, $this$handleWaterfall.getLocation().add(0.0, 0.75, 0.0), 1, 0.5, 0.5, 0.5, 0.3);
        Vector vector2 = vector = $this$handleWaterfall.getVelocity();
        Player player = $this$handleWaterfall;
        boolean bl = false;
        $this$handleWaterfall_u24lambda_u249.setX(Random.Default.nextDouble(-((AbyssFeatureConfig)AbyssContextKt.getAbyss().getConfig()).getCore().getWaterfallMoveMultiplier(), ((AbyssFeatureConfig)AbyssContextKt.getAbyss().getConfig()).getCore().getWaterfallMoveMultiplier()));
        $this$handleWaterfall_u24lambda_u249.setY(-0.1);
        $this$handleWaterfall_u24lambda_u249.setZ(Random.Default.nextDouble(-((AbyssFeatureConfig)AbyssContextKt.getAbyss().getConfig()).getCore().getWaterfallMoveMultiplier(), ((AbyssFeatureConfig)AbyssContextKt.getAbyss().getConfig()).getCore().getWaterfallMoveMultiplier()));
        player.setVelocity(vector);
    }

    private final void handleBubbleColumn(Player $this$handleBubbleColumn) {
        if ($this$handleBubbleColumn.getMaximumAir() <= 0) {
            $this$handleBubbleColumn.setRemainingAir($this$handleBubbleColumn.getRemainingAir());
            $this$handleBubbleColumn.damage(1.0E-4);
            $this$handleBubbleColumn.setHealth(RangesKt.coerceAtLeast((double)($this$handleBubbleColumn.getHealth() - 0.25 * ((AbyssFeatureConfig)AbyssContextKt.getAbyss().getConfig()).getCore().getBubbleColumnDamageMultiplier()), (double)0.0));
        } else {
            $this$handleBubbleColumn.setRemainingAir($this$handleBubbleColumn.getMaximumAir() - ((AbyssFeatureConfig)AbyssContextKt.getAbyss().getConfig()).getCore().getBubbleColumnBreathMultiplier());
            $this$handleBubbleColumn.setMaximumAir(RangesKt.coerceAtLeast((int)$this$handleBubbleColumn.getRemainingAir(), (int)0));
        }
    }

    private final boolean isFlowing(Block $this$isFlowing) {
        BlockData blockData = $this$isFlowing.getBlockData();
        Levelled levelled = blockData instanceof Levelled ? (Levelled)blockData : null;
        return (levelled != null ? levelled.getLevel() : 0) >= 8 && !($this$isFlowing.getBlockData() instanceof Light);
    }

    private final boolean isBubbleColumn(Block $this$isBubbleColumn) {
        return $this$isBubbleColumn.getBlockData() instanceof BubbleColumn;
    }

    private final Location findLocationAround(Location $this$findLocationAround, int radius, double scale, Function1<? super Location, Boolean> predicate) {
        int x = -radius;
        if (x <= radius) {
            while (true) {
                int z;
                if ((z = -radius) <= radius) {
                    while (true) {
                        Location checkLoc;
                        Intrinsics.checkNotNullExpressionValue((Object)$this$findLocationAround.clone().add((double)x * scale, 0.0, (double)z * scale), (String)"add(...)");
                        if (((Boolean)predicate.invoke((Object)checkLoc)).booleanValue()) {
                            return checkLoc;
                        }
                        if (z == radius) break;
                        ++z;
                    }
                }
                if (x == radius) break;
                ++x;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean onMove$lambda$4$lambda$0(CoreListener this$0, Location it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Block block = it.getBlock();
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
        if (!this$0.isFlowing(block)) return false;
        Block block2 = LocationUtilsKt.up((Location)it, (Number)4.0).getBlock();
        Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"getBlock(...)");
        if (!this$0.isFlowing(block2)) return false;
        return true;
    }

    private static final boolean onMove$lambda$4$lambda$2(CoreListener this$0, Location it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Block block = it.clone().add(0.0, 4.0, 0.0).getBlock();
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
        return this$0.isBubbleColumn(block);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean playerMove$lambda$5(CoreListener this$0, Location it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Block block = it.getBlock();
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
        if (!this$0.isFlowing(block)) return false;
        Block block2 = LocationUtilsKt.up((Location)it, (Number)4.0).getBlock();
        Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"getBlock(...)");
        if (!this$0.isFlowing(block2)) return false;
        return true;
    }

    private static final boolean playerMove$lambda$7(CoreListener this$0, Location it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Block block = it.clone().add(0.0, 4.0, 0.0).getBlock();
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
        return this$0.isBubbleColumn(block);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PlayerFailMoveEvent.FailReason.values().length];
            try {
                nArray[PlayerFailMoveEvent.FailReason.MOVED_TOO_QUICKLY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlayerFailMoveEvent.FailReason.MOVED_WRONGLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

