/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.components.tools.grappling;

import com.mineinabyss.components.tools.grappling.GrapplingHook;
import com.mineinabyss.components.tools.grappling.PlayerGrappleKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.Job;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u001e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020!J&\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020\u001bJ\u0006\u0010)\u001a\u00020\u001fJ\u0006\u0010*\u001a\u00020!J\u0006\u0010+\u001a\u00020!J\t\u0010,\u001a\u00020\u0003H\u00c6\u0003J\t\u0010-\u001a\u00020\u0005H\u00c6\u0003J\t\u0010.\u001a\u00020\u0007H\u00c6\u0003J\t\u0010/\u001a\u00020\tH\u00c6\u0003J\u000b\u00100\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J=\u00101\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00c6\u0001J\u0013\u00102\u001a\u00020!2\b\u00103\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00104\u001a\u000205H\u00d6\u0001J\t\u00106\u001a\u000207H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/mineinabyss/components/tools/grappling/PlayerGrapple;", "", "hook", "Lorg/bukkit/entity/Arrow;", "hookData", "Lcom/mineinabyss/components/tools/grappling/GrapplingHook;", "player", "Lorg/bukkit/entity/Player;", "bat", "Lorg/bukkit/entity/Bat;", "job", "Lkotlinx/coroutines/Job;", "<init>", "(Lorg/bukkit/entity/Arrow;Lcom/mineinabyss/components/tools/grappling/GrapplingHook;Lorg/bukkit/entity/Player;Lorg/bukkit/entity/Bat;Lkotlinx/coroutines/Job;)V", "getHook", "()Lorg/bukkit/entity/Arrow;", "getHookData", "()Lcom/mineinabyss/components/tools/grappling/GrapplingHook;", "getPlayer", "()Lorg/bukkit/entity/Player;", "getBat", "()Lorg/bukkit/entity/Bat;", "getJob", "()Lkotlinx/coroutines/Job;", "setJob", "(Lkotlinx/coroutines/Job;)V", "batAddY", "", "getBatAddY", "()D", "removeGrapple", "", "isProx", "", "one", "Lorg/bukkit/Location;", "two", "ignoreY", "nu", "leashPacket", "Lnet/minecraft/network/protocol/game/ClientboundSetEntityLinkPacket;", "sendGrappleLeash", "isBeneathHook", "isOverHook", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "", "mineinabyss-components"})
@SourceDebugExtension(value={"SMAP\nPlayerGrapple.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerGrapple.kt\ncom/mineinabyss/components/tools/grappling/PlayerGrapple\n+ 2 Conversions.kt\ncom/mineinabyss/idofront/nms/aliases/ConversionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,49:1\n28#2:50\n27#2:51\n1#3:52\n1863#4,2:53\n*S KotlinDebug\n*F\n+ 1 PlayerGrapple.kt\ncom/mineinabyss/components/tools/grappling/PlayerGrapple\n*L\n43#1:50\n43#1:51\n44#1:53,2\n*E\n"})
public final class PlayerGrapple {
    @NotNull
    private final Arrow hook;
    @NotNull
    private final GrapplingHook hookData;
    @NotNull
    private final Player player;
    @NotNull
    private final Bat bat;
    @Nullable
    private Job job;
    private final double batAddY;
    @NotNull
    private final ClientboundSetEntityLinkPacket leashPacket;

    public PlayerGrapple(@NotNull Arrow hook, @NotNull GrapplingHook hookData, @NotNull Player player, @NotNull Bat bat, @Nullable Job job) {
        Intrinsics.checkNotNullParameter((Object)hook, (String)"hook");
        Intrinsics.checkNotNullParameter((Object)hookData, (String)"hookData");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)bat, (String)"bat");
        this.hook = hook;
        this.hookData = hookData;
        this.player = player;
        this.bat = bat;
        this.job = job;
        this.batAddY = 1.6;
        LivingEntity $this$toNMS$iv = (LivingEntity)this.bat;
        boolean $i$f$toNMS = false;
        net.minecraft.world.entity.LivingEntity livingEntity = ((CraftLivingEntity)$this$toNMS$iv).getHandle();
        Intrinsics.checkNotNullExpressionValue((Object)livingEntity, (String)"getHandle(...)");
        net.minecraft.world.entity.Entity entity = (net.minecraft.world.entity.Entity)livingEntity;
        $this$toNMS$iv = (Entity)this.hook;
        $i$f$toNMS = false;
        net.minecraft.world.entity.Entity entity2 = ((CraftEntity)$this$toNMS$iv).getHandle();
        Intrinsics.checkNotNullExpressionValue((Object)entity2, (String)"getHandle(...)");
        this.leashPacket = new ClientboundSetEntityLinkPacket(entity, entity2);
    }

    public /* synthetic */ PlayerGrapple(Arrow arrow, GrapplingHook grapplingHook, Player player, Bat bat, Job job, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            job = null;
        }
        this(arrow, grapplingHook, player, bat, job);
    }

    @NotNull
    public final Arrow getHook() {
        return this.hook;
    }

    @NotNull
    public final GrapplingHook getHookData() {
        return this.hookData;
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    @NotNull
    public final Bat getBat() {
        return this.bat;
    }

    @Nullable
    public final Job getJob() {
        return this.job;
    }

    public final void setJob(@Nullable Job job) {
        this.job = job;
    }

    public final double getBatAddY() {
        return this.batAddY;
    }

    public final void removeGrapple() {
        Job job = this.job;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.bat.remove();
        if (!this.hook.isDead()) {
            Location location;
            this.hook.remove();
            Location $this$removeGrapple_u24lambda_u240 = location = this.player.getLocation().clone();
            boolean bl = false;
            $this$removeGrapple_u24lambda_u240.setY($this$removeGrapple_u24lambda_u240.getY() + this.batAddY);
            Location location2 = location;
            Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"apply(...)");
            Location newY = location2;
            if (this.hook.isInBlock()) {
                Location location3 = this.hook.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location3, (String)"getLocation(...)");
                if (this.isProx(newY, location3, false) && newY.getDirection().getY() > 0.2) {
                    this.player.setVelocity(this.player.getVelocity().setY(0.5));
                }
            }
        }
        PlayerGrappleKt.getHookMap().remove(this.player.getUniqueId());
    }

    public final boolean isProx(@NotNull Location one, @NotNull Location two, boolean ignoreY) {
        Intrinsics.checkNotNullParameter((Object)one, (String)"one");
        Intrinsics.checkNotNullParameter((Object)two, (String)"two");
        return this.isProx(one, two, ignoreY, 1.5);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isProx(@NotNull Location one, @NotNull Location two, boolean ignoreY, double nu) {
        Location location;
        Intrinsics.checkNotNullParameter((Object)one, (String)"one");
        Intrinsics.checkNotNullParameter((Object)two, (String)"two");
        Location $this$isProx_u24lambda_u241 = location = one.clone();
        boolean bl = false;
        if (ignoreY) {
            $this$isProx_u24lambda_u241.setY(0.0);
        }
        Location location2 = location;
        $this$isProx_u24lambda_u241 = location = two.clone();
        Location location3 = location2;
        boolean bl2 = false;
        if (ignoreY) {
            void $this$isProx_u24lambda_u242;
            $this$isProx_u24lambda_u242.setY(0.0);
        }
        return location3.distance(location) < nu;
    }

    public final void sendGrappleLeash() {
        Collection collection = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getOnlinePlayers(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.bukkit.craftbukkit.entity.CraftPlayer");
            ((CraftPlayer)it).getHandle().connection.connection.send((Packet)this.leashPacket);
        }
    }

    public final boolean isBeneathHook() {
        return Math.abs(this.hook.getLocation().getX() - this.player.getLocation().getX()) < 1.0 && Math.abs(this.hook.getLocation().getZ() - this.player.getLocation().getZ()) < 1.0 && this.hook.getLocation().getY() > this.player.getEyeLocation().getY();
    }

    public final boolean isOverHook() {
        return this.hook.getLocation().getY() < this.player.getEyeLocation().getY();
    }

    @NotNull
    public final Arrow component1() {
        return this.hook;
    }

    @NotNull
    public final GrapplingHook component2() {
        return this.hookData;
    }

    @NotNull
    public final Player component3() {
        return this.player;
    }

    @NotNull
    public final Bat component4() {
        return this.bat;
    }

    @Nullable
    public final Job component5() {
        return this.job;
    }

    @NotNull
    public final PlayerGrapple copy(@NotNull Arrow hook, @NotNull GrapplingHook hookData, @NotNull Player player, @NotNull Bat bat, @Nullable Job job) {
        Intrinsics.checkNotNullParameter((Object)hook, (String)"hook");
        Intrinsics.checkNotNullParameter((Object)hookData, (String)"hookData");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)bat, (String)"bat");
        return new PlayerGrapple(hook, hookData, player, bat, job);
    }

    public static /* synthetic */ PlayerGrapple copy$default(PlayerGrapple playerGrapple, Arrow arrow, GrapplingHook grapplingHook, Player player, Bat bat, Job job, int n, Object object) {
        if ((n & 1) != 0) {
            arrow = playerGrapple.hook;
        }
        if ((n & 2) != 0) {
            grapplingHook = playerGrapple.hookData;
        }
        if ((n & 4) != 0) {
            player = playerGrapple.player;
        }
        if ((n & 8) != 0) {
            bat = playerGrapple.bat;
        }
        if ((n & 0x10) != 0) {
            job = playerGrapple.job;
        }
        return playerGrapple.copy(arrow, grapplingHook, player, bat, job);
    }

    @NotNull
    public String toString() {
        return "PlayerGrapple(hook=" + this.hook + ", hookData=" + this.hookData + ", player=" + this.player + ", bat=" + this.bat + ", job=" + this.job + ")";
    }

    public int hashCode() {
        int result = this.hook.hashCode();
        result = result * 31 + this.hookData.hashCode();
        result = result * 31 + this.player.hashCode();
        result = result * 31 + this.bat.hashCode();
        result = result * 31 + (this.job == null ? 0 : this.job.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PlayerGrapple)) {
            return false;
        }
        PlayerGrapple playerGrapple = (PlayerGrapple)other;
        if (!Intrinsics.areEqual((Object)this.hook, (Object)playerGrapple.hook)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.hookData, (Object)playerGrapple.hookData)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.player, (Object)playerGrapple.player)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.bat, (Object)playerGrapple.bat)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.job, (Object)playerGrapple.job);
    }
}

