/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.idofront.resourcepacks;

import co.touchlab.kermit.BaseLogger;
import co.touchlab.kermit.Logger;
import co.touchlab.kermit.Severity;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mineinabyss.idofront.messaging.ComponentLogger;
import com.mineinabyss.idofront.messaging.IdofrontLoggerKt;
import com.mineinabyss.idofront.resourcepacks.ResourcePacks;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.unnamed.creative.ResourcePack;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002J\u0018\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0013H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002J\n\u0010%\u001a\u0004\u0018\u00010\u0005H\u0002J\u0014\u0010&\u001a\u0004\u0018\u00010\u001e2\b\u0010'\u001a\u0004\u0018\u00010\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/mineinabyss/idofront/resourcepacks/MinecraftAssetExtractor;", "", "<init>", "()V", "VERSION_MANIFEST_URL", "", "resourcePack", "Lteam/unnamed/creative/ResourcePack;", "Lorg/jetbrains/annotations/NotNull;", "getResourcePack", "()Lteam/unnamed/creative/ResourcePack;", "setResourcePack", "(Lteam/unnamed/creative/ResourcePack;)V", "vanillaSounds", "", "Lnet/kyori/adventure/key/Key;", "getVanillaSounds", "()Ljava/util/List;", "zipPath", "Ljava/io/File;", "getZipPath", "()Ljava/io/File;", "future", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "extractLatest", "readVanillaRP", "", "extractVanillaSounds", "assetIndex", "Lcom/google/gson/JsonObject;", "versionInfo", "extractJarAssetsToZip", "clientJar", "", "zipFile", "downloadClientJar", "findVersionInfoUrl", "downloadJson", "url", "idofront-util"})
@SourceDebugExtension(value={"SMAP\nMinecraftAssetExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MinecraftAssetExtractor.kt\ncom/mineinabyss/idofront/resourcepacks/MinecraftAssetExtractor\n+ 2 Logger.kt\nco/touchlab/kermit/Logger\n+ 3 BaseLogger.kt\nco/touchlab/kermit/BaseLogger\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,179:1\n76#2,3:180\n79#2:192\n81#2,3:196\n84#2:208\n76#2,3:209\n79#2:221\n76#2,3:222\n79#2:234\n76#2,3:237\n79#2:249\n71#2,3:252\n74#2:264\n76#2,3:265\n79#2:277\n54#3,9:183\n54#3,9:199\n54#3,9:212\n54#3,9:225\n54#3,9:240\n54#3,9:255\n54#3,9:268\n1869#4,2:193\n295#4,2:235\n1869#4,2:250\n1#5:195\n*S KotlinDebug\n*F\n+ 1 MinecraftAssetExtractor.kt\ncom/mineinabyss/idofront/resourcepacks/MinecraftAssetExtractor\n*L\n78#1:180,3\n78#1:192\n105#1:196,3\n105#1:208\n140#1:209,3\n140#1:221\n152#1:222,3\n152#1:234\n174#1:237,3\n174#1:249\n51#1:252,3\n51#1:264\n56#1:265,3\n56#1:277\n78#1:183,9\n105#1:199,9\n140#1:212,9\n152#1:225,9\n174#1:240,9\n51#1:255,9\n56#1:268,9\n87#1:193,2\n160#1:235,2\n44#1:250,2\n*E\n"})
public final class MinecraftAssetExtractor {
    @NotNull
    public static final MinecraftAssetExtractor INSTANCE = new MinecraftAssetExtractor();
    @NotNull
    private static final String VERSION_MANIFEST_URL = "https://piston-meta.mojang.com/mc/game/version_manifest_v2.json";
    @NotNull
    private static ResourcePack resourcePack;
    @NotNull
    private static final List<Key> vanillaSounds;
    @NotNull
    private static final File zipPath;
    @Nullable
    private static CompletableFuture<Void> future;

    private MinecraftAssetExtractor() {
    }

    @NotNull
    public final ResourcePack getResourcePack() {
        return resourcePack;
    }

    public final void setResourcePack(@NotNull ResourcePack resourcePack) {
        Intrinsics.checkNotNullParameter((Object)resourcePack, (String)"<set-?>");
        MinecraftAssetExtractor.resourcePack = resourcePack;
    }

    @NotNull
    public final List<Key> getVanillaSounds() {
        return vanillaSounds;
    }

    @NotNull
    public final File getZipPath() {
        return zipPath;
    }

    @NotNull
    public final CompletableFuture<Void> extractLatest() {
        block3: {
            block2: {
                if (future == null) break block2;
                if (zipPath.exists()) break block3;
                CompletableFuture<Void> completableFuture = future;
                Intrinsics.checkNotNull(completableFuture);
                if (!completableFuture.isDone()) break block3;
            }
            future = CompletableFuture.runAsync(MinecraftAssetExtractor::extractLatest$lambda$6);
        }
        CompletableFuture<Void> completableFuture = future;
        Intrinsics.checkNotNull(completableFuture);
        return completableFuture;
    }

    /*
     * WARNING - void declaration
     */
    private final void readVanillaRP() {
        block3: {
            void this_$iv$iv;
            void $this$iv;
            Object object;
            Object object2 = this;
            try {
                MinecraftAssetExtractor $this$readVanillaRP_u24lambda_u247 = object2;
                boolean bl = false;
                ResourcePack resourcePack = ResourcePacks.INSTANCE.getResourcePackReader().readFromZipFile(zipPath);
                Intrinsics.checkNotNullExpressionValue((Object)resourcePack, (String)"readFromZipFile(...)");
                MinecraftAssetExtractor.resourcePack = resourcePack;
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block3;
            Object it = object = throwable;
            boolean bl = false;
            Logger logger = (Logger)IdofrontLoggerKt.getIdofrontLogger();
            String messageString$iv = "Failed to read Vanilla ResourcePack-cache...";
            Throwable throwable$iv = null;
            String tag$iv = $this$iv.getTag();
            boolean $i$f$w = false;
            BaseLogger baseLogger = (BaseLogger)$this$iv;
            Severity severity$iv$iv = Severity.Warn;
            boolean $i$f$log = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
            }
            ((Throwable)it).printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void extractVanillaSounds(JsonObject assetIndex) {
        void $this$extractVanillaSounds_u24lambda_u2410;
        JsonObject jsonObject;
        JsonObject objects = assetIndex.getAsJsonObject("objects");
        JsonArray sounds = new JsonArray();
        Set set = objects.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"keySet(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Key soundKey;
            String key = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)key);
            Intrinsics.checkNotNullExpressionValue((Object)Key.key((String)StringsKt.replace$default((String)StringsKt.replace$default((String)key, (String)"minecraft/sounds/", (String)"", (boolean)false, (int)4, null), (String)".ogg", (String)"", (boolean)false, (int)4, null)), (String)"key(...)");
            if (!StringsKt.startsWith$default((String)key, (String)"minecraft/sounds/", (boolean)false, (int)2, null)) continue;
            ((Collection)vanillaSounds).add(soundKey);
            sounds.add(soundKey.asString());
        }
        JsonObject jsonObject2 = jsonObject = new JsonObject();
        File file = FilesKt.resolveSibling((File)zipPath, (String)"vanilla-sounds.json");
        boolean bl = false;
        $this$extractVanillaSounds_u24lambda_u2410.add("sounds", (JsonElement)sounds);
        String string = jsonObject.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        FilesKt.writeText$default((File)file, (String)string, null, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final JsonObject assetIndex(JsonObject versionInfo) {
        Object object;
        block3: {
            void this_$iv$iv;
            void $this$iv;
            Object object2;
            JsonObject assetIndex = versionInfo.getAsJsonObject("assetIndex");
            String url = assetIndex.get("url").getAsString();
            object = this;
            try {
                MinecraftAssetExtractor $this$assetIndex_u24lambda_u2411 = object;
                boolean bl = false;
                JsonObject jsonObject = $this$assetIndex_u24lambda_u2411.downloadJson(url);
                Intrinsics.checkNotNull((Object)jsonObject);
                object2 = Result.constructor-impl((Object)jsonObject.getAsJsonObject());
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block3;
            Object it = object2 = throwable;
            boolean bl = false;
            Logger logger = (Logger)IdofrontLoggerKt.getIdofrontLogger();
            String messageString$iv = "Failed to download asset index";
            Throwable throwable$iv = null;
            String tag$iv = $this$iv.getTag();
            boolean $i$f$e = false;
            BaseLogger baseLogger = (BaseLogger)$this$iv;
            Severity severity$iv$iv = Severity.Error;
            boolean $i$f$log = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
            }
            ((Throwable)it).printStackTrace();
        }
        return (JsonObject)(Result.isFailure-impl((Object)object) ? null : object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void extractJarAssetsToZip(byte[] clientJar, File zipFile) {
        block29: {
            void this_$iv$iv;
            void $this$iv;
            Object object;
            Object zis;
            Throwable throwable;
            Object object2 = this;
            try {
                MinecraftAssetExtractor $this$extractJarAssetsToZip_u24lambda_u2417 = object2;
                boolean bl = false;
                Closeable closeable = new ByteArrayInputStream(clientJar);
                throwable = null;
                try {
                    ByteArrayInputStream stream = (ByteArrayInputStream)closeable;
                    boolean bl2 = false;
                    Closeable closeable2 = new ZipInputStream(stream);
                    Throwable throwable2 = null;
                    try {
                        zis = (ZipInputStream)closeable2;
                        boolean bl3 = false;
                        Closeable closeable3 = new FileOutputStream(zipFile);
                        Throwable throwable3 = null;
                        try {
                            FileOutputStream fos = (FileOutputStream)closeable3;
                            boolean bl4 = false;
                            Closeable closeable4 = new ZipOutputStream(fos);
                            Throwable throwable4 = null;
                            try {
                                ZipOutputStream zos = (ZipOutputStream)closeable4;
                                boolean bl5 = false;
                                ZipEntry entry = ((ZipInputStream)zis).getNextEntry();
                                while (entry != null) {
                                    String name = entry.getName();
                                    Intrinsics.checkNotNull((Object)name);
                                    if (StringsKt.startsWith$default((String)name, (String)"assets/", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)name, (String)"scaffolding_unstable.json", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)name, (String)"assets/minecraft/shaders", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)name, (String)"assets/minecraft/particles", (boolean)false, (int)2, null)) {
                                        ZipEntry zipEntry = new ZipEntry(name);
                                        zos.putNextEntry(zipEntry);
                                        ByteStreamsKt.copyTo$default((InputStream)((InputStream)zis), (OutputStream)zos, (int)0, (int)2, null);
                                        zos.closeEntry();
                                    }
                                    ((ZipInputStream)zis).closeEntry();
                                    entry = ((ZipInputStream)zis).getNextEntry();
                                }
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable5) {
                                throwable4 = throwable5;
                                throw throwable5;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable4, (Throwable)throwable4);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable6) {
                            throwable3 = throwable6;
                            throw throwable6;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                        }
                        zis = Unit.INSTANCE;
                    }
                    catch (Throwable bl3) {
                        throwable2 = bl3;
                        throw bl3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    stream = Unit.INSTANCE;
                }
                catch (Throwable bl2) {
                    throwable = bl2;
                    throw bl2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable7 = Result.exceptionOrNull-impl((Object)object2);
            if (throwable7 == null) break block29;
            Object it = object = throwable7;
            boolean bl = false;
            throwable = (Logger)IdofrontLoggerKt.getIdofrontLogger();
            String messageString$iv = "Failed to extract vanilla-resourcepack directly to zip file...";
            Throwable throwable$iv = null;
            String tag$iv = $this$iv.getTag();
            boolean $i$f$w = false;
            zis = (BaseLogger)$this$iv;
            Severity severity$iv$iv = Severity.Warn;
            boolean $i$f$log = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
            }
            ((Throwable)it).printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final byte[] downloadClientJar(JsonObject versionInfo) {
        Object object;
        block9: {
            void this_$iv$iv;
            void $this$iv;
            Object object2;
            Object object3;
            String url = versionInfo.getAsJsonObject("downloads").getAsJsonObject("client").get("url").getAsString();
            object = this;
            try {
                Object stream;
                MinecraftAssetExtractor $this$downloadClientJar_u24lambda_u2420 = object;
                boolean bl = false;
                Closeable closeable = new URI(url).toURL().openStream();
                object3 = null;
                try {
                    stream = (InputStream)closeable;
                    boolean bl2 = false;
                    stream = ((InputStream)stream).readAllBytes();
                }
                catch (Throwable bl2) {
                    object3 = bl2;
                    throw bl2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object3);
                }
                object2 = Result.constructor-impl((Object)stream);
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block9;
            Object it = object2 = throwable;
            boolean bl = false;
            object3 = (Logger)IdofrontLoggerKt.getIdofrontLogger();
            String messageString$iv = "Failed to download vanilla-resourcepack from: " + url;
            Throwable throwable$iv = null;
            String tag$iv = $this$iv.getTag();
            boolean $i$f$w = false;
            BaseLogger baseLogger = (BaseLogger)$this$iv;
            Severity severity$iv$iv = Severity.Warn;
            boolean $i$f$log = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
            }
            ((Throwable)it).printStackTrace();
        }
        return (byte[])(Result.isFailure-impl((Object)object) ? null : object);
    }

    private final String findVersionInfoUrl() {
        JsonElement jsonElement;
        JsonObject jsonObject;
        Object v3;
        block2: {
            JsonObject jsonObject2 = this.downloadJson(VERSION_MANIFEST_URL);
            if (jsonObject2 == null) {
                return null;
            }
            JsonObject manifest = jsonObject2;
            JsonArray jsonArray = manifest.getAsJsonArray("versions");
            Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
            Iterable $this$firstOrNull$iv = (Iterable)jsonArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                JsonElement element = (JsonElement)element$iv;
                boolean bl = false;
                JsonObject jsonObject3 = element.getAsJsonObject();
                if (!Intrinsics.areEqual(jsonObject3 != null && (jsonObject3 = jsonObject3.get("id")) != null ? jsonObject3.getAsString() : null, (Object)Bukkit.getMinecraftVersion())) continue;
                v3 = element$iv;
                break block2;
            }
            v3 = null;
        }
        JsonElement jsonElement2 = v3;
        return jsonElement2 != null && (jsonObject = jsonElement2.getAsJsonObject()) != null && (jsonElement = jsonObject.get("url")) != null ? jsonElement.getAsString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final JsonObject downloadJson(String url) {
        Object object;
        block16: {
            void this_$iv$iv;
            void $this$iv;
            Object object2;
            Object reader;
            Throwable throwable;
            if (url == null) {
                return null;
            }
            object = this;
            try {
                InputStream stream;
                MinecraftAssetExtractor $this$downloadJson_u24lambda_u2425 = object;
                boolean bl = false;
                Closeable closeable = URI.create(url).toURL().openStream();
                throwable = null;
                try {
                    stream = (InputStream)closeable;
                    boolean bl2 = false;
                    Closeable closeable2 = new InputStreamReader(stream);
                    Throwable throwable2 = null;
                    try {
                        reader = (InputStreamReader)closeable2;
                        boolean bl3 = false;
                        reader = JsonParser.parseReader((Reader)((Reader)reader)).getAsJsonObject();
                    }
                    catch (Throwable bl3) {
                        throwable2 = bl3;
                        throw bl3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    stream = reader;
                }
                catch (Throwable bl2) {
                    throwable = bl2;
                    throw bl2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                object2 = Result.constructor-impl((Object)stream);
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable3 = Result.exceptionOrNull-impl((Object)object);
            if (throwable3 == null) break block16;
            Object it = object2 = throwable3;
            boolean bl = false;
            throwable = (Logger)IdofrontLoggerKt.getIdofrontLogger();
            String messageString$iv = "Failed to fetch manifest for vanilla-resourcepack...";
            Throwable throwable$iv = null;
            String tag$iv = $this$iv.getTag();
            boolean $i$f$w = false;
            reader = (BaseLogger)$this$iv;
            Severity severity$iv$iv = Severity.Warn;
            boolean $i$f$log = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                this_$iv$iv.processLog(severity$iv$iv, tag$iv, throwable$iv, messageString$iv);
            }
            ((Throwable)it).printStackTrace();
        }
        return (JsonObject)(Result.isFailure-impl((Object)object) ? null : object);
    }

    /*
     * WARNING - void declaration
     */
    private static final void extractLatest$lambda$6() {
        JsonObject assetIndex;
        Object object;
        void this_$iv$iv;
        void $this$iv;
        Object $this$extractLatest_u24lambda_u246_u24lambda_u242;
        File vanillaSoundsJson = FilesKt.resolveSibling((File)zipPath, (String)"vanilla-sounds.json");
        Object object2 = zipPath.getParentFile();
        File $this$extractLatest_u24lambda_u246_u24lambda_u240 = object2;
        boolean bl = false;
        $this$extractLatest_u24lambda_u246_u24lambda_u240.mkdirs();
        object2 = INSTANCE;
        try {
            $this$extractLatest_u24lambda_u246_u24lambda_u242 = object2;
            boolean bl2 = false;
            if (vanillaSoundsJson.createNewFile() || ((CharSequence)FilesKt.readText$default((File)vanillaSoundsJson, null, (int)1, null)).length() == 0) {
                JsonObject versionInfo;
                JsonObject jsonObject = versionInfo = super.downloadJson(super.findVersionInfoUrl());
                Intrinsics.checkNotNull((Object)jsonObject);
                JsonObject jsonObject2 = super.assetIndex(jsonObject);
                Intrinsics.checkNotNull((Object)jsonObject2);
                super.extractVanillaSounds(jsonObject2);
            }
            JsonArray jsonArray = JsonParser.parseString((String)FilesKt.readText$default((File)vanillaSoundsJson, null, (int)1, null)).getAsJsonObject().getAsJsonArray("sounds");
            Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
            Iterable $this$forEach$iv = (Iterable)jsonArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JsonElement json = (JsonElement)element$iv;
                boolean bl3 = false;
                ((Collection)vanillaSounds).add(Key.key((String)json.getAsString()));
            }
            $this$extractLatest_u24lambda_u246_u24lambda_u242 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl2) {
            $this$extractLatest_u24lambda_u246_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
        }
        object2 = $this$extractLatest_u24lambda_u246_u24lambda_u242;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object it = $this$extractLatest_u24lambda_u246_u24lambda_u242 = throwable;
            boolean bl4 = false;
            ((Throwable)it).printStackTrace();
        }
        if (zipPath.exists()) {
            INSTANCE.readVanillaRP();
            return;
        }
        object2 = (Logger)IdofrontLoggerKt.getIdofrontLogger();
        String messageString$iv = "Extracting latest vanilla-resourcepack...";
        Object throwable$iv = null;
        String tag$iv = $this$iv.getTag();
        boolean $i$f$i = false;
        BaseLogger baseLogger = (BaseLogger)$this$iv;
        Severity severity$iv$iv = Severity.Info;
        boolean $i$f$log = false;
        if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
            this_$iv$iv.processLog(severity$iv$iv, tag$iv, (Throwable)throwable$iv, messageString$iv);
        }
        throwable$iv = INSTANCE;
        try {
            MinecraftAssetExtractor $this$extractLatest_u24lambda_u246_u24lambda_u244 = throwable$iv;
            boolean bl5 = false;
            object = Result.constructor-impl((Object)$this$extractLatest_u24lambda_u246_u24lambda_u244.downloadJson($this$extractLatest_u24lambda_u246_u24lambda_u244.findVersionInfoUrl()));
        }
        catch (Throwable bl5) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl5));
        }
        throwable$iv = object;
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)throwable$iv);
        if (throwable2 != null) {
            void this_$iv$iv2;
            void $this$iv2;
            Object it = object = throwable2;
            boolean bl6 = false;
            severity$iv$iv = (Logger)IdofrontLoggerKt.getIdofrontLogger();
            String messageString$iv2 = "Failed to fetch version-info for vanilla-resourcepack...";
            Throwable throwable$iv2 = null;
            String tag$iv2 = $this$iv2.getTag();
            boolean $i$f$w = false;
            BaseLogger baseLogger2 = (BaseLogger)$this$iv2;
            Severity severity$iv$iv2 = Severity.Warn;
            boolean $i$f$log2 = false;
            if (this_$iv$iv2.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv2) <= 0) {
                this_$iv$iv2.processLog(severity$iv$iv2, tag$iv2, throwable$iv2, messageString$iv2);
            }
            ((Throwable)it).printStackTrace();
            return;
        }
        JsonObject jsonObject = (JsonObject)(Result.isFailure-impl((Object)throwable$iv) ? null : throwable$iv);
        if (jsonObject == null) {
            return;
        }
        JsonObject versionInfo = jsonObject;
        byte[] clientJar = INSTANCE.downloadClientJar(versionInfo);
        Intrinsics.checkNotNull((Object)clientJar);
        INSTANCE.extractJarAssetsToZip(clientJar, zipPath);
        JsonObject jsonObject3 = assetIndex = INSTANCE.assetIndex(versionInfo);
        Intrinsics.checkNotNull((Object)jsonObject3);
        INSTANCE.extractVanillaSounds(jsonObject3);
        INSTANCE.readVanillaRP();
        ComponentLogger.s$default((ComponentLogger)IdofrontLoggerKt.getIdofrontLogger(), (String)"Finished extracting latest vanilla-resourcepack!", null, (int)2, null);
    }

    static {
        ResourcePack resourcePack = ResourcePack.resourcePack();
        Intrinsics.checkNotNullExpressionValue((Object)resourcePack, (String)"resourcePack(...)");
        MinecraftAssetExtractor.resourcePack = resourcePack;
        vanillaSounds = new ArrayList();
        File file = Bukkit.getPluginsFolder();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getPluginsFolder(...)");
        zipPath = FilesKt.resolve((File)file, (String)("Idofront/assetCache/" + Bukkit.getMinecraftVersion() + ".zip"));
    }
}

