/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.idofront.serialization;

import com.mineinabyss.idofront.serialization.TintSourceSurrogate;
import com.mineinabyss.idofront.serialization.TintSourceType;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.bukkit.Color;
import org.jetbrains.annotations.NotNull;
import team.unnamed.creative.item.tint.ConstantTintSource;
import team.unnamed.creative.item.tint.CustomModelDataTintSource;
import team.unnamed.creative.item.tint.GrassTintSource;
import team.unnamed.creative.item.tint.KeyedAndBackedTintSource;
import team.unnamed.creative.item.tint.TintSource;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0096\u0080\u0004J\u0012\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0080\u0004R\u0015\u0010\u0005\u001a\u00020\u0006X\u0096\u0084\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/mineinabyss/idofront/serialization/TintSourceSerializer;", "Lkotlinx/serialization/KSerializer;", "Lteam/unnamed/creative/item/tint/TintSource;", "<init>", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "idofront-serializers"})
public final class TintSourceSerializer
implements KSerializer<TintSource> {
    @NotNull
    public static final TintSourceSerializer INSTANCE = new TintSourceSerializer();
    @NotNull
    private static final SerialDescriptor descriptor = TintSourceSurrogate.Companion.serializer().getDescriptor();

    private TintSourceSerializer() {
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    public void serialize(@NotNull Encoder encoder, @NotNull TintSource value) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        TintSource tintSource = value;
        if (tintSource instanceof ConstantTintSource) {
            pair = TuplesKt.to((Object)((Object)TintSourceType.CONSTANT), (Object)((ConstantTintSource)value).tint());
        } else if (tintSource instanceof KeyedAndBackedTintSource) {
            pair = TuplesKt.to((Object)((Object)TintSourceType.Companion.getType((KeyedAndBackedTintSource)value)), (Object)((KeyedAndBackedTintSource)value).defaultTint());
        } else if (tintSource instanceof CustomModelDataTintSource) {
            pair = TuplesKt.to((Object)((Object)TintSourceType.CUSTOM_MODEL_DATA), (Object)((CustomModelDataTintSource)value).defaultTint());
        } else {
            throw new IllegalStateException(("Unsupported tint source: " + value).toString());
        }
        Pair pair2 = pair;
        TintSourceType type = (TintSourceType)((Object)pair2.component1());
        int color = ((Number)pair2.component2()).intValue();
        Color color2 = Color.fromARGB((int)color);
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"fromARGB(...)");
        TintSourceSurrogate surrogate = new TintSourceSurrogate(type, color2);
        encoder.encodeSerializableValue((SerializationStrategy)TintSourceSurrogate.Companion.serializer(), (Object)surrogate);
    }

    @NotNull
    public TintSource deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        TintSourceSurrogate surrogate = (TintSourceSurrogate)decoder.decodeSerializableValue((DeserializationStrategy)TintSourceSurrogate.Companion.serializer());
        return switch (WhenMappings.$EnumSwitchMapping$0[surrogate.getType().ordinal()]) {
            case 1 -> {
                CustomModelDataTintSource v0 = TintSource.customModelData((int)0, (int)surrogate.getDefaultColor().asARGB());
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"customModelData(...)");
                yield (TintSource)v0;
            }
            case 2 -> {
                GrassTintSource v2 = TintSource.grass((float)1.0f, (float)1.0f);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"grass(...)");
                yield (TintSource)v2;
            }
            case 3 -> {
                KeyedAndBackedTintSource v3 = TintSource.dye((int)surrogate.getDefaultColor().asARGB());
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"dye(...)");
                yield (TintSource)v3;
            }
            case 4 -> {
                KeyedAndBackedTintSource v4 = TintSource.team((int)surrogate.getDefaultColor().asARGB());
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"team(...)");
                yield (TintSource)v4;
            }
            case 5 -> {
                KeyedAndBackedTintSource v5 = TintSource.potion((int)surrogate.getDefaultColor().asARGB());
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"potion(...)");
                yield (TintSource)v5;
            }
            case 6 -> {
                KeyedAndBackedTintSource v6 = TintSource.firework((int)surrogate.getDefaultColor().asARGB());
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"firework(...)");
                yield (TintSource)v6;
            }
            case 7 -> {
                KeyedAndBackedTintSource v7 = TintSource.mapColor((int)surrogate.getDefaultColor().asARGB());
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"mapColor(...)");
                yield (TintSource)v7;
            }
            case 8 -> {
                ConstantTintSource v8 = TintSource.constant((int)surrogate.getDefaultColor().asARGB());
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"constant(...)");
                yield (TintSource)v8;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TintSourceType.values().length];
            try {
                nArray[TintSourceType.CUSTOM_MODEL_DATA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TintSourceType.GRASS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TintSourceType.DYE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TintSourceType.TEAM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TintSourceType.POTION.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TintSourceType.FIREWORK.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TintSourceType.MAP_COLOR.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TintSourceType.CONSTANT.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

