package com.mineinabyss.guiy.modifiers

import org.bukkit.event.inventory.ClickType

interface ClickScope {
    val clickType: ClickType
}

open class ClickModifier(
    val merged: Boolean = false,
    val onClick: (ClickScope.() -> Unit),
) : Modifier.Element<ClickModifier> {
    override fun mergeWith(other: ClickModifier) = ClickModifier(merged = true) {
        if (!other.merged)
            onClick()
        other.onClick(this)
    }
}

fun Modifier.clickable(onClick: ClickScope.() -> Unit) = then(ClickModifier(onClick = onClick))

