/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.guiy.canvas.inventory;

import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.runtime.snapshots.MutableSnapshot;
import androidx.compose.runtime.snapshots.Snapshot;
import com.mineinabyss.guiy.canvas.inventory.GuiyInventory;
import com.mineinabyss.guiy.modifiers.click.ClickScope;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020\u0018H\u0016J\u0015\u0010\f\u001a\u00020\"2\u0006\u0010#\u001a\u00020\bH\u0007\u00a2\u0006\u0002\b$J\u0018\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H&J\u0010\u0010*\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u0004H&J\u0010\u0010,\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u0004H&J\u000e\u0010-\u001a\u00020\"2\u0006\u0010+\u001a\u00020.J\u0014\u0010/\u001a\u00020\"2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000400J\u0014\u00101\u001a\u00020\"2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000400J\u0006\u00102\u001a\u00020\"R/\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b8F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00063"}, d2={"Lcom/mineinabyss/guiy/canvas/inventory/GuiyInventoryHolder;", "Lorg/bukkit/inventory/InventoryHolder;", "initialViewers", "", "Lorg/bukkit/entity/Player;", "<init>", "(Ljava/util/Set;)V", "<set-?>", "Lcom/mineinabyss/guiy/canvas/inventory/GuiyInventory;", "activeInventory", "getActiveInventory", "()Lcom/mineinabyss/guiy/canvas/inventory/GuiyInventory;", "setActiveInventory", "(Lcom/mineinabyss/guiy/canvas/inventory/GuiyInventory;)V", "activeInventory$delegate", "Landroidx/compose/runtime/MutableState;", "_viewers", "Lkotlinx/coroutines/flow/MutableStateFlow;", "viewers", "Lkotlinx/coroutines/flow/StateFlow;", "getViewers", "()Lkotlinx/coroutines/flow/StateFlow;", "inventoryCache", "", "Lorg/bukkit/inventory/Inventory;", "getInventoryCache", "()[Lorg/bukkit/inventory/Inventory;", "[Lorg/bukkit/inventory/Inventory;", "getOrCreateInventory", "height", "", "title", "Lnet/kyori/adventure/text/Component;", "getInventory", "", "inventory", "setActiveInventoryWithSnapshot", "processClick", "scope", "Lcom/mineinabyss/guiy/modifiers/click/ClickScope;", "event", "Lorg/bukkit/event/Cancellable;", "onClose", "player", "closeIfNoLongerViewing", "openInventoryFor", "Lorg/bukkit/entity/HumanEntity;", "removeViewers", "", "addViewers", "close", "guiy-compose"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nGuiyInventoryHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GuiyInventoryHolder.kt\ncom/mineinabyss/guiy/canvas/inventory/GuiyInventoryHolder\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Snapshot.kt\nandroidx/compose/runtime/snapshots/Snapshot$Companion\n+ 5 Snapshot.kt\nandroidx/compose/runtime/snapshots/Snapshot\n+ 6 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n85#2:87\n113#2,2:88\n1#3:90\n452#4,4:91\n460#4,5:100\n456#4,10:105\n148#5,5:95\n230#6,5:115\n230#6,5:120\n1869#7,2:125\n*S KotlinDebug\n*F\n+ 1 GuiyInventoryHolder.kt\ncom/mineinabyss/guiy/canvas/inventory/GuiyInventoryHolder\n*L\n28#1:87\n28#1:88,2\n54#1:91,4\n54#1:100,5\n54#1:105,10\n54#1:95,5\n75#1:115,5\n79#1:120,5\n83#1:125,2\n*E\n"})
public abstract class GuiyInventoryHolder
implements InventoryHolder {
    @NotNull
    private final MutableState activeInventory$delegate;
    @NotNull
    private final MutableStateFlow<Set<Player>> _viewers;
    @NotNull
    private final StateFlow<Set<Player>> viewers;
    @NotNull
    private final Inventory[] inventoryCache;
    public static final int $stable = 8;

    public GuiyInventoryHolder(@NotNull Set<? extends Player> initialViewers) {
        Intrinsics.checkNotNullParameter(initialViewers, (String)"initialViewers");
        this.activeInventory$delegate = SnapshotStateKt.mutableStateOf$default(null, null, 2, null);
        this._viewers = StateFlowKt.MutableStateFlow(initialViewers);
        this.viewers = FlowKt.asStateFlow(this._viewers);
        this.inventoryCache = new Inventory[6];
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final GuiyInventory getActiveInventory() {
        void $this$getValue$iv;
        State state = this.activeInventory$delegate;
        GuiyInventoryHolder guiyInventoryHolder = this;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (GuiyInventory)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setActiveInventory(GuiyInventory guiyInventory) {
        void $this$setValue$iv;
        MutableState mutableState = this.activeInventory$delegate;
        GuiyInventoryHolder guiyInventoryHolder = this;
        Object var4_4 = null;
        GuiyInventory value$iv = guiyInventory;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue(value$iv);
    }

    @NotNull
    public final StateFlow<Set<Player>> getViewers() {
        return this.viewers;
    }

    @NotNull
    public final Inventory[] getInventoryCache() {
        return this.inventoryCache;
    }

    @NotNull
    public final Inventory getOrCreateInventory(int height, @NotNull Component title) {
        Inventory inv;
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Inventory inventory = this.inventoryCache[height - 1];
        if (inventory != null) {
            Inventory it = inventory;
            boolean bl = false;
            return it;
        }
        Inventory inventory2 = Bukkit.createInventory((InventoryHolder)this, (int)(9 * height), (Component)title);
        Intrinsics.checkNotNullExpressionValue((Object)inventory2, (String)"createInventory(...)");
        this.inventoryCache[height - 1] = inv = inventory2;
        return inv;
    }

    @NotNull
    public Inventory getInventory() {
        GuiyInventory guiyInventory = this.getActiveInventory();
        if (guiyInventory == null || (guiyInventory = guiyInventory.getInventory()) == null) {
            throw new IllegalStateException("Guiy inventory is used in bukkit but has not been rendered yet.".toString());
        }
        return guiyInventory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmName(name="setActiveInventoryWithSnapshot")
    public final void setActiveInventoryWithSnapshot(@NotNull GuiyInventory inventory) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Snapshot.Companion this_$iv = Snapshot.Companion;
        boolean $i$f$withMutableSnapshot = false;
        MutableSnapshot $this$withMutableSnapshot_u24lambda_u240$iv = Snapshot.Companion.takeMutableSnapshot$default(this_$iv, null, null, 3, null);
        boolean bl = false;
        boolean hasError$iv = false;
        try {
            Unit unit;
            Snapshot this_$iv$iv = $this$withMutableSnapshot_u24lambda_u240$iv;
            boolean $i$f$enter = false;
            Snapshot previous$iv$iv = this_$iv$iv.makeCurrent();
            try {
                boolean bl2 = false;
                this.setActiveInventory(inventory);
                unit = Unit.INSTANCE;
            }
            finally {
                this_$iv$iv.restoreCurrent(previous$iv$iv);
            }
            Unit unit2 = unit;
        }
        catch (Throwable e$iv) {
            try {
                hasError$iv = true;
                throw e$iv;
            }
            catch (Throwable throwable) {
                if (!hasError$iv) {
                    $this$withMutableSnapshot_u24lambda_u240$iv.apply().check();
                }
                $this$withMutableSnapshot_u24lambda_u240$iv.dispose();
                throw throwable;
            }
        }
        $this$withMutableSnapshot_u24lambda_u240$iv.apply().check();
        $this$withMutableSnapshot_u24lambda_u240$iv.dispose();
    }

    public abstract void processClick(@NotNull ClickScope var1, @NotNull Cancellable var2);

    public abstract void onClose(@NotNull Player var1);

    public abstract void closeIfNoLongerViewing(@NotNull Player var1);

    public final void openInventoryFor(@NotNull HumanEntity player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        GuiyInventory guiyInventory = this.getActiveInventory();
        if (guiyInventory == null || (guiyInventory = guiyInventory.getInventory()) == null) {
            return;
        }
        GuiyInventory inventory = guiyInventory;
        if (!Intrinsics.areEqual((Object)player.getOpenInventory().getTopInventory(), (Object)inventory)) {
            player.closeInventory(InventoryCloseEvent.Reason.PLUGIN);
            player.openInventory((Inventory)inventory);
        }
    }

    public final void removeViewers(@NotNull Collection<? extends Player> viewers) {
        Set it;
        Set nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter(viewers, (String)"viewers");
        MutableStateFlow<Set<Player>> $this$update$iv = this._viewers;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (Set)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = SetsKt.minus((Set)it, (Iterable)CollectionsKt.toSet((Iterable)viewers)))));
    }

    public final void addViewers(@NotNull Collection<? extends Player> viewers) {
        Set it;
        Set nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter(viewers, (String)"viewers");
        MutableStateFlow<Set<Player>> $this$update$iv = this._viewers;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (Set)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = SetsKt.plus((Set)it, (Iterable)CollectionsKt.toSet((Iterable)viewers)))));
    }

    public final void close() {
        List list = this.getInventory().getViewers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getViewers(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HumanEntity it = (HumanEntity)element$iv;
            boolean bl = false;
            it.closeInventory(InventoryCloseEvent.Reason.PLUGIN);
        }
    }
}

