/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.annotation.IntRange;
import androidx.collection.ObjectList;
import androidx.collection.ObjectListKt;
import androidx.collection.ScatterSet;
import androidx.collection.internal.RuntimeHelpersKt;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableList;
import kotlin.jvm.internal.markers.KMutableListIterator;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u001c\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u000b\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0003;<=B\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000eJ\u001d\u0010\u000b\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u00042\u0006\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0011J\u0014\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002J\u0014\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014J\u0019\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015\u00a2\u0006\u0002\u0010\u0016J\u001e\u0010\u0012\u001a\u00020\f2\b\b\u0001\u0010\u0010\u001a\u00020\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002J#\u0010\u0012\u001a\u00020\f2\b\b\u0001\u0010\u0010\u001a\u00020\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015\u00a2\u0006\u0002\u0010\u0017J\u001e\u0010\u0012\u001a\u00020\f2\b\b\u0001\u0010\u0010\u001a\u00020\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018J\u0014\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019J\u0014\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aJ\u0014\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bJ\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0016J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eJ\u0006\u0010\u001f\u001a\u00020\u000fJ\u0011\u0010 \u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0004H\u0086\bJ\u0016\u0010!\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00028\u0000H\u0086\n\u00a2\u0006\u0002\u0010\"J\u0017\u0010!\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002H\u0086\u0002J\u0017\u0010!\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0086\u0002J\u001c\u0010!\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015H\u0086\u0002\u00a2\u0006\u0002\u0010#J\u0017\u0010!\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0086\u0002J\u0017\u0010!\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0086\u0002J\u0017\u0010!\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH\u0086\u0002J\u0016\u0010$\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00028\u0000H\u0086\n\u00a2\u0006\u0002\u0010\"J\u0017\u0010$\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002H\u0086\u0002J\u0017\u0010$\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0086\u0002J\u001c\u0010$\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015H\u0086\u0002\u00a2\u0006\u0002\u0010#J\u0017\u0010$\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0086\u0002J\u0017\u0010$\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0086\u0002J\u0017\u0010$\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH\u0086\u0002J\u0013\u0010%\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010&\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002J\u0014\u0010&\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014J\u0019\u0010&\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015\u00a2\u0006\u0002\u0010\u0016J\u0014\u0010&\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019J\u0014\u0010&\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aJ\u0014\u0010&\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bJ\u0015\u0010'\u001a\u00028\u00002\b\b\u0001\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\u0002\u0010(J/\u0010)\u001a\u00020\u000f2!\u0010*\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b,\u0012\b\b-\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\f0+H\u0086\b\u00f8\u0001\u0000J\u001a\u0010.\u001a\u00020\u000f2\b\b\u0001\u0010/\u001a\u00020\u00042\b\b\u0001\u00100\u001a\u00020\u0004J%\u00101\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00042\u000e\u00102\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001030\u0015H\u0001\u00a2\u0006\u0002\u00104J\u0014\u00105\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002J\u0019\u00105\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015\u00a2\u0006\u0002\u0010\u0016J\u0014\u00105\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018J\u0014\u00105\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019J\u0014\u00105\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bJ \u00106\u001a\u00028\u00002\b\b\u0001\u0010\u0010\u001a\u00020\u00042\u0006\u0010\r\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u00107J\u0010\u00108\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0010\u00109\u001a\u00020\u000f2\b\b\u0002\u0010:\u001a\u00020\u0004R\u0012\u0010\u0006\u001a\u00020\u00048\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006>"}, d2={"Landroidx/collection/MutableObjectList;", "E", "Landroidx/collection/ObjectList;", "initialCapacity", "", "(I)V", "capacity", "getCapacity", "()I", "list", "Landroidx/collection/MutableObjectList$ObjectListMutableList;", "add", "", "element", "(Ljava/lang/Object;)Z", "", "index", "(ILjava/lang/Object;)V", "addAll", "elements", "Landroidx/collection/ScatterSet;", "", "([Ljava/lang/Object;)Z", "(I[Ljava/lang/Object;)Z", "", "", "", "Lkotlin/sequences/Sequence;", "asList", "asMutableList", "", "clear", "ensureCapacity", "minusAssign", "(Ljava/lang/Object;)V", "([Ljava/lang/Object;)V", "plusAssign", "remove", "removeAll", "removeAt", "(I)Ljava/lang/Object;", "removeIf", "predicate", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "removeRange", "start", "end", "resizeStorage", "oldContent", "", "(I[Ljava/lang/Object;)V", "retainAll", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "throwIndexOutOfBoundsInclusiveException", "trim", "minCapacity", "MutableObjectListIterator", "ObjectListMutableList", "SubList", "collection"})
@SourceDebugExtension(value={"SMAP\nObjectList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectList.kt\nandroidx/collection/MutableObjectList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ScatterSet.kt\nandroidx/collection/ScatterSet\n+ 4 ScatterMap.kt\nandroidx/collection/ScatterMapKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 ObjectList.kt\nandroidx/collection/ObjectList\n+ 7 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 8 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1548:1\n903#1,5:1549\n903#1,5:1554\n903#1,5:1559\n903#1,5:1564\n903#1,5:1572\n903#1,5:1577\n903#1,5:1582\n919#1,2:1604\n903#1,5:1613\n903#1,5:1618\n919#1,2:1624\n919#1,2:1628\n629#1:1631\n924#1,2:1634\n924#1,2:1641\n924#1,2:1661\n924#1,2:1670\n924#1,2:1673\n924#1,2:1677\n1864#2,3:1569\n1855#2:1623\n1856#2:1626\n1855#2:1672\n1856#2:1675\n231#3,3:1587\n200#3,7:1590\n211#3,3:1598\n214#3,2:1602\n217#3,6:1606\n234#3:1612\n231#3,3:1644\n200#3,7:1647\n211#3,3:1655\n214#3,2:1659\n217#3,6:1663\n234#3:1669\n1399#4:1597\n1270#4:1601\n1399#4:1654\n1270#4:1658\n1313#5:1627\n1314#5:1630\n1313#5:1676\n1314#5:1679\n84#6:1632\n287#6,4:1637\n292#6:1643\n80#6:1680\n80#6:1681\n80#6:1682\n80#6:1683\n80#6:1684\n80#6:1685\n13309#7:1633\n13310#7:1636\n1#8:1686\n*S KotlinDebug\n*F\n+ 1 ObjectList.kt\nandroidx/collection/MutableObjectList\n*L\n633#1:1549,5\n649#1:1554,5\n678#1:1559,5\n708#1:1564,5\n738#1:1572,5\n825#1:1577,5\n839#1:1582,5\n840#1:1604,2\n846#1:1613,5\n856#1:1618,5\n866#1:1624,2\n871#1:1628,2\n892#1:1631\n1020#1:1634,2\n1025#1:1641,2\n1030#1:1661,2\n1036#1:1670,2\n1042#1:1673,2\n1047#1:1677,2\n718#1:1569,3\n866#1:1623\n866#1:1626\n1042#1:1672\n1042#1:1675\n840#1:1587,3\n840#1:1590,7\n840#1:1598,3\n840#1:1602,2\n840#1:1606,6\n840#1:1612\n1030#1:1644,3\n1030#1:1647,7\n1030#1:1655,3\n1030#1:1659,2\n1030#1:1663,6\n1030#1:1669\n840#1:1597\n840#1:1601\n1030#1:1654\n1030#1:1658\n871#1:1627\n871#1:1630\n1047#1:1676\n1047#1:1679\n946#1:1632\n1025#1:1637,4\n1025#1:1643\n1061#1:1680\n1113#1:1681\n1130#1:1682\n1147#1:1683\n1164#1:1684\n1181#1:1685\n1020#1:1633\n1020#1:1636\n*E\n"})
public final class MutableObjectList<E>
extends ObjectList<E> {
    @Nullable
    private ObjectListMutableList<E> list;

    public MutableObjectList(int initialCapacity) {
        super(initialCapacity, null);
    }

    public /* synthetic */ MutableObjectList(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 16;
        }
        this(n);
    }

    public final int getCapacity() {
        boolean $i$f$getCapacity = false;
        return this.content.length;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean add(E element) {
        void this_$iv;
        MutableObjectList mutableObjectList = this;
        int capacity$iv = this._size + 1;
        boolean $i$f$ensureCapacity = false;
        Object[] oldContent$iv = this_$iv.content;
        if (oldContent$iv.length < capacity$iv) {
            this_$iv.resizeStorage(capacity$iv, oldContent$iv);
        }
        this.content[this._size] = element;
        int n = this._size;
        this._size = n + 1;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void add(@IntRange(from=0L) int index, E element) {
        void this_$iv;
        if (!(0 <= index ? index <= this._size : false)) {
            this.throwIndexOutOfBoundsInclusiveException(index);
        }
        MutableObjectList mutableObjectList = this;
        int capacity$iv = this._size + 1;
        boolean $i$f$ensureCapacity = false;
        Object[] oldContent$iv = this_$iv.content;
        if (oldContent$iv.length < capacity$iv) {
            this_$iv.resizeStorage(capacity$iv, oldContent$iv);
        }
        Object[] content = this.content;
        if (index != this._size) {
            ArraysKt.copyInto((Object[])content, (Object[])content, (int)(index + 1), (int)index, (int)this._size);
        }
        content[index] = element;
        int n = this._size;
        this._size = n + 1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addAll(@IntRange(from=0L) int index, @NotNull E[] elements) {
        void this_$iv;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (!(0 <= index ? index <= this._size : false)) {
            this.throwIndexOutOfBoundsInclusiveException(index);
        }
        if (elements.length == 0) {
            return false;
        }
        MutableObjectList mutableObjectList = this;
        int capacity$iv = this._size + elements.length;
        boolean $i$f$ensureCapacity = false;
        Object[] oldContent$iv = this_$iv.content;
        if (oldContent$iv.length < capacity$iv) {
            this_$iv.resizeStorage(capacity$iv, oldContent$iv);
        }
        Object[] content = this.content;
        if (index != this._size) {
            ArraysKt.copyInto((Object[])content, (Object[])content, (int)(index + elements.length), (int)index, (int)this._size);
        }
        ArraysKt.copyInto$default((Object[])elements, (Object[])content, (int)index, (int)0, (int)0, (int)12, null);
        this._size += elements.length;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addAll(@IntRange(from=0L) int index, @NotNull Collection<? extends E> elements) {
        void this_$iv;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (!(0 <= index ? index <= this._size : false)) {
            this.throwIndexOutOfBoundsInclusiveException(index);
        }
        if (elements.isEmpty()) {
            return false;
        }
        MutableObjectList mutableObjectList = this;
        int capacity$iv = this._size + elements.size();
        boolean $i$f$ensureCapacity = false;
        Object[] oldContent$iv = this_$iv.content;
        if (oldContent$iv.length < capacity$iv) {
            this_$iv.resizeStorage(capacity$iv, oldContent$iv);
        }
        Object[] content = this.content;
        if (index != this._size) {
            ArraysKt.copyInto((Object[])content, (Object[])content, (int)(index + elements.size()), (int)index, (int)this._size);
        }
        Iterable $this$forEachIndexed$iv = elements;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void element;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv;
            int i = n;
            boolean bl = false;
            content[index + i] = element;
        }
        this._size += elements.size();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addAll(@IntRange(from=0L) int index, @NotNull ObjectList<E> elements) {
        void this_$iv;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (!(0 <= index ? index <= this._size : false)) {
            this.throwIndexOutOfBoundsInclusiveException(index);
        }
        if (elements.isEmpty()) {
            return false;
        }
        MutableObjectList mutableObjectList = this;
        int capacity$iv = this._size + elements._size;
        boolean $i$f$ensureCapacity = false;
        Object[] oldContent$iv = this_$iv.content;
        if (oldContent$iv.length < capacity$iv) {
            this_$iv.resizeStorage(capacity$iv, oldContent$iv);
        }
        Object[] content = this.content;
        if (index != this._size) {
            ArraysKt.copyInto((Object[])content, (Object[])content, (int)(index + elements._size), (int)index, (int)this._size);
        }
        ArraysKt.copyInto((Object[])elements.content, (Object[])content, (int)index, (int)0, (int)elements._size);
        this._size += elements._size;
        return true;
    }

    private final void throwIndexOutOfBoundsInclusiveException(int index) {
        RuntimeHelpersKt.throwIndexOutOfBoundsException("Index " + index + " must be in 0.." + this._size);
    }

    public final boolean addAll(@NotNull ObjectList<E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int oldSize = this._size;
        this.plusAssign((E)elements);
        return oldSize != this._size;
    }

    public final boolean addAll(@NotNull ScatterSet<E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int oldSize = this._size;
        this.plusAssign((E)elements);
        return oldSize != this._size;
    }

    public final boolean addAll(@NotNull E[] elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int oldSize = this._size;
        this.plusAssign((E)elements);
        return oldSize != this._size;
    }

    public final boolean addAll(@NotNull List<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int oldSize = this._size;
        this.plusAssign((E)elements);
        return oldSize != this._size;
    }

    public final boolean addAll(@NotNull Iterable<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int oldSize = this._size;
        this.plusAssign((E)elements);
        return oldSize != this._size;
    }

    public final boolean addAll(@NotNull Sequence<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int oldSize = this._size;
        this.plusAssign((E)elements);
        return oldSize != this._size;
    }

    /*
     * WARNING - void declaration
     */
    public final void plusAssign(@NotNull ObjectList<E> elements) {
        void this_$iv;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements.isEmpty()) {
            return;
        }
        MutableObjectList mutableObjectList = this;
        int capacity$iv = this._size + elements._size;
        boolean $i$f$ensureCapacity = false;
        Object[] oldContent$iv = this_$iv.content;
        if (oldContent$iv.length < capacity$iv) {
            this_$iv.resizeStorage(capacity$iv, oldContent$iv);
        }
        Object[] content = this.content;
        ArraysKt.copyInto((Object[])elements.content, (Object[])content, (int)this._size, (int)0, (int)elements._size);
        this._size += elements._size;
    }

    public final void plusAssign(@NotNull ScatterSet<E> elements) {
        ScatterSet<E> this_$iv;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements.isEmpty()) {
            return;
        }
        MutableObjectList mutableObjectList = this;
        int capacity$iv = this._size + elements.getSize();
        boolean $i$f$ensureCapacity = false;
        Object[] oldContent$iv = ((MutableObjectList)((Object)this_$iv)).content;
        if (oldContent$iv.length < capacity$iv) {
            ((MutableObjectList)((Object)this_$iv)).resizeStorage(capacity$iv, oldContent$iv);
        }
        this_$iv = elements;
        boolean $i$f$forEach = false;
        Object[] elements$iv = this_$iv.elements;
        ScatterSet<E> this_$iv$iv = this_$iv;
        boolean $i$f$forEachIndex = false;
        long[] m$iv$iv = this_$iv$iv.metadata;
        int lastIndex$iv$iv = m$iv$iv.length - 2;
        int i$iv$iv = 0;
        if (i$iv$iv <= lastIndex$iv$iv) {
            while (true) {
                long slot$iv$iv;
                long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv$iv < 128L) {
                            int index$iv$iv;
                            int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                            boolean bl = false;
                            Object element = elements$iv[index$iv];
                            boolean bl2 = false;
                            MutableObjectList this_$iv2 = this;
                            boolean $i$f$plusAssign = false;
                            this_$iv2.add(element);
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void plusAssign(@NotNull E[] elements) {
        void this_$iv;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements.length == 0) {
            return;
        }
        MutableObjectList mutableObjectList = this;
        int capacity$iv = this._size + elements.length;
        boolean $i$f$ensureCapacity = false;
        Object[] oldContent$iv = this_$iv.content;
        if (oldContent$iv.length < capacity$iv) {
            this_$iv.resizeStorage(capacity$iv, oldContent$iv);
        }
        Object[] content = this.content;
        ArraysKt.copyInto$default((Object[])elements, (Object[])content, (int)this._size, (int)0, (int)0, (int)12, null);
        this._size += elements.length;
    }

    /*
     * WARNING - void declaration
     */
    public final void plusAssign(@NotNull List<? extends E> elements) {
        void this_$iv;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements.isEmpty()) {
            return;
        }
        int size = this._size;
        MutableObjectList mutableObjectList = this;
        int capacity$iv = size + elements.size();
        boolean $i$f$ensureCapacity = false;
        Object[] oldContent$iv = this_$iv.content;
        if (oldContent$iv.length < capacity$iv) {
            this_$iv.resizeStorage(capacity$iv, oldContent$iv);
        }
        Object[] content = this.content;
        int n = ((Collection)elements).size();
        for (int i = 0; i < n; ++i) {
            content[i + size] = elements.get(i);
        }
        this._size += elements.size();
    }

    public final void plusAssign(@NotNull Iterable<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Iterable<E> $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        Iterator<E> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            E element$iv;
            E element = element$iv = iterator2.next();
            boolean bl = false;
            MutableObjectList this_$iv = this;
            boolean $i$f$plusAssign = false;
            this_$iv.add(element);
        }
    }

    public final void plusAssign(@NotNull Sequence<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Sequence<? extends E> $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object element = element$iv = iterator2.next();
            boolean bl = false;
            MutableObjectList this_$iv = this;
            boolean $i$f$plusAssign = false;
            this_$iv.add(element);
        }
    }

    public final void clear() {
        ArraysKt.fill((Object[])this.content, null, (int)0, (int)this._size);
        this._size = 0;
    }

    public final void trim(int minCapacity) {
        int minSize = Math.max(minCapacity, this._size);
        MutableObjectList this_$iv = this;
        boolean $i$f$getCapacity = false;
        if (this_$iv.content.length > minSize) {
            Object[] objectArray = Arrays.copyOf(this.content, minSize);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
            this.content = objectArray;
        }
    }

    public static /* synthetic */ void trim$default(MutableObjectList mutableObjectList, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = mutableObjectList._size;
        }
        mutableObjectList.trim(n);
    }

    public final void ensureCapacity(int capacity) {
        boolean $i$f$ensureCapacity = false;
        Object[] oldContent = this.content;
        if (oldContent.length < capacity) {
            this.resizeStorage(capacity, oldContent);
        }
    }

    @PublishedApi
    public final void resizeStorage(int capacity, @NotNull Object[] oldContent) {
        Intrinsics.checkNotNullParameter((Object)oldContent, (String)"oldContent");
        int oldSize = oldContent.length;
        int newSize = Math.max(capacity, oldSize * 3 / 2);
        Object[] newContent = new Object[newSize];
        this.content = ArraysKt.copyInto((Object[])oldContent, (Object[])newContent, (int)0, (int)0, (int)oldSize);
    }

    public final void plusAssign(E element) {
        boolean $i$f$plusAssign = false;
        this.add(element);
    }

    public final void minusAssign(E element) {
        boolean $i$f$minusAssign = false;
        this.remove(element);
    }

    public final boolean remove(E element) {
        int index = this.indexOf(element);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    public final void removeIf(@NotNull Function1<? super E, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$removeIf = false;
        int gap = 0;
        int size = this._size;
        Object[] content = this.content;
        ObjectList this_$iv = this;
        boolean $i$f$getIndices = false;
        kotlin.ranges.IntRange intRange = RangesKt.until((int)0, (int)this_$iv._size);
        int i = intRange.getFirst();
        int n = intRange.getLast();
        if (i <= n) {
            while (true) {
                content[i - gap] = content[i];
                if (((Boolean)predicate.invoke(content[i])).booleanValue()) {
                    ++gap;
                }
                if (i == n) break;
                ++i;
            }
        }
        ArraysKt.fill((Object[])content, null, (int)(size - gap), (int)size);
        this._size -= gap;
    }

    public final boolean removeAll(@NotNull E[] elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int initialSize = this._size;
        int n = elements.length;
        for (int i = 0; i < n; ++i) {
            this.remove(elements[i]);
        }
        return initialSize != this._size;
    }

    public final boolean removeAll(@NotNull ObjectList<E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int initialSize = this._size;
        this.minusAssign(elements);
        return initialSize != this._size;
    }

    public final boolean removeAll(@NotNull ScatterSet<E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int initialSize = this._size;
        this.minusAssign(elements);
        return initialSize != this._size;
    }

    public final boolean removeAll(@NotNull List<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int initialSize = this._size;
        this.minusAssign(elements);
        return initialSize != this._size;
    }

    public final boolean removeAll(@NotNull Iterable<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int initialSize = this._size;
        this.minusAssign(elements);
        return initialSize != this._size;
    }

    public final boolean removeAll(@NotNull Sequence<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int initialSize = this._size;
        this.minusAssign(elements);
        return initialSize != this._size;
    }

    public final void minusAssign(@NotNull E[] elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        E[] $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            E element$iv;
            E element = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            MutableObjectList this_$iv = this;
            boolean $i$f$minusAssign = false;
            this_$iv.remove(element);
        }
    }

    public final void minusAssign(@NotNull ObjectList<E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        ObjectList<E> this_$iv = elements;
        boolean $i$f$forEach = false;
        Object[] content$iv = this_$iv.content;
        int n = this_$iv._size;
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            Object element = content$iv[i$iv];
            boolean bl = false;
            MutableObjectList this_$iv2 = this;
            boolean $i$f$minusAssign = false;
            this_$iv2.remove(element);
        }
    }

    public final void minusAssign(@NotNull ScatterSet<E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        ScatterSet<E> this_$iv = elements;
        boolean $i$f$forEach = false;
        Object[] elements$iv = this_$iv.elements;
        ScatterSet<E> this_$iv$iv = this_$iv;
        boolean $i$f$forEachIndex = false;
        long[] m$iv$iv = this_$iv$iv.metadata;
        int lastIndex$iv$iv = m$iv$iv.length - 2;
        int i$iv$iv = 0;
        if (i$iv$iv <= lastIndex$iv$iv) {
            while (true) {
                long slot$iv$iv;
                long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv$iv < 128L) {
                            int index$iv$iv;
                            int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                            boolean bl = false;
                            Object element = elements$iv[index$iv];
                            boolean bl2 = false;
                            MutableObjectList this_$iv2 = this;
                            boolean $i$f$minusAssign = false;
                            this_$iv2.remove(element);
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void minusAssign(@NotNull List<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int n = ((Collection)elements).size();
        for (int i = 0; i < n; ++i) {
            void this_$iv;
            MutableObjectList mutableObjectList = this;
            E element$iv = elements.get(i);
            boolean $i$f$minusAssign = false;
            this_$iv.remove(element$iv);
        }
    }

    public final void minusAssign(@NotNull Iterable<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Iterable<E> $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        Iterator<E> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            E element$iv;
            E element = element$iv = iterator2.next();
            boolean bl = false;
            MutableObjectList this_$iv = this;
            boolean $i$f$minusAssign = false;
            this_$iv.remove(element);
        }
    }

    public final void minusAssign(@NotNull Sequence<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Sequence<? extends E> $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object element = element$iv = iterator2.next();
            boolean bl = false;
            MutableObjectList this_$iv = this;
            boolean $i$f$minusAssign = false;
            this_$iv.remove(element);
        }
    }

    public final E removeAt(@IntRange(from=0L) int index) {
        if (!(0 <= index ? index < this._size : false)) {
            this.throwIndexOutOfBoundsExclusiveException$collection(index);
        }
        Object[] content = this.content;
        Object element = content[index];
        ObjectList this_$iv = this;
        boolean $i$f$getLastIndex = false;
        if (index != this_$iv._size - 1) {
            ArraysKt.copyInto((Object[])content, (Object[])content, (int)index, (int)(index + 1), (int)this._size);
        }
        int n = this._size;
        this._size = n + -1;
        content[this._size] = null;
        return (E)element;
    }

    public final void removeRange(@IntRange(from=0L) int start2, @IntRange(from=0L) int end) {
        block7: {
            block6: {
                boolean bl = 0 <= start2 ? start2 <= this._size : false;
                if (!bl) break block6;
                if (0 <= end ? end <= this._size : false) break block7;
            }
            RuntimeHelpersKt.throwIndexOutOfBoundsException("Start (" + start2 + ") and end (" + end + ") must be in 0.." + this._size);
        }
        if (end < start2) {
            RuntimeHelpersKt.throwIllegalArgumentException("Start (" + start2 + ") is more than end (" + end + ')');
        }
        if (end != start2) {
            if (end < this._size) {
                ArraysKt.copyInto((Object[])this.content, (Object[])this.content, (int)start2, (int)end, (int)this._size);
            }
            int newSize = this._size - (end - start2);
            ArraysKt.fill((Object[])this.content, null, (int)newSize, (int)this._size);
            this._size = newSize;
        }
    }

    public final boolean retainAll(@NotNull E[] elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int initialSize = this._size;
        Object[] content = this.content;
        ObjectList this_$iv = this;
        boolean $i$f$getLastIndex = false;
        for (int i = this_$iv._size - 1; -1 < i; --i) {
            Object element = content[i];
            if (ArraysKt.indexOf((Object[])elements, (Object)element) >= 0) continue;
            this.removeAt(i);
        }
        return initialSize != this._size;
    }

    public final boolean retainAll(@NotNull ObjectList<E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int initialSize = this._size;
        Object[] content = this.content;
        ObjectList this_$iv = this;
        boolean $i$f$getLastIndex = false;
        for (int i = this_$iv._size - 1; -1 < i; --i) {
            Object element = content[i];
            if (elements.contains(element)) continue;
            this.removeAt(i);
        }
        return initialSize != this._size;
    }

    public final boolean retainAll(@NotNull Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int initialSize = this._size;
        Object[] content = this.content;
        ObjectList this_$iv = this;
        boolean $i$f$getLastIndex = false;
        for (int i = this_$iv._size - 1; -1 < i; --i) {
            Object element = content[i];
            if (elements.contains(element)) continue;
            this.removeAt(i);
        }
        return initialSize != this._size;
    }

    public final boolean retainAll(@NotNull Iterable<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int initialSize = this._size;
        Object[] content = this.content;
        ObjectList this_$iv = this;
        boolean $i$f$getLastIndex = false;
        for (int i = this_$iv._size - 1; -1 < i; --i) {
            Object element = content[i];
            if (CollectionsKt.contains(elements, (Object)element)) continue;
            this.removeAt(i);
        }
        return initialSize != this._size;
    }

    public final boolean retainAll(@NotNull Sequence<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int initialSize = this._size;
        Object[] content = this.content;
        ObjectList this_$iv = this;
        boolean $i$f$getLastIndex = false;
        for (int i = this_$iv._size - 1; -1 < i; --i) {
            Object element = content[i];
            if (SequencesKt.contains(elements, (Object)element)) continue;
            this.removeAt(i);
        }
        return initialSize != this._size;
    }

    public final E set(@IntRange(from=0L) int index, E element) {
        if (!(0 <= index ? index < this._size : false)) {
            this.throwIndexOutOfBoundsExclusiveException$collection(index);
        }
        Object[] content = this.content;
        Object old = content[index];
        content[index] = element;
        return (E)old;
    }

    @Override
    @NotNull
    public List<E> asList() {
        return this.asMutableList();
    }

    @NotNull
    public final List<E> asMutableList() {
        List list;
        ObjectListMutableList<E> objectListMutableList = this.list;
        if (objectListMutableList != null) {
            list = objectListMutableList;
        } else {
            ObjectListMutableList objectListMutableList2;
            ObjectListMutableList it = objectListMutableList2 = new ObjectListMutableList(this);
            boolean bl = false;
            this.list = it;
            list = objectListMutableList2;
        }
        return list;
    }

    public MutableObjectList() {
        this(0, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010+\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\fJ\t\u0010\r\u001a\u00020\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u000e\u0010\u0010\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0006H\u0016J\r\u0010\u0013\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0014\u001a\u00020\u0006H\u0016J\b\u0010\u0015\u001a\u00020\nH\u0016J\u0015\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Landroidx/collection/MutableObjectList$MutableObjectListIterator;", "T", "", "list", "", "index", "", "(Ljava/util/List;I)V", "prevIndex", "add", "", "element", "(Ljava/lang/Object;)V", "hasNext", "", "hasPrevious", "next", "()Ljava/lang/Object;", "nextIndex", "previous", "previousIndex", "remove", "set", "collection"})
    private static final class MutableObjectListIterator<T>
    implements ListIterator<T>,
    KMutableListIterator {
        @NotNull
        private final List<T> list;
        private int prevIndex;

        public MutableObjectListIterator(@NotNull List<T> list, int index) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            this.list = list;
            this.prevIndex = index - 1;
        }

        @Override
        public boolean hasNext() {
            return this.prevIndex < this.list.size() - 1;
        }

        @Override
        public T next() {
            ++this.prevIndex;
            return this.list.get(this.prevIndex);
        }

        @Override
        public void remove() {
            this.list.remove(this.prevIndex);
            int n = this.prevIndex;
            this.prevIndex = n + -1;
        }

        @Override
        public boolean hasPrevious() {
            return this.prevIndex >= 0;
        }

        @Override
        public int nextIndex() {
            return this.prevIndex + 1;
        }

        @Override
        public T previous() {
            int n = this.prevIndex;
            this.prevIndex = n + -1;
            return this.list.get(n);
        }

        @Override
        public int previousIndex() {
            return this.prevIndex;
        }

        @Override
        public void add(T element) {
            ++this.prevIndex;
            this.list.add(this.prevIndex, element);
        }

        @Override
        public void set(T element) {
            this.list.set(this.prevIndex, element);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010+\n\u0002\b\n\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\rJ\u001d\u0010\n\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0010J\u001e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013H\u0016J\u0016\u0010\u0011\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0016J\u0016\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u0016\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013H\u0016J\u0016\u0010\u0017\u001a\u00028\u00012\u0006\u0010\u000f\u001a\u00020\u0007H\u0096\u0002\u00a2\u0006\u0002\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\u00072\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u000bH\u0016J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00010\u001dH\u0096\u0002J\u0015\u0010\u001e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010 H\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010 2\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\u0015\u0010!\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\"\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013H\u0016J\u0015\u0010#\u001a\u00028\u00012\u0006\u0010\u000f\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010$\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013H\u0016J\u001e\u0010%\u001a\u00028\u00012\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\f\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010&J\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00010\u00022\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u0007H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006*"}, d2={"Landroidx/collection/MutableObjectList$ObjectListMutableList;", "T", "", "objectList", "Landroidx/collection/MutableObjectList;", "(Landroidx/collection/MutableObjectList;)V", "size", "", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "", "index", "(ILjava/lang/Object;)V", "addAll", "elements", "", "clear", "contains", "containsAll", "get", "(I)Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "remove", "removeAll", "removeAt", "retainAll", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "subList", "fromIndex", "toIndex", "collection"})
    private static final class ObjectListMutableList<T>
    implements List<T>,
    KMutableList {
        @NotNull
        private final MutableObjectList<T> objectList;

        public ObjectListMutableList(@NotNull MutableObjectList<T> objectList) {
            Intrinsics.checkNotNullParameter(objectList, (String)"objectList");
            this.objectList = objectList;
        }

        public int getSize() {
            return this.objectList.getSize();
        }

        @Override
        public boolean contains(Object element) {
            return this.objectList.contains(element);
        }

        @Override
        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.objectList.containsAll((Iterable)elements);
        }

        @Override
        public T get(int index) {
            ObjectListKt.access$checkIndex(this, index);
            return (T)this.objectList.get(index);
        }

        @Override
        public int indexOf(Object element) {
            return this.objectList.indexOf(element);
        }

        @Override
        public boolean isEmpty() {
            return this.objectList.isEmpty();
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return new MutableObjectListIterator(this, 0);
        }

        @Override
        public int lastIndexOf(Object element) {
            return this.objectList.lastIndexOf(element);
        }

        @Override
        public boolean add(T element) {
            return this.objectList.add(element);
        }

        @Override
        public void add(int index, T element) {
            this.objectList.add(index, element);
        }

        @Override
        public boolean addAll(int index, @NotNull Collection<? extends T> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.objectList.addAll(index, elements);
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends T> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.objectList.addAll((Iterable)elements);
        }

        @Override
        public void clear() {
            this.objectList.clear();
        }

        @Override
        @NotNull
        public ListIterator<T> listIterator() {
            return new MutableObjectListIterator(this, 0);
        }

        @Override
        @NotNull
        public ListIterator<T> listIterator(int index) {
            return new MutableObjectListIterator(this, index);
        }

        @Override
        public boolean remove(Object element) {
            return this.objectList.remove(element);
        }

        @Override
        public boolean removeAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.objectList.removeAll((Iterable)elements);
        }

        public T removeAt(int index) {
            ObjectListKt.access$checkIndex(this, index);
            return this.objectList.removeAt(index);
        }

        @Override
        public boolean retainAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.objectList.retainAll(elements);
        }

        @Override
        public T set(int index, T element) {
            ObjectListKt.access$checkIndex(this, index);
            return this.objectList.set(index, element);
        }

        @Override
        @NotNull
        public List<T> subList(int fromIndex, int toIndex) {
            ObjectListKt.access$checkSubIndex(this, fromIndex, toIndex);
            return new SubList(this, fromIndex, toIndex);
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            return CollectionToArray.toArray((Collection)this, (Object[])array);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010+\n\u0002\b\n\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u001d\u0010\u000b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0014H\u0016J\u0016\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0016J\u0016\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u0017\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0014H\u0016J\u0016\u0010\u0018\u001a\u00028\u00012\u0006\u0010\u0010\u001a\u00020\u0005H\u0096\u0002\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\u00052\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\fH\u0016J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00010\u001eH\u0096\u0002J\u0015\u0010\u001f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00010!H\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00010!2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0015\u0010\"\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010#\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0014H\u0016J\u0015\u0010$\u001a\u00028\u00012\u0006\u0010\u0010\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0016\u0010%\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0014H\u0016J\u001e\u0010&\u001a\u00028\u00012\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010'J\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00010\u00022\u0006\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0005H\u0016R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Landroidx/collection/MutableObjectList$SubList;", "T", "", "list", "start", "", "end", "(Ljava/util/List;II)V", "size", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "", "index", "(ILjava/lang/Object;)V", "addAll", "elements", "", "clear", "contains", "containsAll", "get", "(I)Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "remove", "removeAll", "removeAt", "retainAll", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "subList", "fromIndex", "toIndex", "collection"})
    @SourceDebugExtension(value={"SMAP\nObjectList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectList.kt\nandroidx/collection/MutableObjectList$SubList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1548:1\n1855#2,2:1549\n1855#2,2:1551\n*S KotlinDebug\n*F\n+ 1 ObjectList.kt\nandroidx/collection/MutableObjectList$SubList\n*L\n1345#1:1549,2\n1427#1:1551,2\n*E\n"})
    private static final class SubList<T>
    implements List<T>,
    KMutableList {
        @NotNull
        private final List<T> list;
        private final int start;
        private int end;

        public SubList(@NotNull List<T> list, int start2, int end) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            this.list = list;
            this.start = start2;
            this.end = end;
        }

        public int getSize() {
            return this.end - this.start;
        }

        @Override
        public boolean contains(Object element) {
            int n = this.end;
            for (int i = this.start; i < n; ++i) {
                if (!Intrinsics.areEqual(this.list.get(i), (Object)element)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator2.next();
                boolean bl = false;
                if (this.contains(it)) continue;
                return false;
            }
            return true;
        }

        @Override
        public T get(int index) {
            ObjectListKt.access$checkIndex(this, index);
            return this.list.get(index + this.start);
        }

        @Override
        public int indexOf(Object element) {
            int n = this.end;
            for (int i = this.start; i < n; ++i) {
                if (!Intrinsics.areEqual(this.list.get(i), (Object)element)) continue;
                return i - this.start;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.end == this.start;
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return new MutableObjectListIterator(this, 0);
        }

        @Override
        public int lastIndexOf(Object element) {
            int n = this.start;
            int i = this.end - 1;
            if (n <= i) {
                while (true) {
                    if (Intrinsics.areEqual(this.list.get(i), (Object)element)) {
                        return i - this.start;
                    }
                    if (i == n) break;
                    --i;
                }
            }
            return -1;
        }

        @Override
        public boolean add(T element) {
            int n = this.end;
            this.end = n + 1;
            this.list.add(n, element);
            return true;
        }

        @Override
        public void add(int index, T element) {
            this.list.add(index + this.start, element);
            int n = this.end;
            this.end = n + 1;
        }

        @Override
        public boolean addAll(int index, @NotNull Collection<? extends T> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            this.list.addAll(index + this.start, elements);
            this.end += elements.size();
            return elements.size() > 0;
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends T> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            this.list.addAll(this.end, elements);
            this.end += elements.size();
            return elements.size() > 0;
        }

        @Override
        public void clear() {
            int n = this.start;
            int i = this.end - 1;
            if (n <= i) {
                while (true) {
                    this.list.remove(i);
                    if (i == n) break;
                    --i;
                }
            }
            this.end = this.start;
        }

        @Override
        @NotNull
        public ListIterator<T> listIterator() {
            return new MutableObjectListIterator(this, 0);
        }

        @Override
        @NotNull
        public ListIterator<T> listIterator(int index) {
            return new MutableObjectListIterator(this, index);
        }

        @Override
        public boolean remove(Object element) {
            int n = this.end;
            for (int i = this.start; i < n; ++i) {
                if (!Intrinsics.areEqual(this.list.get(i), (Object)element)) continue;
                this.list.remove(i);
                int n2 = this.end;
                this.end = n2 + -1;
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            int originalEnd = this.end;
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator2.next();
                boolean bl = false;
                this.remove(it);
            }
            return originalEnd != this.end;
        }

        public T removeAt(int index) {
            ObjectListKt.access$checkIndex(this, index);
            T element = this.list.remove(index + this.start);
            int n = this.end;
            this.end = n + -1;
            return element;
        }

        @Override
        public boolean retainAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            int originalEnd = this.end;
            int i = this.end - 1;
            int n = this.start;
            if (n <= i) {
                while (true) {
                    T element;
                    if (!elements.contains(element = this.list.get(i))) {
                        this.list.remove(i);
                        int n2 = this.end;
                        this.end = n2 + -1;
                    }
                    if (i == n) break;
                    --i;
                }
            }
            return originalEnd != this.end;
        }

        @Override
        public T set(int index, T element) {
            ObjectListKt.access$checkIndex(this, index);
            return this.list.set(index + this.start, element);
        }

        @Override
        @NotNull
        public List<T> subList(int fromIndex, int toIndex) {
            ObjectListKt.access$checkSubIndex(this, fromIndex, toIndex);
            return new SubList<T>(this, fromIndex, toIndex);
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            return CollectionToArray.toArray((Collection)this, (Object[])array);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }
}

