/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.annotation.IntRange;
import androidx.collection.internal.Lock;
import androidx.collection.internal.LruHashMap;
import androidx.collection.internal.RuntimeHelpersKt;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002B\u000f\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\u0011\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0012\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0013J\u0006\u0010\u0007\u001a\u00020\u0005J/\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u00012\b\u0010\u0019\u001a\u0004\u0018\u00018\u0001H\u0014\u00a2\u0006\u0002\u0010\u001aJ\u0006\u0010\u001b\u001a\u00020\u0015J\u0006\u0010\b\u001a\u00020\u0005J\u0018\u0010\u001c\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0012\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u0013J\u0006\u0010\t\u001a\u00020\u0005J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u000e\u001a\u00020\u0005J\u001d\u0010\u001d\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001fJ\u0006\u0010\u000f\u001a\u00020\u0005J\u0015\u0010 \u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0012\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010!\u001a\u00020\u00152\b\b\u0001\u0010\u0004\u001a\u00020\u0005H\u0016J\u001d\u0010\"\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010#J\u0006\u0010\u0010\u001a\u00020\u0005J\u001d\u0010$\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010#J\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010&J\b\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u0005H\u0016R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Landroidx/collection/LruCache;", "K", "", "V", "maxSize", "", "(I)V", "createCount", "evictionCount", "hitCount", "lock", "Landroidx/collection/internal/Lock;", "map", "Landroidx/collection/internal/LruHashMap;", "missCount", "putCount", "size", "create", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "entryRemoved", "", "evicted", "", "oldValue", "newValue", "(ZLjava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "evictAll", "get", "put", "value", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "remove", "resize", "safeSizeOf", "(Ljava/lang/Object;Ljava/lang/Object;)I", "sizeOf", "snapshot", "", "toString", "", "trimToSize", "collection"})
@SourceDebugExtension(value={"SMAP\nLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LruCache.kt\nandroidx/collection/LruCache\n+ 2 RuntimeHelpers.kt\nandroidx/collection/internal/RuntimeHelpersKt\n+ 3 LockExt.kt\nandroidx/collection/internal/LockExtKt\n+ 4 Lock.jvm.kt\nandroidx/collection/internal/Lock\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,356:1\n59#2,5:357\n59#2,5:362\n45#2,5:382\n45#2,5:390\n26#3,2:367\n26#3,2:370\n26#3,2:373\n26#3,2:376\n26#3,2:379\n26#3,2:387\n26#3,2:395\n26#3,2:398\n26#3,2:401\n26#3,2:404\n26#3,2:407\n26#3,2:410\n26#3,2:413\n26#3,2:416\n26#3,2:421\n26#4:369\n26#4:372\n26#4:375\n26#4:378\n26#4:381\n26#4:389\n26#4:397\n26#4:400\n26#4:403\n26#4:406\n26#4:409\n26#4:412\n26#4:415\n26#4:418\n26#4:423\n1855#5,2:419\n*S KotlinDebug\n*F\n+ 1 LruCache.kt\nandroidx/collection/LruCache\n*L\n62#1:357,5\n83#1:362,5\n170#1:382,5\n245#1:390,5\n85#1:367,2\n96#1:370,2\n113#1:373,2\n140#1:376,2\n169#1:379,2\n198#1:387,2\n267#1:395,2\n274#1:398,2\n277#1:401,2\n280#1:404,2\n283#1:407,2\n286#1:410,2\n289#1:413,2\n298#1:416,2\n306#1:421,2\n85#1:369\n96#1:372\n113#1:375\n140#1:378\n169#1:381\n198#1:389\n267#1:397\n274#1:400\n277#1:403\n280#1:406\n283#1:409\n286#1:412\n289#1:415\n298#1:418\n306#1:423\n300#1:419,2\n*E\n"})
public class LruCache<K, V> {
    private int maxSize;
    @NotNull
    private final LruHashMap<K, V> map;
    @NotNull
    private final Lock lock;
    private int size;
    private int putCount;
    private int createCount;
    private int evictionCount;
    private int hitCount;
    private int missCount;

    public LruCache(@IntRange(from=1L, to=0x7FFFFFFFL) int maxSize) {
        this.maxSize = maxSize;
        boolean value$iv = this.maxSize > 0;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            RuntimeHelpersKt.throwIllegalArgumentException("maxSize <= 0");
        }
        this.map = new LruHashMap(0, 0.75f);
        this.lock = new Lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(@IntRange(from=1L, to=0x7FFFFFFFL) int maxSize) {
        boolean value$iv = maxSize > 0;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            RuntimeHelpersKt.throwIllegalArgumentException("maxSize <= 0");
        }
        Lock $this$synchronized$iv = this.lock;
        boolean $i$f$synchronized = false;
        Lock this_$iv$iv = $this$synchronized$iv;
        boolean $i$f$synchronizedImpl = false;
        Lock lock = this_$iv$iv;
        synchronized (lock) {
            boolean bl = false;
            this.maxSize = maxSize;
            Unit unit = Unit.INSTANCE;
        }
        this.trimToSize(maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final V get(@NotNull K key) {
        V v;
        int n;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        V mapValue = null;
        Lock $this$synchronized$iv = this.lock;
        boolean $i$f$synchronized = false;
        Lock this_$iv$iv = $this$synchronized$iv;
        boolean $i$f$synchronizedImpl = false;
        Lock lock = this_$iv$iv;
        synchronized (lock) {
            block12: {
                boolean bl = false;
                mapValue = this.map.get(key);
                if (mapValue == null) break block12;
                int n2 = this.hitCount;
                this.hitCount = n2 + 1;
                V v2 = mapValue;
                return v2;
            }
            int n3 = this.missCount;
            this.missCount = n3 + 1;
            n = n3;
        }
        V v3 = this.create(key);
        if (v3 == null) {
            return null;
        }
        V createdValue = v3;
        Lock $this$synchronized$iv2 = this.lock;
        boolean $i$f$synchronized2 = false;
        Lock this_$iv$iv2 = $this$synchronized$iv2;
        boolean $i$f$synchronizedImpl2 = false;
        Lock lock2 = this_$iv$iv2;
        synchronized (lock2) {
            Unit unit;
            boolean bl = false;
            n = this.createCount;
            this.createCount = n + 1;
            mapValue = this.map.put(key, createdValue);
            if (mapValue != null) {
                unit = this.map.put(key, mapValue);
            } else {
                this.size += this.safeSizeOf(key, createdValue);
                unit = Unit.INSTANCE;
            }
            Unit unit2 = unit;
        }
        if (mapValue != null) {
            this.entryRemoved(false, key, createdValue, mapValue);
            v = mapValue;
        } else {
            this.trimToSize(this.maxSize);
            v = createdValue;
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final V put(@NotNull K key, @NotNull V value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        V previous = null;
        Lock $this$synchronized$iv = this.lock;
        boolean $i$f$synchronized = false;
        Lock this_$iv$iv = $this$synchronized$iv;
        boolean $i$f$synchronizedImpl = false;
        Lock lock = this_$iv$iv;
        synchronized (lock) {
            boolean bl = false;
            int n = this.putCount;
            this.putCount = n + 1;
            this.size += this.safeSizeOf(key, value);
            previous = this.map.put(key, value);
            if (previous != null) {
                this.size -= this.safeSizeOf(key, previous);
            }
            Unit unit = Unit.INSTANCE;
        }
        if (previous != null) {
            this.entryRemoved(false, key, previous, value);
        }
        this.trimToSize(this.maxSize);
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToSize(int maxSize) {
        while (true) {
            K key = null;
            V value = null;
            Lock $this$synchronized$iv = this.lock;
            boolean $i$f$synchronized = false;
            Lock this_$iv$iv = $this$synchronized$iv;
            boolean $i$f$synchronizedImpl = false;
            Lock lock = this_$iv$iv;
            synchronized (lock) {
                Map.Entry toEvict;
                block10: {
                    block9: {
                        boolean bl = false;
                        boolean value$iv = this.size >= 0 && (!this.map.isEmpty() || this.size == 0);
                        boolean $i$f$checkPrecondition = false;
                        if (!value$iv) {
                            boolean bl2 = false;
                            RuntimeHelpersKt.throwIllegalStateException("LruCache.sizeOf() is reporting inconsistent results!");
                        }
                        if (this.size <= maxSize) break block9;
                        if (!this.map.isEmpty()) break block10;
                    }
                    return;
                }
                if ((Map.Entry)CollectionsKt.firstOrNull((Iterable)this.map.getEntries()) == null) {
                    return;
                }
                key = toEvict.getKey();
                value = toEvict.getValue();
                this.map.remove(key);
                this.size -= this.safeSizeOf(key, value);
                int n = this.evictionCount;
                this.evictionCount = n + 1;
                int n2 = n;
            }
            this.entryRemoved(true, key, value, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final V remove(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        V previous = null;
        Lock $this$synchronized$iv = this.lock;
        boolean $i$f$synchronized = false;
        Lock this_$iv$iv = $this$synchronized$iv;
        boolean $i$f$synchronizedImpl = false;
        Lock lock = this_$iv$iv;
        synchronized (lock) {
            boolean bl = false;
            previous = this.map.remove(key);
            if (previous != null) {
                this.size -= this.safeSizeOf(key, previous);
            }
            Unit unit = Unit.INSTANCE;
        }
        if (previous != null) {
            this.entryRemoved(false, key, previous, null);
        }
        return previous;
    }

    protected void entryRemoved(boolean evicted, @NotNull K key, @NotNull V oldValue, @Nullable V newValue) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(oldValue, (String)"oldValue");
    }

    @Nullable
    protected V create(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return null;
    }

    private final int safeSizeOf(K key, V value) {
        int result = this.sizeOf(key, value);
        boolean value$iv = result >= 0;
        boolean $i$f$checkPrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            RuntimeHelpersKt.throwIllegalStateException("Negative size: " + key + '=' + value);
        }
        return result;
    }

    protected int sizeOf(@NotNull K key, @NotNull V value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return 1;
    }

    public final void evictAll() {
        this.trimToSize(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int size() {
        int n;
        Lock $this$synchronized$iv = this.lock;
        boolean $i$f$synchronized = false;
        Lock this_$iv$iv = $this$synchronized$iv;
        boolean $i$f$synchronizedImpl = false;
        Lock lock = this_$iv$iv;
        synchronized (lock) {
            boolean bl = false;
            n = this.size;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int maxSize() {
        int n;
        Lock $this$synchronized$iv = this.lock;
        boolean $i$f$synchronized = false;
        Lock this_$iv$iv = $this$synchronized$iv;
        boolean $i$f$synchronizedImpl = false;
        Lock lock = this_$iv$iv;
        synchronized (lock) {
            boolean bl = false;
            n = this.maxSize;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int hitCount() {
        int n;
        Lock $this$synchronized$iv = this.lock;
        boolean $i$f$synchronized = false;
        Lock this_$iv$iv = $this$synchronized$iv;
        boolean $i$f$synchronizedImpl = false;
        Lock lock = this_$iv$iv;
        synchronized (lock) {
            boolean bl = false;
            n = this.hitCount;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int missCount() {
        int n;
        Lock $this$synchronized$iv = this.lock;
        boolean $i$f$synchronized = false;
        Lock this_$iv$iv = $this$synchronized$iv;
        boolean $i$f$synchronizedImpl = false;
        Lock lock = this_$iv$iv;
        synchronized (lock) {
            boolean bl = false;
            n = this.missCount;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int createCount() {
        int n;
        Lock $this$synchronized$iv = this.lock;
        boolean $i$f$synchronized = false;
        Lock this_$iv$iv = $this$synchronized$iv;
        boolean $i$f$synchronizedImpl = false;
        Lock lock = this_$iv$iv;
        synchronized (lock) {
            boolean bl = false;
            n = this.createCount;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int putCount() {
        int n;
        Lock $this$synchronized$iv = this.lock;
        boolean $i$f$synchronized = false;
        Lock this_$iv$iv = $this$synchronized$iv;
        boolean $i$f$synchronizedImpl = false;
        Lock lock = this_$iv$iv;
        synchronized (lock) {
            boolean bl = false;
            n = this.putCount;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int evictionCount() {
        int n;
        Lock $this$synchronized$iv = this.lock;
        boolean $i$f$synchronized = false;
        Lock this_$iv$iv = $this$synchronized$iv;
        boolean $i$f$synchronizedImpl = false;
        Lock lock = this_$iv$iv;
        synchronized (lock) {
            boolean bl = false;
            n = this.evictionCount;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Map<K, V> snapshot() {
        Lock $this$synchronized$iv = this.lock;
        boolean $i$f$synchronized = false;
        Lock this_$iv$iv = $this$synchronized$iv;
        boolean $i$f$synchronizedImpl = false;
        Lock lock = this_$iv$iv;
        synchronized (lock) {
            boolean bl = false;
            LinkedHashMap copy = new LinkedHashMap(this.map.getEntries().size());
            Iterable $this$forEach$iv = this.map.getEntries();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl2 = false;
                Object key = entry.getKey();
                Object value = entry.getValue();
                ((Map)copy).put(key, value);
            }
            Map map = copy;
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String toString() {
        Lock $this$synchronized$iv = this.lock;
        boolean $i$f$synchronized = false;
        Lock this_$iv$iv = $this$synchronized$iv;
        boolean $i$f$synchronizedImpl = false;
        Lock lock = this_$iv$iv;
        synchronized (lock) {
            boolean bl = false;
            int accesses = this.hitCount + this.missCount;
            int hitPercent = accesses != 0 ? 100 * this.hitCount / accesses : 0;
            String string = "LruCache[maxSize=" + this.maxSize + ",hits=" + this.hitCount + ",misses=" + this.missCount + ",hitRate=" + hitPercent + "%]";
            return string;
        }
    }
}

