package com.mineinabyss.geary.prefabs.configuration.systems

import com.mineinabyss.geary.annotations.Handler
import com.mineinabyss.geary.systems.Listener
import com.mineinabyss.geary.systems.accessors.RelationWithData
import com.mineinabyss.geary.systems.accessors.TargetScope

class ParseRelationWithDataSystem : Listener() {
    private val TargetScope.relationWithData by onSet<RelationWithData<*, *>>().onTarget()

    @Handler
    private fun TargetScope.convertToRelation() {
        val data = relationWithData.data
        val targetData = relationWithData.targetData
        if (data != null) entity.set(data, relationWithData.relation.id)
        else entity.add(relationWithData.relation.id)
        if (targetData != null) entity.set(targetData, relationWithData.target.id)
        entity.remove<RelationWithData<*, *>>()
    }
}
