/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.geary.papermc.tracking.items.inventory;

import com.mineinabyss.geary.datatypes.Entity;
import com.mineinabyss.geary.papermc.tracking.items.inventory.InventoryCacheWrapper;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\f\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\f\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u000e2\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u000e2\u0006\u0010\u0018\u001a\u00020\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\u001a\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0019\u0010\u001d\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001cR\u0019\u0010\u001f\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u000e8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001cR\u0019\u0010!\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001cR\u0019\u0010#\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u000e8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001cR\u0019\u0010%\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u000e8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001cR\u0019\u0010'\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u000e8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u001c\u00a8\u0006)"}, d2={"Lcom/mineinabyss/geary/papermc/tracking/items/inventory/GearyPlayerInventory;", "", "inventory", "Lorg/bukkit/inventory/PlayerInventory;", "converter", "Lcom/mineinabyss/geary/papermc/tracking/items/inventory/InventoryCacheWrapper;", "<init>", "(Lorg/bukkit/inventory/PlayerInventory;Lcom/mineinabyss/geary/papermc/tracking/items/inventory/InventoryCacheWrapper;)V", "getInventory", "()Lorg/bukkit/inventory/PlayerInventory;", "getConverter", "()Lcom/mineinabyss/geary/papermc/tracking/items/inventory/InventoryCacheWrapper;", "get", "Lcom/mineinabyss/geary/datatypes/Entity;", "Lcom/mineinabyss/geary/datatypes/GearyEntity;", "slot", "", "forceRefresh", "", "ignoreCached", "", "equipmentSlot", "Lorg/bukkit/inventory/EquipmentSlot;", "find", "itemStack", "Lorg/bukkit/inventory/ItemStack;", "itemOnCursor", "getItemOnCursor", "()Lcom/mineinabyss/geary/datatypes/Entity;", "itemInMainHand", "getItemInMainHand", "itemInOffhand", "getItemInOffhand", "itemInHelmet", "getItemInHelmet", "itemInChestplate", "getItemInChestplate", "itemInLeggings", "getItemInLeggings", "itemInBoots", "getItemInBoots", "geary-papermc-tracking"})
public final class GearyPlayerInventory {
    @NotNull
    private final PlayerInventory inventory;
    @NotNull
    private final InventoryCacheWrapper converter;

    public GearyPlayerInventory(@NotNull PlayerInventory inventory, @NotNull InventoryCacheWrapper converter) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Intrinsics.checkNotNullParameter((Object)converter, (String)"converter");
        this.inventory = inventory;
        this.converter = converter;
    }

    @NotNull
    public final PlayerInventory getInventory() {
        return this.inventory;
    }

    @NotNull
    public final InventoryCacheWrapper getConverter() {
        return this.converter;
    }

    @Nullable
    public final Entity get(int slot) {
        return this.converter.getOrUpdate((Inventory)this.inventory, slot);
    }

    public final void forceRefresh(boolean ignoreCached) {
        this.converter.updateToMatch((Inventory)this.inventory, ignoreCached);
    }

    public static /* synthetic */ void forceRefresh$default(GearyPlayerInventory gearyPlayerInventory, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        gearyPlayerInventory.forceRefresh(bl);
    }

    @Nullable
    public final Entity get(@NotNull EquipmentSlot equipmentSlot) {
        Intrinsics.checkNotNullParameter((Object)equipmentSlot, (String)"equipmentSlot");
        return switch (WhenMappings.$EnumSwitchMapping$0[equipmentSlot.ordinal()]) {
            case 1 -> this.getItemInMainHand();
            case 2 -> this.getItemInOffhand();
            case 3 -> this.getItemInHelmet();
            case 4 -> this.getItemInChestplate();
            case 5 -> this.getItemInLeggings();
            case 6 -> this.getItemInBoots();
            case 7, 8 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Nullable
    public final Entity find(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        int index = CollectionsKt.indexOf((Iterable)((Iterable)this.inventory), (Object)itemStack);
        if (index == -1) {
            return null;
        }
        return this.get(index);
    }

    @Nullable
    public final Entity getItemOnCursor() {
        return this.get(63);
    }

    @Nullable
    public final Entity getItemInMainHand() {
        return this.get(this.inventory.getHeldItemSlot());
    }

    @Nullable
    public final Entity getItemInOffhand() {
        return this.get(40);
    }

    @Nullable
    public final Entity getItemInHelmet() {
        return this.get(this.inventory.getSize() - 2);
    }

    @Nullable
    public final Entity getItemInChestplate() {
        return this.get(this.inventory.getSize() - 3);
    }

    @Nullable
    public final Entity getItemInLeggings() {
        return this.get(this.inventory.getSize() - 4);
    }

    @Nullable
    public final Entity getItemInBoots() {
        return this.get(this.inventory.getSize() - 5);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EquipmentSlot.values().length];
            try {
                nArray[EquipmentSlot.HAND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EquipmentSlot.OFF_HAND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EquipmentSlot.HEAD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EquipmentSlot.CHEST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EquipmentSlot.LEGS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EquipmentSlot.FEET.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EquipmentSlot.BODY.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EquipmentSlot.SADDLE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

