/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.geary.papermc.tracking.items.cache;

import com.mineinabyss.geary.datatypes.Entity;
import com.mineinabyss.geary.modules.Geary;
import com.mineinabyss.geary.papermc.tracking.items.GearyItemProvider;
import com.mineinabyss.geary.papermc.tracking.items.ItemTrackingModule;
import com.mineinabyss.geary.papermc.tracking.items.cache.ItemInfo;
import com.mineinabyss.geary.papermc.tracking.items.cache.PlayerItemCache;
import com.mineinabyss.geary.papermc.tracking.items.systems.LoginListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0018\u0010\u000e\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u00052\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/mineinabyss/geary/papermc/tracking/items/cache/BukkitItemCache;", "Lcom/mineinabyss/geary/papermc/tracking/items/cache/PlayerItemCache;", "Lorg/bukkit/inventory/ItemStack;", "holder", "Lcom/mineinabyss/geary/datatypes/Entity;", "Lcom/mineinabyss/geary/datatypes/GearyEntity;", "gearyItems", "Lcom/mineinabyss/geary/papermc/tracking/items/ItemTrackingModule;", "<init>", "(Lcom/mineinabyss/geary/datatypes/Entity;Lcom/mineinabyss/geary/papermc/tracking/items/ItemTrackingModule;)V", "readItemInfo", "Lcom/mineinabyss/geary/papermc/tracking/items/cache/ItemInfo;", "item", "convertToItemStack", "deserializeItem", "skipUpdate", "", "slot", "", "newItem", "skipReserialization", "geary-papermc-tracking"})
public final class BukkitItemCache
extends PlayerItemCache<ItemStack> {
    @NotNull
    private final ItemTrackingModule gearyItems;

    public BukkitItemCache(@NotNull Entity holder, @NotNull ItemTrackingModule gearyItems) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)gearyItems, (String)"gearyItems");
        super(holder, 64);
        this.gearyItems = gearyItems;
    }

    @Override
    @NotNull
    public ItemInfo readItemInfo(@NotNull ItemStack item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return LoginListener.Companion.readItemInfo((Geary)this, item);
    }

    @Override
    @NotNull
    public ItemStack convertToItemStack(@NotNull ItemStack item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return item;
    }

    @Override
    @Nullable
    public Entity deserializeItem(@NotNull ItemStack item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Ref.ObjectRef entity = new Ref.ObjectRef();
        item.editPersistentDataContainer(arg_0 -> BukkitItemCache.deserializeItem$lambda$0(entity, this, arg_0));
        return (Entity)entity.element;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean skipUpdate(int slot, @Nullable ItemStack newItem) {
        if (this.getCachedItem(slot) != newItem) return false;
        if (this.get(slot) == null) return true;
        ItemStack itemStack = newItem;
        if (itemStack == null) return true;
        if (itemStack.getAmount() != 0) return true;
        return false;
    }

    @Override
    public boolean skipReserialization(int slot, @Nullable ItemStack newItem) {
        ItemStack itemStack = (ItemStack)this.getCachedItem(slot);
        return itemStack != null ? itemStack.equals((Object)newItem) : false;
    }

    private static final void deserializeItem$lambda$0(Ref.ObjectRef $entity, BukkitItemCache this$0, PersistentDataContainer it) {
        $entity.element = GearyItemProvider.deserializeItemStackToEntity$default(this$0.gearyItems.getItemProvider(), it, null, 2, null);
    }
}

