/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.geary.papermc.spawning.choosing;

import com.mineinabyss.geary.papermc.GearyPaperModuleKt;
import com.mineinabyss.geary.papermc.spawning.MobSpawner;
import com.mineinabyss.geary.papermc.spawning.config.SpawnEntry;
import com.mineinabyss.geary.papermc.spawning.config.SpawnPosition;
import com.mineinabyss.geary.papermc.spawning.config.SpreadSpawnConfig;
import com.mineinabyss.geary.papermc.spawning.readers.SpawnPositionReader;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.Deferred;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0086@\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/mineinabyss/geary/papermc/spawning/choosing/InChunkLocationChooser;", "", "mobSpawner", "Lcom/mineinabyss/geary/papermc/spawning/MobSpawner;", "mainWorld", "Lorg/bukkit/World;", "<init>", "(Lcom/mineinabyss/geary/papermc/spawning/MobSpawner;Lorg/bukkit/World;)V", "chooseSpotInChunk", "Lorg/bukkit/Location;", "chunkLoc", "config", "Lcom/mineinabyss/geary/papermc/spawning/config/SpreadSpawnConfig;", "(Lorg/bukkit/Location;Lcom/mineinabyss/geary/papermc/spawning/config/SpreadSpawnConfig;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getValidBlockOrNull", "chunk", "Lorg/bukkit/Chunk;", "getRandomChunkCoord", "geary-papermc-spawning"})
@SourceDebugExtension(value={"SMAP\nInChunkLocationChooser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InChunkLocationChooser.kt\ncom/mineinabyss/geary/papermc/spawning/choosing/InChunkLocationChooser\n+ 2 ChunkTicketHelpers.kt\ncom/mineinabyss/geary/papermc/spawning/helpers/ChunkTicketHelpersKt\n*L\n1#1,53:1\n23#2,12:54\n*S KotlinDebug\n*F\n+ 1 InChunkLocationChooser.kt\ncom/mineinabyss/geary/papermc/spawning/choosing/InChunkLocationChooser\n*L\n21#1:54,12\n*E\n"})
public final class InChunkLocationChooser {
    @NotNull
    private final MobSpawner mobSpawner;
    @NotNull
    private final World mainWorld;

    public InChunkLocationChooser(@NotNull MobSpawner mobSpawner, @NotNull World mainWorld) {
        Intrinsics.checkNotNullParameter((Object)mobSpawner, (String)"mobSpawner");
        Intrinsics.checkNotNullParameter((Object)mainWorld, (String)"mainWorld");
        this.mobSpawner = mobSpawner;
        this.mainWorld = mainWorld;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Object chooseSpotInChunk(@NotNull Location chunkLoc, @NotNull SpreadSpawnConfig config2, @NotNull Continuation<? super Location> $completion) {
        Chunk chunk = chunkLoc.getChunk();
        Intrinsics.checkNotNullExpressionValue((Object)chunk, (String)"getChunk(...)");
        Chunk chunk2 = chunk;
        if (!(chunkLoc.isWorldLoaded() && chunkLoc.isChunkLoaded() && Intrinsics.areEqual((Object)chunkLoc.getWorld(), (Object)this.mainWorld))) {
            return null;
        }
        Chunk $this$launchWithTicket$iv = chunk2;
        boolean $i$f$launchWithTicket = false;
        CompletableDeferred deferred$iv = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        try {
            Location location;
            CompletableDeferred completableDeferred;
            block7: {
                $this$launchWithTicket$iv.addPluginChunkTicket((Plugin)GearyPaperModuleKt.getGearyPaper().getPlugin());
                completableDeferred = deferred$iv;
                Continuation<? super Location> continuation = $completion;
                Chunk it = $this$launchWithTicket$iv;
                boolean bl = false;
                int n = config2.getSpawnAttempts();
                int n2 = 0;
                while (n2 < n) {
                    int it2 = n2++;
                    boolean bl2 = false;
                    Location candidate = this.getValidBlockOrNull(chunk2, config2);
                    if (candidate == null) continue;
                    location = candidate;
                    break block7;
                }
                location = null;
            }
            completableDeferred.complete(location);
        }
        catch (Exception e$iv) {
            deferred$iv.completeExceptionally((Throwable)e$iv);
        }
        finally {
            $this$launchWithTicket$iv.removePluginChunkTicket((Plugin)GearyPaperModuleKt.getGearyPaper().getPlugin());
        }
        Deferred pos = (Deferred)deferred$iv;
        return pos.await($completion);
    }

    private final Location getValidBlockOrNull(Chunk chunk, SpreadSpawnConfig config2) {
        SpawnEntry entry;
        SpawnPositionReader spawnPositionReader = new SpawnPositionReader();
        Location testloc = this.getRandomChunkCoord(chunk, config2);
        SpawnPosition type = spawnPositionReader.spawnPositionFor(testloc);
        if (type != (entry = config2.getEntry()).getPosition() || !this.mobSpawner.checkSpawnConditions(entry, testloc)) {
            return null;
        }
        return new Location(chunk.getWorld(), testloc.getX(), testloc.getY(), testloc.getZ());
    }

    private final Location getRandomChunkCoord(Chunk chunk, SpreadSpawnConfig config2) {
        IntRange yRange = new IntRange(config2.getSectionMinY(), config2.getSectionMaxY());
        int x = chunk.getX() * 16 + RangesKt.random((IntRange)new IntRange(0, 15), (Random)((Random)Random.Default));
        int z = chunk.getZ() * 16 + RangesKt.random((IntRange)new IntRange(0, 15), (Random)((Random)Random.Default));
        int y = RangesKt.random((IntRange)yRange, (Random)((Random)Random.Default));
        return new Location(this.mainWorld, (double)x, (double)y, (double)z);
    }
}

