/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.geary.papermc.spawning.spawn_types.mythic;

import com.mineinabyss.geary.papermc.spawning.components.SpawnCategory;
import com.mineinabyss.geary.papermc.spawning.spawn_types.SpawnType;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import org.bukkit.Location;
import org.bukkit.craftbukkit.entity.CraftEntityType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0014\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/mineinabyss/geary/papermc/spawning/spawn_types/mythic/MythicSpawnType;", "Lcom/mineinabyss/geary/papermc/spawning/spawn_types/SpawnType;", "key", "", "mobName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getKey", "()Ljava/lang/String;", "mythicMob", "Lio/lumine/mythic/api/mobs/MythicMob;", "getMythicMob", "()Lio/lumine/mythic/api/mobs/MythicMob;", "spawnAt", "Lorg/bukkit/entity/Entity;", "Lcom/mineinabyss/idofront/typealiases/BukkitEntity;", "location", "Lorg/bukkit/Location;", "category", "Lcom/mineinabyss/geary/papermc/spawning/components/SpawnCategory;", "getCategory-gGviQF0", "Ljava/lang/String;", "geary-papermc-spawning"})
public final class MythicSpawnType
implements SpawnType {
    @NotNull
    private final String key;
    @NotNull
    private final MythicMob mythicMob;
    @NotNull
    private final String category;

    public MythicSpawnType(@NotNull String key, @NotNull String mobName) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)mobName, (String)"mobName");
        this.key = key;
        Optional optional = MythicBukkit.inst().getMobManager().getMythicMob(mobName);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getMythicMob(...)");
        MythicMob mythicMob = (MythicMob)OptionalsKt.getOrNull((Optional)optional);
        if (mythicMob == null) {
            throw new IllegalStateException(("Mythic mob " + mobName + " not found").toString());
        }
        this.mythicMob = mythicMob;
        String string = this.mythicMob.getConfig().getString("SpawnCategory");
        if (string == null) {
            EntityType entityType = CraftEntityType.stringToBukkit((String)this.mythicMob.getEntityType().name());
            Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"stringToBukkit(...)");
            string = SpawnCategory.Companion.of(entityType);
        }
        this.category = SpawnCategory.constructor-impl(string);
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    @NotNull
    public final MythicMob getMythicMob() {
        return this.mythicMob;
    }

    @Override
    @NotNull
    public Entity spawnAt(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        ActiveMob spawned = this.mythicMob.spawn(BukkitAdapter.adapt((Location)location), 1.0);
        Entity entity = spawned.getEntity().getBukkitEntity();
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getBukkitEntity(...)");
        return entity;
    }

    @Override
    @NotNull
    public String getCategory-gGviQF0() {
        return this.category;
    }
}

