/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.geary.papermc.spawning.choosing.mobcaps;

import com.mineinabyss.geary.papermc.spawning.components.SpawnCategory;
import com.mineinabyss.geary.papermc.spawning.config.SpawnEntry;
import com.mineinabyss.geary.papermc.spawning.spawn_types.GearyReadSpawnCategoryEvent;
import com.mineinabyss.idofront.events.EventCallingKt;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B+\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\u0010\u001a\u00020\u0011J0\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0017J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00132\u0006\u0010\u0010\u001a\u00020\u0011R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/mineinabyss/geary/papermc/spawning/choosing/mobcaps/MobCaps;", "", "caps", "", "Lcom/mineinabyss/geary/papermc/spawning/components/SpawnCategory;", "", "defaultCapLimit", "searchRadius", "<init>", "(Ljava/util/Map;II)V", "getCaps", "()Ljava/util/Map;", "getDefaultCapLimit", "()I", "getSearchRadius", "calculateCategoriesNear", "location", "Lorg/bukkit/Location;", "filterAllowedAt", "", "Lcom/mineinabyss/geary/papermc/spawning/config/SpawnEntry;", "spawns", "predicate", "Ljava/util/function/Predicate;", "getAllowedCategoriesAt", "Companion", "geary-papermc-spawning"})
@SourceDebugExtension(value={"SMAP\nMobCaps.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MobCaps.kt\ncom/mineinabyss/geary/papermc/spawning/choosing/mobcaps/MobCaps\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,69:1\n1573#2:70\n777#2:71\n873#2,2:72\n540#3:74\n525#3,6:75\n*S KotlinDebug\n*F\n+ 1 MobCaps.kt\ncom/mineinabyss/geary/papermc/spawning/choosing/mobcaps/MobCaps\n*L\n40#1:70\n49#1:71\n49#1:72,2\n60#1:74\n60#1:75,6\n*E\n"})
public final class MobCaps {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<SpawnCategory, Integer> caps;
    private final int defaultCapLimit;
    private final int searchRadius;
    private static final ObjectOpenHashSet<EntityType> IGNORED_ENTITY_TYPES;

    public MobCaps(@NotNull Map<SpawnCategory, Integer> caps, int defaultCapLimit, int searchRadius) {
        Intrinsics.checkNotNullParameter(caps, (String)"caps");
        this.caps = caps;
        this.defaultCapLimit = defaultCapLimit;
        this.searchRadius = searchRadius;
    }

    @NotNull
    public final Map<SpawnCategory, Integer> getCaps() {
        return this.caps;
    }

    public final int getDefaultCapLimit() {
        return this.defaultCapLimit;
    }

    public final int getSearchRadius() {
        return this.searchRadius;
    }

    @NotNull
    public final Map<SpawnCategory, Integer> calculateCategoriesNear(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        BoundingBox boundingBox = BoundingBox.of((Location)location, (double)this.searchRadius, (double)this.searchRadius, (double)this.searchRadius);
        Intrinsics.checkNotNullExpressionValue((Object)boundingBox, (String)"of(...)");
        BoundingBox boundingBox2 = boundingBox;
        Collection collection = location.getWorld().getNearbyEntities(boundingBox2, arg_0 -> MobCaps.calculateCategoriesNear$lambda$1(MobCaps::calculateCategoriesNear$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getNearbyEntities(...)");
        Collection entities = collection;
        Iterable $this$groupingBy$iv = entities;
        boolean $i$f$groupingBy = false;
        return GroupingKt.eachCount((Grouping)((Grouping)new Grouping<Entity, SpawnCategory>($this$groupingBy$iv){
            final /* synthetic */ Iterable $this_groupingBy;
            {
                this.$this_groupingBy = $receiver;
            }

            public Iterator<Entity> sourceIterator() {
                return this.$this_groupingBy.iterator();
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public Object keyOf(Object element) {
                GearyReadSpawnCategoryEvent gearyReadSpawnCategoryEvent;
                Entity it = (Entity)element;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                GearyReadSpawnCategoryEvent it2 = gearyReadSpawnCategoryEvent = new GearyReadSpawnCategoryEvent(it);
                boolean bl2 = false;
                EventCallingKt.call((Event)it2);
                String string = gearyReadSpawnCategoryEvent.getCategory-1DcTNGk();
                if (string == null) {
                    string = SpawnCategory.Companion.of-0SrQdFg(it);
                }
                return SpawnCategory.box-impl(string);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SpawnEntry> filterAllowedAt(@NotNull Location location, @NotNull List<SpawnEntry> spawns, @NotNull Predicate<SpawnEntry> predicate) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter(spawns, (String)"spawns");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Map<SpawnCategory, Integer> mobCaps = this.calculateCategoriesNear(location);
        int defaultLimit = this.defaultCapLimit;
        Iterable $this$filter$iv = spawns;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int limit;
            SpawnEntry spawn2 = (SpawnEntry)element$iv$iv;
            boolean bl = false;
            String category = spawn2.getType().getCategory-gGviQF0();
            int currentCount = ((Number)mobCaps.getOrDefault(SpawnCategory.box-impl(category), 0)).intValue();
            if (!(currentCount < (limit = ((Number)this.caps.getOrDefault(SpawnCategory.box-impl(category), defaultLimit)).intValue()) && predicate.test(spawn2))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SpawnCategory> getAllowedCategoriesAt(@NotNull Location location) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Map<SpawnCategory, Integer> mobCaps = this.calculateCategoriesNear(location);
        Map<SpawnCategory, Integer> $this$filter$iv = this.caps;
        boolean $i$f$filter = false;
        Map<SpawnCategory, Integer> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            String category = ((SpawnCategory)entry.getKey()).unbox-impl();
            int cap = ((Number)entry.getValue()).intValue();
            if (!(((Number)mobCaps.getOrDefault(SpawnCategory.box-impl(category), 0)).intValue() < cap)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return CollectionsKt.toList((Iterable)destination$iv$iv.keySet());
    }

    private static final boolean calculateCategoriesNear$lambda$0(Entity it) {
        return !IGNORED_ENTITY_TYPES.contains((Object)it.getType());
    }

    private static final boolean calculateCategoriesNear$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Object[] objectArray = new EntityType[]{EntityType.ITEM, EntityType.ITEM_FRAME, EntityType.GLOW_ITEM_FRAME, EntityType.ACACIA_BOAT, EntityType.BIRCH_BOAT, EntityType.CHERRY_BOAT, EntityType.DARK_OAK_BOAT, EntityType.JUNGLE_BOAT, EntityType.MANGROVE_BOAT, EntityType.OAK_BOAT, EntityType.PALE_OAK_BOAT, EntityType.SPRUCE_BOAT, EntityType.ACACIA_CHEST_BOAT, EntityType.BIRCH_CHEST_BOAT, EntityType.CHERRY_CHEST_BOAT, EntityType.DARK_OAK_CHEST_BOAT, EntityType.JUNGLE_CHEST_BOAT, EntityType.MANGROVE_CHEST_BOAT, EntityType.OAK_CHEST_BOAT, EntityType.PALE_OAK_CHEST_BOAT, EntityType.SPRUCE_CHEST_BOAT, EntityType.MINECART, EntityType.HOPPER_MINECART, EntityType.COMMAND_BLOCK_MINECART, EntityType.CHEST_MINECART, EntityType.FURNACE_MINECART, EntityType.SPAWNER_MINECART, EntityType.TNT_MINECART, EntityType.EXPERIENCE_ORB, EntityType.FALLING_BLOCK, EntityType.ARROW, EntityType.SPECTRAL_ARROW, EntityType.AREA_EFFECT_CLOUD, EntityType.INTERACTION, EntityType.BREEZE_WIND_CHARGE, EntityType.DRAGON_FIREBALL, EntityType.EGG, EntityType.ENDER_PEARL, EntityType.EYE_OF_ENDER, EntityType.EVOKER_FANGS, EntityType.EXPERIENCE_BOTTLE, EntityType.FIREBALL, EntityType.FIREWORK_ROCKET, EntityType.FISHING_BOBBER, EntityType.LEASH_KNOT, EntityType.LIGHTNING_BOLT, EntityType.LLAMA_SPIT, EntityType.OMINOUS_ITEM_SPAWNER, EntityType.TRIDENT, EntityType.SPLASH_POTION, EntityType.LINGERING_POTION, EntityType.SHULKER_BULLET, EntityType.SMALL_FIREBALL, EntityType.SNOWBALL, EntityType.WIND_CHARGE};
        IGNORED_ENTITY_TYPES = ObjectOpenHashSet.of((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R2\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/mineinabyss/geary/papermc/spawning/choosing/mobcaps/MobCaps$Companion;", "", "<init>", "()V", "IGNORED_ENTITY_TYPES", "Lit/unimi/dsi/fastutil/objects/ObjectOpenHashSet;", "Lorg/bukkit/entity/EntityType;", "kotlin.jvm.PlatformType", "geary-papermc-spawning"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

