/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.geary.papermc.spawning;

import com.mineinabyss.geary.actions.ActionGroupContext;
import com.mineinabyss.geary.actions.actions.EnsureAction;
import com.mineinabyss.geary.papermc.ActionExtensionsKt;
import com.mineinabyss.geary.papermc.spawning.choosing.LocationSpread;
import com.mineinabyss.geary.papermc.spawning.choosing.SpawnChooser;
import com.mineinabyss.geary.papermc.spawning.config.SpawnEntry;
import com.mineinabyss.geary.papermc.spawning.config.SpawnPosition;
import com.mineinabyss.idofront.util.RangesKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/mineinabyss/geary/papermc/spawning/MobSpawner;", "", "spawnChooser", "Lcom/mineinabyss/geary/papermc/spawning/choosing/SpawnChooser;", "spreadRepo", "Lcom/mineinabyss/geary/papermc/spawning/choosing/LocationSpread;", "<init>", "(Lcom/mineinabyss/geary/papermc/spawning/choosing/SpawnChooser;Lcom/mineinabyss/geary/papermc/spawning/choosing/LocationSpread;)V", "getSpawnChooser", "()Lcom/mineinabyss/geary/papermc/spawning/choosing/SpawnChooser;", "getSpreadRepo", "()Lcom/mineinabyss/geary/papermc/spawning/choosing/LocationSpread;", "checkSpawnConditions", "", "spawn", "Lcom/mineinabyss/geary/papermc/spawning/config/SpawnEntry;", "location", "Lorg/bukkit/Location;", "attemptSpawnAt", "position", "Lcom/mineinabyss/geary/papermc/spawning/config/SpawnPosition;", "geary-papermc-spawning"})
@SourceDebugExtension(value={"SMAP\nMobSpawner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MobSpawner.kt\ncom/mineinabyss/geary/papermc/spawning/MobSpawner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1740#2,3:62\n1#3:65\n*S KotlinDebug\n*F\n+ 1 MobSpawner.kt\ncom/mineinabyss/geary/papermc/spawning/MobSpawner\n*L\n19#1:62,3\n*E\n"})
public final class MobSpawner {
    @NotNull
    private final SpawnChooser spawnChooser;
    @NotNull
    private final LocationSpread spreadRepo;

    public MobSpawner(@NotNull SpawnChooser spawnChooser, @NotNull LocationSpread spreadRepo) {
        Intrinsics.checkNotNullParameter((Object)spawnChooser, (String)"spawnChooser");
        Intrinsics.checkNotNullParameter((Object)spreadRepo, (String)"spreadRepo");
        this.spawnChooser = spawnChooser;
        this.spreadRepo = spreadRepo;
    }

    @NotNull
    public final SpawnChooser getSpawnChooser() {
        return this.spawnChooser;
    }

    @NotNull
    public final LocationSpread getSpreadRepo() {
        return this.spreadRepo;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean checkSpawnConditions(@NotNull SpawnEntry spawn, @NotNull Location location) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)spawn, (String)"spawn");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Iterable $this$all$iv = spawn.getConditions();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    void $this$checkSpawnConditions_u24lambda_u241_u24lambda_u240;
                    ActionGroupContext actionGroupContext;
                    EnsureAction it = (EnsureAction)element$iv;
                    boolean bl2 = false;
                    ActionGroupContext actionGroupContext2 = actionGroupContext = new ActionGroupContext();
                    EnsureAction ensureAction = it;
                    boolean bl3 = false;
                    ActionExtensionsKt.setLocation((ActionGroupContext)$this$checkSpawnConditions_u24lambda_u241_u24lambda_u240, (Location)location.clone());
                    $this$checkSpawnConditions_u24lambda_u241_u24lambda_u240.getEnvironment().put("spawnTypes", CollectionsKt.listOf((Object)spawn.getType().getKey()));
                    if (ensureAction.conditionsMet(actionGroupContext)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final boolean attemptSpawnAt(@NotNull Location location, @NotNull SpawnPosition position) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        SpawnEntry spawnEntry = this.spawnChooser.chooseAllowedSpawnNear(location, position);
        if (spawnEntry == null) {
            return false;
        }
        SpawnEntry spawn = spawnEntry;
        if (!(spawn.getChance() == 1.0) && Random.Default.nextDouble() > spawn.getChance()) {
            return false;
        }
        Object object2 = this;
        try {
            MobSpawner $this$attemptSpawnAt_u24lambda_u242 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)(!$this$attemptSpawnAt_u24lambda_u242.checkSpawnConditions(spawn, location) ? 1 : 0));
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        object = true;
        if (((Boolean)(Result.isFailure-impl((Object)object2) ? object : object2)).booleanValue()) {
            return false;
        }
        int n = RangesKt.randomOrMin((IntRange)spawn.getAmount());
        for (int i = 0; i < n; ++i) {
            Location nonSuffocatingLoc;
            int it = i;
            boolean bl = false;
            double spread = RangesKt.randomOrMin((IntRange)spawn.getSpread());
            double ySpread = RangesKt.randomOrMin((IntRange)spawn.getYSpread());
            Location spawnLoc = spread == 0.0 && ySpread == 0.0 ? location : this.spreadRepo.getNearbySpawnLocation(position, location, spread, ySpread);
            Entity spawned = spawn.getType().spawnAt(spawnLoc);
            BoundingBox boundingBox = spawned.getBoundingBox();
            Intrinsics.checkNotNullExpressionValue((Object)boundingBox, (String)"getBoundingBox(...)");
            if (this.spreadRepo.ensureSuitableLocationOrNull(spawnLoc, boundingBox, 10) == null) {
                MobSpawner $this$attemptSpawnAt_u24lambda_u244_u24lambda_u243 = this;
                boolean bl2 = false;
                spawned.remove();
                continue;
            }
            spawned.teleportAsync(nonSuffocatingLoc);
        }
        return true;
    }
}

