/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.geary.papermc.spawning.choosing;

import com.mineinabyss.geary.papermc.spawning.config.SpawnConfig;
import com.mineinabyss.idofront.location.LocationUtilsKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\tJ\u0016\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/mineinabyss/geary/papermc/spawning/choosing/SpawnLocationChooser;", "", "config", "Lcom/mineinabyss/geary/papermc/spawning/config/SpawnConfig$Range;", "<init>", "(Lcom/mineinabyss/geary/papermc/spawning/config/SpawnConfig$Range;)V", "getConfig", "()Lcom/mineinabyss/geary/papermc/spawning/config/SpawnConfig$Range;", "chooseSpawnLocationNear", "Lorg/bukkit/Location;", "onlinePlayers", "", "Lorg/bukkit/entity/Player;", "location", "tryGetHighestBlockWithinYRange", "range", "", "randomSign", "geary-papermc-spawning"})
@SourceDebugExtension(value={"SMAP\nSpawnLocationChooser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpawnLocationChooser.kt\ncom/mineinabyss/geary/papermc/spawning/choosing/SpawnLocationChooser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1755#2,3:52\n1863#2,2:56\n1#3:55\n*S KotlinDebug\n*F\n+ 1 SpawnLocationChooser.kt\ncom/mineinabyss/geary/papermc/spawning/choosing/SpawnLocationChooser\n*L\n30#1:52,3\n42#1:56,2\n*E\n"})
public final class SpawnLocationChooser {
    @NotNull
    private final SpawnConfig.Range config;

    public SpawnLocationChooser(@NotNull SpawnConfig.Range config2) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        this.config = config2;
    }

    @NotNull
    public final SpawnConfig.Range getConfig() {
        return this.config;
    }

    @Nullable
    public final Location chooseSpawnLocationNear(@NotNull List<? extends Player> onlinePlayers, @NotNull Location location) {
        boolean bl;
        Location spawnLocation;
        block5: {
            Intrinsics.checkNotNullParameter(onlinePlayers, (String)"onlinePlayers");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            IntRange horizontalRange = new IntRange(this.config.getMinDistance(), this.config.getMaxDistance());
            IntRange verticalRange = new IntRange(this.config.getMinDistance(), this.config.getMaxVerticalDistance());
            Location location2 = location.clone().add((double)this.randomSign() * (double)com.mineinabyss.idofront.util.RangesKt.randomOrMin((IntRange)horizontalRange), (double)this.randomSign() * (double)com.mineinabyss.idofront.util.RangesKt.randomOrMin((IntRange)verticalRange), (double)this.randomSign() * (double)com.mineinabyss.idofront.util.RangesKt.randomOrMin((IntRange)horizontalRange));
            Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"add(...)");
            spawnLocation = location2;
            if (Random.Default.nextDouble() < 0.2) {
                spawnLocation.setY(this.tryGetHighestBlockWithinYRange(spawnLocation, this.config.getMaxVerticalDistance()).getY());
            }
            Iterable $this$any$iv = onlinePlayers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Player it = (Player)element$iv;
                    boolean bl2 = false;
                    if (!(it.getLocation().distanceSquared(spawnLocation) < (double)(this.config.getMinDistance() * this.config.getMinDistance()))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        return spawnLocation;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Location tryGetHighestBlockWithinYRange(@NotNull Location location, int range) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Location location2 = location.clone();
        Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"clone(...)");
        Location newLoc = location2;
        double highestY = (double)newLoc.getWorld().getHighestBlockAt(newLoc).getY() + 1.0;
        if (Math.abs(highestY - newLoc.getY()) <= (double)range) {
            Location location3;
            Location $this$tryGetHighestBlockWithinYRange_u24lambda_u241 = location3 = newLoc;
            boolean bl = false;
            $this$tryGetHighestBlockWithinYRange_u24lambda_u241.setY(highestY);
            return location3;
        }
        if (!newLoc.getBlock().isPassable()) {
            return newLoc;
        }
        Iterable iterable = (Iterable)RangesKt.downTo((int)((int)newLoc.getY()), (int)((int)newLoc.getY() - range));
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            newLoc.setY((double)it);
            if (newLoc.getBlock().isPassable()) continue;
            return LocationUtilsKt.up((Location)newLoc, (Number)1);
        }
        return location;
    }

    private final int randomSign() {
        return Random.Default.nextBoolean() ? 1 : -1;
    }
}

