/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.geary.papermc.spawning.choosing;

import com.mineinabyss.geary.papermc.spawning.config.SpawnPosition;
import com.mineinabyss.geary.papermc.spawning.readers.SpawnPositionReader;
import java.util.Collection;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005J&\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/mineinabyss/geary/papermc/spawning/choosing/LocationSpread;", "", "spawnPositionReader", "Lcom/mineinabyss/geary/papermc/spawning/readers/SpawnPositionReader;", "triesForNearbyLoc", "", "<init>", "(Lcom/mineinabyss/geary/papermc/spawning/readers/SpawnPositionReader;I)V", "getSpawnPositionReader", "()Lcom/mineinabyss/geary/papermc/spawning/readers/SpawnPositionReader;", "getTriesForNearbyLoc", "()I", "random", "Ljava/util/Random;", "getRandom", "()Ljava/util/Random;", "ensureSuitableLocationOrNull", "Lorg/bukkit/Location;", "chosenLoc", "bb", "Lorg/bukkit/util/BoundingBox;", "extraAttemptsUp", "getNearbySpawnLocation", "position", "Lcom/mineinabyss/geary/papermc/spawning/config/SpawnPosition;", "loc", "horizontalRange", "", "verticalRange", "geary-papermc-spawning"})
@SourceDebugExtension(value={"SMAP\nLocationSpread.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocationSpread.kt\ncom/mineinabyss/geary/papermc/spawning/choosing/LocationSpread\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1755#2,3:71\n1#3:74\n*S KotlinDebug\n*F\n+ 1 LocationSpread.kt\ncom/mineinabyss/geary/papermc/spawning/choosing/LocationSpread\n*L\n40#1:71,3\n*E\n"})
public final class LocationSpread {
    @NotNull
    private final SpawnPositionReader spawnPositionReader;
    private final int triesForNearbyLoc;
    @NotNull
    private final Random random;

    public LocationSpread(@NotNull SpawnPositionReader spawnPositionReader, int triesForNearbyLoc) {
        Intrinsics.checkNotNullParameter((Object)spawnPositionReader, (String)"spawnPositionReader");
        this.spawnPositionReader = spawnPositionReader;
        this.triesForNearbyLoc = triesForNearbyLoc;
        this.random = new Random();
    }

    @NotNull
    public final SpawnPositionReader getSpawnPositionReader() {
        return this.spawnPositionReader;
    }

    public final int getTriesForNearbyLoc() {
        return this.triesForNearbyLoc;
    }

    @NotNull
    public final Random getRandom() {
        return this.random;
    }

    @Nullable
    public final Location ensureSuitableLocationOrNull(@NotNull Location chosenLoc, @NotNull BoundingBox bb, int extraAttemptsUp) {
        BoundingBox boundingBox;
        Intrinsics.checkNotNullParameter((Object)chosenLoc, (String)"chosenLoc");
        Intrinsics.checkNotNullParameter((Object)bb, (String)"bb");
        BoundingBox boundingBox2 = bb.clone();
        Intrinsics.checkNotNullExpressionValue((Object)boundingBox2, (String)"clone(...)");
        BoundingBox bb2 = boundingBox2;
        BoundingBox $this$ensureSuitableLocationOrNull_u24lambda_u240 = boundingBox = bb2.clone();
        boolean bl = false;
        $this$ensureSuitableLocationOrNull_u24lambda_u240.expand(-0.1, -0.1, -0.1, -0.1, -0.1, -0.1);
        BoundingBox boundingBox3 = boundingBox;
        Intrinsics.checkNotNullExpressionValue((Object)boundingBox3, (String)"apply(...)");
        BoundingBox bbShrunk = boundingBox3;
        int n = extraAttemptsUp + 1;
        for (int i = 0; i < n; ++i) {
            block12: {
                int n2;
                int offsetY = i;
                boolean bl2 = false;
                int x = (int)Math.floor(bb2.getMinX());
                if (x <= (n2 = (int)Math.ceil(bb2.getMaxX()))) {
                    while (true) {
                        int n3;
                        int y;
                        if ((y = (int)Math.floor(bb2.getMinY())) <= (n3 = (int)Math.ceil(bb2.getMaxY()))) {
                            while (true) {
                                int n4;
                                int z;
                                if ((z = (int)Math.floor(bb2.getMinZ())) <= (n4 = (int)Math.ceil(bb2.getMaxZ()))) {
                                    while (true) {
                                        boolean bl3;
                                        block11: {
                                            Collection collection = chosenLoc.getWorld().getBlockAt(x, y, z).getCollisionShape().getBoundingBoxes();
                                            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getBoundingBoxes(...)");
                                            Iterable $this$any$iv = collection;
                                            boolean $i$f$any = false;
                                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                                bl3 = false;
                                            } else {
                                                for (Object element$iv : $this$any$iv) {
                                                    BoundingBox shape = (BoundingBox)element$iv;
                                                    boolean bl4 = false;
                                                    shape.shift((double)x, (double)y, (double)z);
                                                    if (!shape.overlaps(bbShrunk)) continue;
                                                    bl3 = true;
                                                    break block11;
                                                }
                                                bl3 = false;
                                            }
                                        }
                                        if (!bl3) {
                                            if (z == n4) break;
                                            ++z;
                                            continue;
                                        }
                                        break block12;
                                        break;
                                    }
                                }
                                if (y == n3) break;
                                ++y;
                            }
                        }
                        if (x == n2) break;
                        ++x;
                    }
                }
                return chosenLoc.clone().add(0.0, (double)offsetY, 0.0);
            }
            bb2.shift(0.0, 1.0, 0.0);
            bbShrunk.shift(0.0, 1.0, 0.0);
        }
        return null;
    }

    @NotNull
    public final Location getNearbySpawnLocation(@NotNull SpawnPosition position, @NotNull Location loc, double horizontalRange, double verticalRange) {
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        int n = this.triesForNearbyLoc;
        int n2 = 0;
        while (n2 < n) {
            Location offsetLoc;
            Location location;
            int it = n2++;
            boolean bl = false;
            int dx = (int)this.random.nextGaussian(0.0, horizontalRange);
            int dz = (int)this.random.nextGaussian(0.0, horizontalRange);
            double dy = verticalRange * (double)((int)this.random.nextDouble(0.0, 1.0));
            Location $this$getNearbySpawnLocation_u24lambda_u244_u24lambda_u243 = location = loc.clone();
            boolean bl2 = false;
            $this$getNearbySpawnLocation_u24lambda_u244_u24lambda_u243.add((double)dx, dy, (double)dz);
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"apply(...)");
            if (this.spawnPositionReader.spawnPositionFor(offsetLoc) != position) continue;
            return offsetLoc;
        }
        return loc;
    }
}

