/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.geary.papermc.features.entities.prevent;

import com.mineinabyss.geary.datatypes.Entity;
import com.mineinabyss.geary.helpers.EngineHelpersKt;
import com.mineinabyss.geary.modules.Geary;
import com.mineinabyss.geary.papermc.WorldManagerKt;
import com.mineinabyss.geary.papermc.features.entities.prevent.PreventEnchanting;
import com.mineinabyss.geary.papermc.features.entities.prevent.PreventType;
import com.mineinabyss.geary.papermc.tracking.items.GearyItemContext;
import io.papermc.paper.datacomponent.DataComponentTypes;
import java.io.Closeable;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import org.bukkit.World;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.inventory.PrepareGrindstoneEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0007J\f\u0010\u0007\u001a\u00020\u0005*\u00020\bH\u0007J\f\u0010\t\u001a\u00020\u0005*\u00020\nH\u0007J\f\u0010\u000b\u001a\u00020\u0005*\u00020\fH\u0007J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u00a8\u0006\u0015"}, d2={"Lcom/mineinabyss/geary/papermc/features/entities/prevent/PreventEnchantingListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "disableEnchantPreview", "", "Lorg/bukkit/event/enchantment/PrepareItemEnchantEvent;", "disableEnchanting", "Lorg/bukkit/event/enchantment/EnchantItemEvent;", "disableAnvilEnchant", "Lorg/bukkit/event/inventory/PrepareAnvilEvent;", "disableGrindstone", "Lorg/bukkit/event/inventory/PrepareGrindstoneEvent;", "shouldPrevent", "", "world", "Lorg/bukkit/World;", "item", "Lorg/bukkit/inventory/ItemStack;", "preventType", "Lcom/mineinabyss/geary/papermc/features/entities/prevent/PreventType;", "geary-papermc-features"})
@SourceDebugExtension(value={"SMAP\nPreventEnchanting.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreventEnchanting.kt\ncom/mineinabyss/geary/papermc/features/entities/prevent/PreventEnchantingListener\n+ 2 GearyItemContext.kt\ncom/mineinabyss/geary/papermc/tracking/items/GearyItemContextKt\n+ 3 Entity.kt\ncom/mineinabyss/geary/datatypes/Entity\n*L\n1#1,70:1\n38#2:71\n173#3,5:72\n*S KotlinDebug\n*F\n+ 1 PreventEnchanting.kt\ncom/mineinabyss/geary/papermc/features/entities/prevent/PreventEnchantingListener\n*L\n61#1:71\n62#1:72,5\n*E\n"})
public final class PreventEnchantingListener
implements Listener {
    @EventHandler
    public final void disableEnchantPreview(@NotNull PrepareItemEnchantEvent $this$disableEnchantPreview) {
        Intrinsics.checkNotNullParameter((Object)$this$disableEnchantPreview, (String)"<this>");
        World world = $this$disableEnchantPreview.getEnchanter().getWorld();
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorld(...)");
        if (this.shouldPrevent(world, $this$disableEnchantPreview.getItem(), PreventType.ENCHANTING_TABLE)) {
            $this$disableEnchantPreview.setCancelled(true);
        }
    }

    @EventHandler
    public final void disableEnchanting(@NotNull EnchantItemEvent $this$disableEnchanting) {
        Intrinsics.checkNotNullParameter((Object)$this$disableEnchanting, (String)"<this>");
        World world = $this$disableEnchanting.getEnchanter().getWorld();
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorld(...)");
        if (this.shouldPrevent(world, $this$disableEnchanting.getItem(), PreventType.ENCHANTING_TABLE)) {
            $this$disableEnchanting.setCancelled(true);
        }
    }

    @EventHandler
    public final void disableAnvilEnchant(@NotNull PrepareAnvilEvent $this$disableAnvilEnchant) {
        Intrinsics.checkNotNullParameter((Object)$this$disableAnvilEnchant, (String)"<this>");
        List list = $this$disableAnvilEnchant.getViewers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getViewers(...)");
        HumanEntity humanEntity = (HumanEntity)CollectionsKt.firstOrNull((List)list);
        if (humanEntity == null || (humanEntity = humanEntity.getWorld()) == null) {
            return;
        }
        HumanEntity world = humanEntity;
        if (this.shouldPrevent((World)world, $this$disableAnvilEnchant.getResult(), PreventType.ANVIL)) {
            $this$disableAnvilEnchant.setResult(null);
        }
    }

    @EventHandler
    public final void disableGrindstone(@NotNull PrepareGrindstoneEvent $this$disableGrindstone) {
        Intrinsics.checkNotNullParameter((Object)$this$disableGrindstone, (String)"<this>");
        List list = $this$disableGrindstone.getViewers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getViewers(...)");
        HumanEntity humanEntity = (HumanEntity)CollectionsKt.firstOrNull((List)list);
        if (humanEntity == null || (humanEntity = humanEntity.getWorld()) == null) {
            return;
        }
        HumanEntity world = humanEntity;
        if (this.shouldPrevent((World)world, $this$disableGrindstone.getResult(), PreventType.GRINDSTONE)) {
            $this$disableGrindstone.setResult(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean shouldPrevent(@NotNull World world, @Nullable ItemStack item, @NotNull PreventType preventType) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)((Object)preventType), (String)"preventType");
        if (item == null) {
            return false;
        }
        if (preventType == PreventType.GRINDSTONE && item.getData(DataComponentTypes.ENCHANTABLE) == null) {
            return true;
        }
        Geary $this$shouldPrevent_u24lambda_u241 = WorldManagerKt.toGeary((World)world);
        boolean bl = false;
        Geary $this$itemEntityContext$iv = $this$shouldPrevent_u24lambda_u241;
        boolean $i$f$itemEntityContext = false;
        Closeable closeable = (Closeable)new GearyItemContext($this$itemEntityContext$iv);
        Throwable throwable = null;
        try {
            boolean bl2;
            GearyItemContext $this$shouldPrevent_u24lambda_u241_u24lambda_u240 = (GearyItemContext)closeable;
            boolean bl3 = false;
            Entity entity = $this$shouldPrevent_u24lambda_u241_u24lambda_u240.toGearyOrNull(item);
            if (entity != null) {
                void this_$iv$iv;
                Entity this_$iv = entity;
                boolean $i$f$has = false;
                Entity entity2 = this_$iv;
                KClass kClass$iv$iv = Reflection.getOrCreateKotlinClass(PreventEnchanting.class);
                boolean $i$f$has2 = false;
                bl2 = this_$iv$iv.has-VKZWuLQ(EngineHelpersKt.componentId((Geary)this_$iv$iv.getWorld(), (KClassifier)((KClassifier)kClass$iv$iv)));
            } else {
                bl2 = false;
            }
            if (bl2) {
                boolean bl4 = true;
                return bl4;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return false;
    }

    public static /* synthetic */ boolean shouldPrevent$default(PreventEnchantingListener preventEnchantingListener, World world, ItemStack itemStack, PreventType preventType, int n, Object object) {
        if ((n & 4) != 0) {
            preventType = PreventType.NONE;
        }
        return preventEnchantingListener.shouldPrevent(world, itemStack, preventType);
    }
}

