/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.geary.engine;

import com.mineinabyss.geary.addons.GearyPhase;
import com.mineinabyss.geary.engine.Pipeline;
import com.mineinabyss.geary.engine.QueryManager;
import com.mineinabyss.geary.systems.System;
import com.mineinabyss.geary.systems.TrackedSystem;
import com.mineinabyss.geary.systems.query.CachedQuery;
import com.mineinabyss.geary.systems.query.Query;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H\u0016J \u0010\b\u001a\u00020\f2\u0016\u0010\u0019\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\f0\nH\u0016J\b\u0010\u001a\u001a\u00020\fH\u0016J$\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u000f\"\b\b\u0000\u0010\u001c*\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u000bH\u0016J)\u0010\u001f\u001a\u00020\f2\u001a\u0010 \u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u000b0\u0011\"\u0006\u0012\u0002\b\u00030\u000bH\u0016\u00a2\u0006\u0002\u0010!J\u0012\u0010\"\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0#H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R$\u0010\b\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\f0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00120\t0\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/mineinabyss/geary/engine/PipelineImpl;", "Lcom/mineinabyss/geary/engine/Pipeline;", "queryManager", "Lcom/mineinabyss/geary/engine/QueryManager;", "<init>", "(Lcom/mineinabyss/geary/engine/QueryManager;)V", "getQueryManager", "()Lcom/mineinabyss/geary/engine/QueryManager;", "onSystemAdd", "", "Lkotlin/Function1;", "Lcom/mineinabyss/geary/systems/System;", "", "repeatingSystems", "", "Lcom/mineinabyss/geary/systems/TrackedSystem;", "scheduled", "", "Lkotlin/Function0;", "[Ljava/util/List;", "currentPhase", "Lcom/mineinabyss/geary/addons/GearyPhase;", "runOnOrAfter", "phase", "block", "run", "runStartupTasks", "addSystem", "T", "Lcom/mineinabyss/geary/systems/query/Query;", "system", "addSystems", "systems", "([Lcom/mineinabyss/geary/systems/System;)V", "getRepeatingInExecutionOrder", "", "geary-core"})
@SourceDebugExtension(value={"SMAP\nPipelineImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PipelineImpl.kt\ncom/mineinabyss/geary/engine/PipelineImpl\n+ 2 Iteration.kt\ncom/mineinabyss/geary/helpers/IterationKt\n*L\n1#1,50:1\n12#2,2:51\n7#2,3:53\n14#2:56\n7#2,3:57\n12#2,3:60\n*S KotlinDebug\n*F\n+ 1 PipelineImpl.kt\ncom/mineinabyss/geary/engine/PipelineImpl\n*L\n29#1:51,2\n30#1:53,3\n29#1:56\n35#1:57,3\n43#1:60,3\n*E\n"})
public final class PipelineImpl
implements Pipeline {
    @NotNull
    private final QueryManager queryManager;
    @NotNull
    private final List<Function1<System<?>, Unit>> onSystemAdd;
    @NotNull
    private final Set<TrackedSystem<?>> repeatingSystems;
    @NotNull
    private final List<Function0<Unit>>[] scheduled;
    @NotNull
    private GearyPhase currentPhase;

    public PipelineImpl(@NotNull QueryManager queryManager) {
        Intrinsics.checkNotNullParameter((Object)queryManager, (String)"queryManager");
        this.queryManager = queryManager;
        this.onSystemAdd = new ArrayList();
        this.repeatingSystems = new LinkedHashSet();
        int n = 0;
        int n2 = GearyPhase.getEntries().size();
        List[] listArray = new List[n2];
        PipelineImpl pipelineImpl = this;
        while (n < n2) {
            int n3 = n++;
            listArray[n3] = new ArrayList();
        }
        pipelineImpl.scheduled = listArray;
        this.currentPhase = (GearyPhase)((Object)CollectionsKt.first((List)((List)GearyPhase.getEntries())));
    }

    @NotNull
    public final QueryManager getQueryManager() {
        return this.queryManager;
    }

    @Override
    public void runOnOrAfter(@NotNull GearyPhase phase, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)((Object)phase), (String)"phase");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (this.currentPhase.compareTo((Enum)phase) > 0) {
            block.invoke();
        } else {
            this.scheduled[phase.ordinal()].add(block);
        }
    }

    @Override
    public void onSystemAdd(@NotNull Function1<? super System<?>, Unit> run) {
        Intrinsics.checkNotNullParameter(run, (String)"run");
        this.onSystemAdd.add(run);
    }

    @Override
    public void runStartupTasks() {
        List<Function0<Unit>>[] $this$fastForEach$iv = this.scheduled;
        boolean $i$f$fastForEach = false;
        int n$iv = 0;
        while (n$iv < $this$fastForEach$iv.length) {
            List<Function0<Unit>> actions = $this$fastForEach$iv[n$iv++];
            boolean bl = false;
            List<Function0<Unit>> $this$fastForEach$iv2 = actions;
            boolean $i$f$fastForEach2 = false;
            int n$iv2 = 0;
            while (n$iv2 < $this$fastForEach$iv2.size()) {
                Function0<Unit> it = $this$fastForEach$iv2.get(n$iv2++);
                boolean bl2 = false;
                it.invoke();
            }
        }
    }

    @Override
    @NotNull
    public <T extends Query> TrackedSystem<?> addSystem(@NotNull System<T> system) {
        Intrinsics.checkNotNullParameter(system, (String)"system");
        List<Function1<System<?>, Unit>> $this$fastForEach$iv = this.onSystemAdd;
        boolean $i$f$fastForEach = false;
        int n$iv = 0;
        while (n$iv < $this$fastForEach$iv.size()) {
            Function1<System<?>, Unit> it = $this$fastForEach$iv.get(n$iv++);
            boolean bl = false;
            it.invoke(system);
        }
        CachedQuery<T> runner = this.queryManager.trackQuery(system.getQuery());
        TrackedSystem<T> tracked = new TrackedSystem<T>(system, runner);
        this.repeatingSystems.add(tracked);
        return new TrackedSystem<T>(system, runner);
    }

    @Override
    public void addSystems(System<?> ... systems) {
        Intrinsics.checkNotNullParameter(systems, (String)"systems");
        System<?>[] $this$fastForEach$iv = systems;
        boolean $i$f$fastForEach = false;
        int n$iv = 0;
        while (n$iv < $this$fastForEach$iv.length) {
            System<?> it = $this$fastForEach$iv[n$iv++];
            boolean bl = false;
            this.addSystem(it);
        }
    }

    @Override
    @NotNull
    public Iterable<TrackedSystem<?>> getRepeatingInExecutionOrder() {
        return this.repeatingSystems;
    }
}

