/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.emojy.helpers;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.unnamed.creative.base.Writable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u0017\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u0000 N2\u00020\u0001:\u0002NOB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u0007J\u0006\u00105\u001a\u00020\u0007J\u000e\u00106\u001a\u0002072\u0006\u00102\u001a\u00020\u0007J\b\u00108\u001a\u000207H\u0002J\u0010\u00109\u001a\u0004\u0018\u00010 2\u0006\u00104\u001a\u00020\u0007J\u000e\u0010:\u001a\u00020\u00072\u0006\u0010;\u001a\u00020<J\u0010\u0010:\u001a\u00020\u00072\b\u0010=\u001a\u0004\u0018\u00010>J\b\u0010?\u001a\u000207H\u0002J\b\u0010@\u001a\u00020\u000bH\u0002J\b\u0010A\u001a\u000207H\u0002J\b\u0010:\u001a\u00020\u0007H\u0002J\b\u0010B\u001a\u00020\u0007H\u0002J\u0012\u0010C\u001a\u0004\u0018\u00010\u000f2\u0006\u0010D\u001a\u00020\u0007H\u0002J\b\u0010E\u001a\u000207H\u0002J\b\u0010F\u001a\u000207H\u0002J\b\u0010G\u001a\u000207H\u0002J\b\u0010H\u001a\u000207H\u0002J\b\u0010I\u001a\u000207H\u0002J\b\u0010J\u001a\u000207H\u0002J\b\u0010K\u001a\u00020\u0007H\u0002J\b\u0010L\u001a\u000207H\u0002J\b\u0010M\u001a\u000207H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lcom/mineinabyss/emojy/helpers/GifDecoder;", "", "<init>", "()V", "input", "Ljava/io/BufferedInputStream;", "status", "", "width", "height", "gctFlag", "", "gctSize", "loopCount", "gct", "", "lct", "act", "bgIndex", "bgColor", "lastBgColor", "pixelAspect", "lctFlag", "interlace", "lctSize", "ix", "iy", "iw", "ih", "lastRect", "Ljava/awt/Rectangle;", "image", "Ljava/awt/image/BufferedImage;", "lastImage", "block", "", "blockSize", "dispose", "lastDispose", "transparency", "delay", "transIndex", "prefix", "", "suffix", "pixelStack", "pixels", "frames", "", "Lcom/mineinabyss/emojy/helpers/GifDecoder$GifFrame;", "frameCount", "getDelay", "n", "getFrameCount", "setFrameCount", "", "setPixels", "getFrame", "read", "writable", "Lteam/unnamed/creative/base/Writable;", "inputStream", "Ljava/io/InputStream;", "decodeImageData", "err", "init", "readBlock", "readColorTable", "ncolors", "readContents", "readGraphicControlExt", "readHeader", "readImage", "readLSD", "readNetscapeExt", "readShort", "resetFrame", "skip", "Companion", "GifFrame", "core"})
@SourceDebugExtension(value={"SMAP\nGifDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GifDecoder.kt\ncom/mineinabyss/emojy/helpers/GifDecoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,427:1\n1#2:428\n*E\n"})
public final class GifDecoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private BufferedInputStream input;
    private int status;
    private int width;
    private int height;
    private boolean gctFlag;
    private int gctSize;
    private int loopCount = 1;
    @Nullable
    private int[] gct;
    @Nullable
    private int[] lct;
    @Nullable
    private int[] act;
    private int bgIndex;
    private int bgColor;
    private int lastBgColor;
    private int pixelAspect;
    private boolean lctFlag;
    private boolean interlace;
    private int lctSize;
    private int ix;
    private int iy;
    private int iw;
    private int ih;
    @Nullable
    private Rectangle lastRect;
    @Nullable
    private BufferedImage image;
    @Nullable
    private BufferedImage lastImage;
    @NotNull
    private byte[] block = new byte[256];
    private int blockSize;
    private int dispose;
    private int lastDispose;
    private boolean transparency;
    private int delay;
    private int transIndex;
    @Nullable
    private short[] prefix;
    @Nullable
    private byte[] suffix;
    @Nullable
    private byte[] pixelStack;
    @Nullable
    private byte[] pixels;
    @NotNull
    private List<GifFrame> frames = new ArrayList();
    private int frameCount;
    public static final int STATUS_FORMAT_ERROR = 1;
    public static final int STATUS_OPEN_ERROR = 2;
    private static final int MAX_STACK_SIZE = 4096;

    public final int getDelay(int n) {
        this.delay = -1;
        boolean bl = 0 <= n ? n < this.frameCount : false;
        if (bl) {
            this.delay = this.frames.get(n).getDelay();
        }
        return this.delay;
    }

    public final int getFrameCount() {
        return this.frameCount;
    }

    public final void setFrameCount(int frameCount) {
        this.frameCount = frameCount;
    }

    private final void setPixels() {
        Object object = this.image;
        DataBuffer dataBuffer = object != null && (object = ((BufferedImage)object).getRaster()) != null ? ((Raster)object).getDataBuffer() : null;
        Intrinsics.checkNotNull((Object)dataBuffer, (String)"null cannot be cast to non-null type java.awt.image.DataBufferInt");
        int[] dest = ((DataBufferInt)dataBuffer).getData();
        if (this.lastDispose > 0) {
            if (this.lastDispose == 3) {
                int n = this.frameCount - 2;
                this.lastImage = n > 0 ? this.getFrame(n - 1) : null;
            }
            BufferedImage bufferedImage = this.lastImage;
            if (bufferedImage != null) {
                BufferedImage last = bufferedImage;
                boolean bl = false;
                DataBuffer dataBuffer2 = last.getRaster().getDataBuffer();
                Intrinsics.checkNotNull((Object)dataBuffer2, (String)"null cannot be cast to non-null type java.awt.image.DataBufferInt");
                int[] prev = ((DataBufferInt)dataBuffer2).getData();
                System.arraycopy(prev, 0, dest, 0, this.width * this.height);
                if (this.lastDispose == 2) {
                    BufferedImage bufferedImage2 = this.image;
                    Intrinsics.checkNotNull((Object)bufferedImage2);
                    Graphics2D g = bufferedImage2.createGraphics();
                    Color c = this.transparency ? new Color(0, 0, 0, 0) : new Color(this.lastBgColor);
                    g.setColor(c);
                    g.setComposite(AlphaComposite.Src);
                    g.fill(this.lastRect);
                    g.dispose();
                }
            }
        }
        int pass = 1;
        int inc = 8;
        int iline = 0;
        int n = this.ih;
        for (int i = 0; i < n; ++i) {
            int line = i;
            if (this.interlace) {
                if (iline >= this.ih) {
                    switch (++pass) {
                        case 2: {
                            iline = 4;
                            break;
                        }
                        case 3: {
                            iline = 2;
                            inc = 4;
                            break;
                        }
                        case 4: {
                            iline = 1;
                            inc = 2;
                        }
                    }
                }
                line = iline;
                iline += inc;
            }
            if ((line += this.iy) >= this.height) continue;
            int k = line * this.width;
            int dx = k + this.ix;
            int dlim = dx + this.iw;
            if (k + this.width < dlim) {
                dlim = k + this.width;
            }
            int sx = i * this.iw;
            while (dx < dlim) {
                Intrinsics.checkNotNull((Object)this.pixels);
                int index = this.pixels[sx++] & 0xFF;
                Intrinsics.checkNotNull((Object)this.act);
                int c = this.act[index];
                if (c != 0) {
                    dest[dx] = c;
                }
                ++dx;
            }
        }
    }

    @Nullable
    public final BufferedImage getFrame(int n) {
        GifFrame gifFrame = (GifFrame)CollectionsKt.getOrNull(this.frames, (int)n);
        return gifFrame != null ? gifFrame.getImage() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int read(@NotNull Writable writable) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)writable, (String)"writable");
        Object object2 = this;
        try {
            int n;
            GifDecoder $this$read_u24lambda_u240 = object2;
            boolean bl = false;
            byte[] byArray = writable.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            Object object3 = byArray;
            object3 = new ByteArrayInputStream((byte[])object3);
            Throwable throwable = null;
            try {
                InputStream p0 = (InputStream)object3;
                boolean bl2 = false;
                n = $this$read_u24lambda_u240.read(p0);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable);
            }
            object = Result.constructor-impl((Object)n);
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object it = object = throwable;
            boolean bl = false;
            ((Throwable)it).printStackTrace();
        }
        object = 2;
        return ((Number)(Result.isFailure-impl((Object)object2) ? object : object2)).intValue();
    }

    public final int read(@Nullable InputStream inputStream) {
        this.init();
        if (inputStream != null) {
            BufferedInputStream bufferedInput;
            InputStream inputStream2 = inputStream;
            BufferedInputStream bufferedInputStream = inputStream2 instanceof BufferedInputStream ? (BufferedInputStream)inputStream2 : null;
            if (bufferedInputStream == null) {
                bufferedInputStream = new BufferedInputStream(inputStream);
            }
            this.input = bufferedInput = bufferedInputStream;
            this.readHeader();
            if (!this.err()) {
                this.readContents();
                if (this.frameCount < 0) {
                    this.status = 1;
                }
            }
        } else {
            this.status = 2;
        }
        GifDecoder gifDecoder = this;
        try {
            Unit unit;
            GifDecoder $this$read_u24lambda_u242 = gifDecoder;
            boolean bl = false;
            InputStream inputStream3 = inputStream;
            if (inputStream3 != null) {
                inputStream3.close();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl((Object)unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return this.status;
    }

    private final void decodeImageData() {
        int npix;
        int nullCode;
        block19: {
            block18: {
                nullCode = -1;
                npix = this.iw * this.ih;
                if (this.pixels == null) break block18;
                Intrinsics.checkNotNull((Object)this.pixels);
                if (this.pixels.length >= npix) break block19;
            }
            this.pixels = new byte[npix];
        }
        if (this.prefix == null) {
            this.prefix = new short[4096];
        }
        if (this.suffix == null) {
            this.suffix = new byte[4096];
        }
        if (this.pixelStack == null) {
            this.pixelStack = new byte[4097];
        }
        int dataSize = this.read();
        int clear = 1 << dataSize;
        int endOfInformation = clear + 1;
        int available = clear + 2;
        int oldCode = nullCode;
        int codeSize = dataSize + 1;
        int codeMask = (1 << codeSize) - 1;
        for (int code = 0; code < clear; ++code) {
            Intrinsics.checkNotNull((Object)this.prefix);
            this.prefix[code] = 0;
            Intrinsics.checkNotNull((Object)this.suffix);
            this.suffix[code] = (byte)code;
        }
        int bi = 0;
        int pi = 0;
        int top = 0;
        int first = 0;
        int count = 0;
        int bits = 0;
        int datum = 0;
        int i = 0;
        while (i < npix) {
            if (top == 0) {
                if (bits < codeSize) {
                    if (count == 0) {
                        count = this.readBlock();
                        if (count <= 0) break;
                        bi = 0;
                    }
                    datum += (this.block[bi] & 0xFF) << bits;
                    bits += 8;
                    ++bi;
                    --count;
                    continue;
                }
                int code = datum & codeMask;
                datum >>= codeSize;
                bits -= codeSize;
                if (code > available || code == endOfInformation) break;
                if (code == clear) {
                    codeSize = dataSize + 1;
                    codeMask = (1 << codeSize) - 1;
                    available = clear + 2;
                    oldCode = nullCode;
                    continue;
                }
                if (oldCode == nullCode) {
                    Intrinsics.checkNotNull((Object)this.pixelStack);
                    int n = top++;
                    Intrinsics.checkNotNull((Object)this.suffix);
                    this.pixelStack[n] = this.suffix[code];
                    oldCode = code;
                    first = code;
                    continue;
                }
                int inCode = code;
                if (code == available) {
                    Intrinsics.checkNotNull((Object)this.pixelStack);
                    this.pixelStack[top++] = (byte)first;
                    code = oldCode;
                }
                while (code > clear) {
                    Intrinsics.checkNotNull((Object)this.pixelStack);
                    int n = top++;
                    Intrinsics.checkNotNull((Object)this.suffix);
                    this.pixelStack[n] = this.suffix[code];
                    Intrinsics.checkNotNull((Object)this.prefix);
                    code = this.prefix[code];
                }
                Intrinsics.checkNotNull((Object)this.suffix);
                first = this.suffix[code] & 0xFF;
                if (available >= 4096) {
                    Intrinsics.checkNotNull((Object)this.pixelStack);
                    this.pixelStack[top++] = (byte)first;
                    continue;
                }
                Intrinsics.checkNotNull((Object)this.pixelStack);
                this.pixelStack[top++] = (byte)first;
                Intrinsics.checkNotNull((Object)this.prefix);
                this.prefix[available] = (short)oldCode;
                Intrinsics.checkNotNull((Object)this.suffix);
                this.suffix[available] = (byte)first;
                if ((++available & codeMask) == 0 && available < 4096) {
                    ++codeSize;
                    codeMask += available;
                }
                oldCode = inCode;
            }
            Intrinsics.checkNotNull((Object)this.pixels);
            int n = pi++;
            Intrinsics.checkNotNull((Object)this.pixelStack);
            this.pixels[n] = this.pixelStack[--top];
            ++i;
        }
        for (int j = pi; j < npix; ++j) {
            Intrinsics.checkNotNull((Object)this.pixels);
            this.pixels[j] = 0;
        }
    }

    private final boolean err() {
        return this.status != 0;
    }

    private final void init() {
        this.status = 0;
        this.frameCount = 0;
        this.frames = new ArrayList();
        this.gct = null;
        this.lct = null;
    }

    private final int read() {
        Object object;
        Object object2 = this;
        try {
            GifDecoder $this$read_u24lambda_u243 = object2;
            boolean bl = false;
            BufferedInputStream bufferedInputStream = $this$read_u24lambda_u243.input;
            object = Result.constructor-impl((Object)(bufferedInputStream != null ? bufferedInputStream.read() : 0));
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object it = object = throwable;
            boolean bl = false;
            this.status = 1;
        }
        object = 0;
        return ((Number)(Result.isFailure-impl((Object)object2) ? object : object2)).intValue();
    }

    private final int readBlock() {
        int n;
        this.blockSize = this.read();
        if (this.blockSize > 0) {
            GifDecoder gifDecoder = this;
            try {
                GifDecoder $this$readBlock_u24lambda_u240 = gifDecoder;
                boolean bl = false;
                int count = 0;
                for (n = 0; n < $this$readBlock_u24lambda_u240.blockSize; n += count) {
                    BufferedInputStream bufferedInputStream = $this$readBlock_u24lambda_u240.input;
                    int n2 = count = bufferedInputStream != null ? bufferedInputStream.read($this$readBlock_u24lambda_u240.block, n, $this$readBlock_u24lambda_u240.blockSize - n) : -1;
                    if (count == -1) break;
                }
                Object object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if (n < this.blockSize) {
                this.status = 1;
            }
        }
        return n;
    }

    private final int[] readColorTable(int ncolors) {
        Object $this$readColorTable_u24lambda_u240;
        int nbytes = 3 * ncolors;
        int[] tab = null;
        byte[] c = new byte[nbytes];
        Object object = this;
        try {
            $this$readColorTable_u24lambda_u240 = object;
            boolean bl = false;
            BufferedInputStream bufferedInputStream = ((GifDecoder)$this$readColorTable_u24lambda_u240).input;
            $this$readColorTable_u24lambda_u240 = Result.constructor-impl((Object)(bufferedInputStream != null ? bufferedInputStream.read(c) : 0));
        }
        catch (Throwable bl) {
            $this$readColorTable_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$readColorTable_u24lambda_u240;
        $this$readColorTable_u24lambda_u240 = 0;
        int n = ((Number)(Result.isFailure-impl((Object)object) ? $this$readColorTable_u24lambda_u240 : object)).intValue();
        if (n < nbytes) {
            this.status = 1;
        } else {
            tab = new int[256];
            int i = 0;
            int j = 0;
            while (i < ncolors) {
                int r = c[j++] & 0xFF;
                int g = c[j++] & 0xFF;
                int b = c[j++] & 0xFF;
                tab[i++] = 0xFF000000 | r << 16 | g << 8 | b;
            }
        }
        return tab;
    }

    private final void readContents() {
        boolean done = false;
        block10: while (!done && !this.err()) {
            int code = this.read();
            switch (code) {
                case 0: {
                    continue block10;
                }
                case 33: {
                    switch (this.read()) {
                        case 249: {
                            this.readGraphicControlExt();
                            continue block10;
                        }
                        case 255: {
                            this.readBlock();
                            StringBuilder app = new StringBuilder();
                            int n = 11;
                            int n2 = 0;
                            while (n2 < n) {
                                int it = n2++;
                                boolean bl = false;
                                app.append((char)this.block[it]);
                            }
                            if (Intrinsics.areEqual((Object)app.toString(), (Object)"NETSCAPE2.0")) {
                                this.readNetscapeExt();
                                continue block10;
                            }
                            this.skip();
                            continue block10;
                        }
                    }
                    this.skip();
                    continue block10;
                }
                case 44: {
                    this.readImage();
                    continue block10;
                }
                case 59: {
                    done = true;
                    continue block10;
                }
            }
            this.status = 1;
        }
    }

    private final void readGraphicControlExt() {
        this.read();
        int packed = this.read();
        this.dispose = (packed & 0x1C) >> 2;
        if (this.dispose == 0) {
            this.dispose = 1;
        }
        this.transparency = (packed & 1) != 0;
        this.delay = this.readShort() * 10;
        this.transIndex = this.read();
        this.read();
    }

    private final void readHeader() {
        block3: {
            block2: {
                StringBuilder id = new StringBuilder();
                for (int i = 0; i < 6; ++i) {
                    id.append((char)this.read());
                }
                String string = id.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                if (StringsKt.startsWith$default((String)string, (String)"GIF", (boolean)false, (int)2, null)) break block2;
                this.status = 1;
                break block3;
            }
            this.readLSD();
            if (!this.gctFlag || this.err()) break block3;
            if (this.gct != null) {
                int[] it = this.gct = this.readColorTable(this.gctSize);
                boolean bl = false;
                this.bgColor = it[this.bgIndex];
            }
        }
    }

    private final void readImage() {
        int[] it;
        this.ix = this.readShort();
        this.iy = this.readShort();
        this.iw = this.readShort();
        this.ih = this.readShort();
        int packed = this.read();
        this.lctFlag = (packed & 0x80) != 0;
        this.interlace = (packed & 0x40) != 0;
        this.lctSize = 2 << (packed & 7);
        if (this.lctFlag) {
            this.lct = this.readColorTable(this.lctSize);
            this.act = this.lct;
        } else {
            this.act = this.gct;
            if (this.bgIndex == this.transIndex) {
                this.bgColor = 0;
            }
        }
        int save = 0;
        if (this.transparency) {
            if (this.act != null) {
                it = this.act;
                boolean bl = false;
                save = it[this.transIndex];
                it[this.transIndex] = 0;
            }
        }
        if (this.act == null) {
            this.status = 1;
        }
        if (!this.err()) {
            this.decodeImageData();
            this.skip();
            if (!this.err()) {
                int n = this.frameCount;
                this.frameCount = n + 1;
                this.image = new BufferedImage(this.width, this.height, 2);
                this.setPixels();
                BufferedImage bufferedImage = this.image;
                Intrinsics.checkNotNull((Object)bufferedImage);
                this.frames.add(new GifFrame(bufferedImage, this.delay));
                if (this.transparency) {
                    if (this.act != null) {
                        it = this.act;
                        boolean bl = false;
                        it[this.transIndex] = save;
                    }
                }
                this.resetFrame();
            }
        }
    }

    private final void readLSD() {
        this.width = this.readShort();
        this.height = this.readShort();
        int packed = this.read();
        this.gctFlag = (packed & 0x80) != 0;
        this.gctSize = 2 << (packed & 7);
        this.bgIndex = this.read();
        this.pixelAspect = this.read();
    }

    private final void readNetscapeExt() {
        do {
            this.readBlock();
            if (this.block[0] != 1) continue;
            int b1 = this.block[1] & 0xFF;
            int b2 = this.block[2] & 0xFF;
            this.loopCount = b2 << 8 | b1;
        } while (this.blockSize > 0 && !this.err());
    }

    private final int readShort() {
        return this.read() | this.read() << 8;
    }

    private final void resetFrame() {
        this.lastDispose = this.dispose;
        this.lastRect = new Rectangle(this.ix, this.iy, this.iw, this.ih);
        this.lastImage = this.image;
        this.lastBgColor = this.bgColor;
        this.dispose = 0;
        this.transparency = false;
        this.delay = 0;
        this.lct = null;
    }

    private final void skip() {
        do {
            this.readBlock();
        } while (this.blockSize > 0 && !this.err());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/mineinabyss/emojy/helpers/GifDecoder$Companion;", "", "<init>", "()V", "STATUS_FORMAT_ERROR", "", "STATUS_OPEN_ERROR", "MAX_STACK_SIZE", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0005H\u00d6\u0081\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/mineinabyss/emojy/helpers/GifDecoder$GifFrame;", "", "image", "Ljava/awt/image/BufferedImage;", "delay", "", "<init>", "(Ljava/awt/image/BufferedImage;I)V", "getImage", "()Ljava/awt/image/BufferedImage;", "getDelay", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "core"})
    public static final class GifFrame {
        @NotNull
        private final BufferedImage image;
        private final int delay;

        public GifFrame(@NotNull BufferedImage image, int delay) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            this.image = image;
            this.delay = delay;
        }

        @NotNull
        public final BufferedImage getImage() {
            return this.image;
        }

        public final int getDelay() {
            return this.delay;
        }

        @NotNull
        public final BufferedImage component1() {
            return this.image;
        }

        public final int component2() {
            return this.delay;
        }

        @NotNull
        public final GifFrame copy(@NotNull BufferedImage image, int delay) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            return new GifFrame(image, delay);
        }

        public static /* synthetic */ GifFrame copy$default(GifFrame gifFrame, BufferedImage bufferedImage, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                bufferedImage = gifFrame.image;
            }
            if ((n2 & 2) != 0) {
                n = gifFrame.delay;
            }
            return gifFrame.copy(bufferedImage, n);
        }

        @NotNull
        public String toString() {
            return "GifFrame(image=" + this.image + ", delay=" + this.delay + ")";
        }

        public int hashCode() {
            int result = this.image.hashCode();
            result = result * 31 + Integer.hashCode(this.delay);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GifFrame)) {
                return false;
            }
            GifFrame gifFrame = (GifFrame)other;
            if (!Intrinsics.areEqual((Object)this.image, (Object)gifFrame.image)) {
                return false;
            }
            return this.delay == gifFrame.delay;
        }
    }
}

