/*
 * Decompiled with CFR 0.152.
 */
package com.aaaaahhhhhhh.bananapuncher714.gifconverter;

import com.aaaaahhhhhhh.bananapuncher714.gifconverter.GifDecoder;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class GifConverter {
    private static final int SIZE_LIMIT = 27;

    public static void splitGif(File gif, int frameCount) throws IOException {
        FileInputStream stream = new FileInputStream(gif.getAbsolutePath());
        GifDecoder decoder = new GifDecoder();
        decoder.read(stream);
        stream.close();
        decoder.setFrameCount(frameCount);
        Object placeholder = null;
        File saveDir = new File(gif.getAbsoluteFile().getPath().replace(".gif", ""));
        saveDir.mkdirs();
        int totalWidth = (int)decoder.getFrameSize().getWidth();
        int totalHeight = (int)decoder.getFrameSize().getHeight();
        int newWidth = totalWidth;
        int newHeight = totalHeight;
        if (totalWidth > 27 || totalHeight > 27) {
            if (totalHeight > totalWidth) {
                newWidth = 27 * totalWidth / totalHeight;
                newHeight = 27;
            } else {
                newWidth = 27;
                newHeight = 27 * totalHeight / totalWidth;
            }
        }
        int time = 0;
        int totalTime = 0;
        int i = 0;
        while (i < decoder.getFrameCount()) {
            totalTime += decoder.getDelay(i++);
        }
        for (i = 0; i < decoder.getFrameCount(); ++i) {
            int delay = decoder.getDelay(i);
            int start = time;
            int end = time += delay;
            BufferedImage image = decoder.getFrame(i);
            if (newHeight != totalHeight || newWidth != totalWidth) {
                // empty if block
            }
            BufferedImage frame = GifConverter.generateFrame(image, start, end, totalTime);
            ImageIO.write((RenderedImage)frame, "png", new File(saveDir, String.format("%d.png", i + 1)));
        }
    }

    private static int mix(int c, int v) {
        return c & 0xFCFCFCFC | (v & 3) << 24 | v >>> 2 & 3 | (v >> 4 & 3) << 8 | v >>> 6 << 16;
    }

    private static BufferedImage generateFrame(BufferedImage image, int start, int stop, int total) {
        BufferedImage frame = new BufferedImage(image.getWidth() + 2, image.getHeight() + 2, 2);
        frame.setRGB(1, 1, image.getWidth(), image.getHeight(), image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth()), 0, image.getWidth());
        int width = frame.getWidth() - 1;
        int height = frame.getHeight() - 1;
        int[] info = new int[]{total >> 8 & 0xFF, total & 0xFF, start >> 8 & 0xFF, start & 0xFF, stop >> 8 & 0xFF, stop & 0xFF, 0, 0};
        frame.setRGB(width, 0, GifConverter.compact(0, 0, 0, 149));
        frame.setRGB(0, 0, GifConverter.compact(1, 0, 0, 149));
        frame.setRGB(0, height, GifConverter.compact(2, 0, 0, 149));
        frame.setRGB(width, height, GifConverter.compact(3, 0, 0, 149));
        frame.setRGB(width - 1, 0, GifConverter.compact(info[0], info[1], info[2], info[3]));
        frame.setRGB(width, 1, GifConverter.compact(info[4], info[5], info[6], info[7]));
        frame.setRGB(1, 0, GifConverter.compact(info[0], info[1], info[2], info[3]));
        frame.setRGB(0, 1, GifConverter.compact(info[4], info[5], info[6], info[7]));
        frame.setRGB(1, height, GifConverter.compact(info[0], info[1], info[2], info[3]));
        frame.setRGB(0, height - 1, GifConverter.compact(info[4], info[5], info[6], info[7]));
        frame.setRGB(width - 1, height, GifConverter.compact(info[0], info[1], info[2], info[3]));
        frame.setRGB(width, height - 1, GifConverter.compact(info[4], info[5], info[6], info[7]));
        return frame;
    }

    private static int compact(int b1, int b2, int b3, int b4) {
        return (b4 & 0xFF) << 24 | (b1 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b3 & 0xFF;
    }

    public static BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage && ((BufferedImage)img).getType() == 2) {
            return (BufferedImage)img;
        }
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }
}

