/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.deeperworld.world.section;

import com.mineinabyss.deeperworld.services.WorldManager;
import com.mineinabyss.deeperworld.world.section.Section;
import com.mineinabyss.deeperworld.world.section.SectionKey;
import com.mineinabyss.deeperworld.world.section.SectionUtils;
import com.mineinabyss.idofront.operators.VectorOperatorsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Location;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=5, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\b\u001a\u001c\u0010\t\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001\u001a\u001c\u0010\u0014\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\u0000\u001a\u00020\u00012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001\u001a\u0019\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0019\u001a\u0012\u0010\u001a\u001a\u00020\u000f*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0001\u001a\u0012\u0010\u001b\u001a\u00020\u000f*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0001\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\"\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0004\"\u0017\u0010\t\u001a\u0004\u0018\u00010\u0002*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0015\u0010\u000e\u001a\u00020\u000f*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u0015\u0010\u0012\u001a\u00020\u000f*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011\"\u0015\u0010\u001c\u001a\u00020\u0002*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"section", "Lcom/mineinabyss/deeperworld/world/section/Section;", "Lorg/bukkit/Location;", "getSection", "(Lorg/bukkit/Location;)Lcom/mineinabyss/deeperworld/world/section/Section;", "Lcom/mineinabyss/deeperworld/world/section/SectionKey;", "(Lcom/mineinabyss/deeperworld/world/section/SectionKey;)Lcom/mineinabyss/deeperworld/world/section/Section;", "correspondingSection", "getCorrespondingSection", "correspondingLocation", "getCorrespondingLocation", "(Lorg/bukkit/Location;)Lorg/bukkit/Location;", "sectionA", "sectionB", "inSectionOverlap", "", "getInSectionOverlap", "(Lorg/bukkit/Location;)Z", "inSectionTransition", "getInSectionTransition", "sharedBetween", "otherSection", "overlapWith", "", "other", "(Lcom/mineinabyss/deeperworld/world/section/Section;Lcom/mineinabyss/deeperworld/world/section/Section;)Ljava/lang/Integer;", "isOnTopOf", "isAdjacentTo", "centerLocation", "getCenterLocation", "(Lcom/mineinabyss/deeperworld/world/section/Section;)Lorg/bukkit/Location;", "deeperworld"}, xs="com/mineinabyss/deeperworld/world/section/SectionUtils")
final class SectionUtils__SectionUtilsKt {
    @Nullable
    public static final Section getSection(@NotNull Location $this$section) {
        Intrinsics.checkNotNullParameter((Object)$this$section, (String)"<this>");
        return WorldManager.Companion.getSectionFor($this$section);
    }

    @Nullable
    public static final Section getSection(@NotNull SectionKey $this$section) {
        Intrinsics.checkNotNullParameter((Object)$this$section, (String)"<this>");
        return WorldManager.Companion.getSectionFor($this$section);
    }

    @Nullable
    public static final Section getCorrespondingSection(@NotNull Location $this$correspondingSection) {
        Intrinsics.checkNotNullParameter((Object)$this$correspondingSection, (String)"<this>");
        Section section = SectionUtils.getSection($this$correspondingSection);
        if (section == null) {
            return null;
        }
        Section section2 = section;
        Section aboveSection = SectionUtils.getSection(section2.getAboveKey$deeperworld());
        Section belowSection = SectionUtils.getSection(section2.getBelowKey$deeperworld());
        return SectionUtils.sharedBetween($this$correspondingSection, section2, aboveSection) ? aboveSection : (SectionUtils.sharedBetween($this$correspondingSection, section2, belowSection) ? belowSection : null);
    }

    @Nullable
    public static final Location getCorrespondingLocation(@NotNull Location $this$correspondingLocation) {
        Intrinsics.checkNotNullParameter((Object)$this$correspondingLocation, (String)"<this>");
        Section section = SectionUtils.getSection($this$correspondingLocation);
        if (section == null) {
            return null;
        }
        Section section2 = SectionUtils.getCorrespondingSection($this$correspondingLocation);
        if (section2 == null) {
            return null;
        }
        return SectionUtils.correspondingLocation($this$correspondingLocation, section, section2);
    }

    @Nullable
    public static final Location correspondingLocation(@NotNull Location $this$correspondingLocation, @NotNull Section sectionA, @NotNull Section sectionB) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)$this$correspondingLocation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sectionA, (String)"sectionA");
        Intrinsics.checkNotNullParameter((Object)sectionB, (String)"sectionB");
        if (!SectionUtils.isAdjacentTo(sectionA, sectionB)) {
            return null;
        }
        boolean bl = SectionUtils.isOnTopOf(sectionA, sectionB);
        if (bl) {
            pair = TuplesKt.to((Object)sectionA.getReferenceBottom(), (Object)sectionB.getReferenceTop());
        } else if (!bl) {
            pair = TuplesKt.to((Object)sectionA.getReferenceTop(), (Object)sectionB.getReferenceBottom());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Pair pair2 = pair;
        Location fromSectionLoc = (Location)pair2.component1();
        Location toSectionLoc = (Location)pair2.component2();
        Vector vector = toSectionLoc.toVector();
        Intrinsics.checkNotNullExpressionValue((Object)vector, (String)"toVector(...)");
        Vector vector2 = fromSectionLoc.toVector();
        Intrinsics.checkNotNullExpressionValue((Object)vector2, (String)"toVector(...)");
        Vector delta = VectorOperatorsKt.minus((Vector)vector, (Vector)vector2);
        Location location = $this$correspondingLocation.clone();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"clone(...)");
        Location newLoc = VectorOperatorsKt.plus((Location)location, (Vector)delta);
        newLoc.setWorld(sectionB.getWorld());
        return newLoc;
    }

    public static final boolean getInSectionOverlap(@NotNull Location $this$inSectionOverlap) {
        Intrinsics.checkNotNullParameter((Object)$this$inSectionOverlap, (String)"<this>");
        Section section = SectionUtils.getSection($this$inSectionOverlap);
        if (section == null) {
            return false;
        }
        Section section2 = SectionUtils.getCorrespondingSection($this$inSectionOverlap);
        if (section2 == null) {
            return false;
        }
        return SectionUtils.sharedBetween($this$inSectionOverlap, section, section2);
    }

    public static final boolean getInSectionTransition(@NotNull Location $this$inSectionTransition) {
        Object object;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)$this$inSectionTransition, (String)"<this>");
                object = SectionUtils.getSection($this$inSectionTransition);
                if (object == null) break block4;
                Section section = SectionUtils.getCorrespondingSection($this$inSectionTransition);
                if (section == null) {
                    return false;
                }
                if ((object = SectionUtils.overlapWith((Section)object, section)) != null) break block5;
            }
            return false;
        }
        int shared = (Integer)object;
        String string = $this$inSectionTransition.getWorld().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        int minHeight = StringsKt.contains$default((CharSequence)string, (CharSequence)"2021", (boolean)false, (int)2, null) ? 0 : $this$inSectionTransition.getWorld().getMinHeight();
        return (double)$this$inSectionTransition.getBlockY() >= (double)$this$inSectionTransition.getWorld().getMaxHeight() - 0.3 * (double)shared || (double)$this$inSectionTransition.getBlockY() <= (double)minHeight + 0.3 * (double)shared;
    }

    public static final boolean sharedBetween(@NotNull Location $this$sharedBetween, @NotNull Section section, @Nullable Section otherSection) {
        Intrinsics.checkNotNullParameter((Object)$this$sharedBetween, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)section, (String)"section");
        Section section2 = otherSection;
        if (section2 == null) {
            return false;
        }
        Integer n = SectionUtils.overlapWith(section, section2);
        if (n == null) {
            return false;
        }
        int overlap = n;
        String string = $this$sharedBetween.getWorld().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        int minHeight = StringsKt.contains$default((CharSequence)string, (CharSequence)"2021", (boolean)false, (int)2, null) ? 0 : $this$sharedBetween.getWorld().getMinHeight();
        return SectionUtils.isOnTopOf(section, otherSection) ? $this$sharedBetween.getBlockY() <= minHeight + overlap : (SectionUtils.isOnTopOf(otherSection, section) ? $this$sharedBetween.getBlockY() >= $this$sharedBetween.getWorld().getMaxHeight() - overlap : false);
    }

    @Nullable
    public static final Integer overlapWith(@NotNull Section $this$overlapWith, @NotNull Section other) {
        Intrinsics.checkNotNullParameter((Object)$this$overlapWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!SectionUtils.isAdjacentTo($this$overlapWith, other)) {
            return null;
        }
        if (Math.min($this$overlapWith.getRegion().getMax().getY(), other.getRegion().getMax().getY()) <= Math.max($this$overlapWith.getRegion().getMin().getY(), other.getRegion().getMin().getY())) {
            return null;
        }
        Pair pair = SectionUtils.isOnTopOf($this$overlapWith, other) ? TuplesKt.to((Object)$this$overlapWith.getReferenceBottom().getBlockY(), (Object)other.getReferenceTop().getBlockY()) : TuplesKt.to((Object)$this$overlapWith.getReferenceTop().getBlockY(), (Object)other.getReferenceBottom().getBlockY());
        int yA = ((Number)pair.component1()).intValue();
        int yB = ((Number)pair.component2()).intValue();
        return Math.max($this$overlapWith.getRegion().getMax().getY(), other.getRegion().getMax().getY()) - Math.max(yA, yB) + (Math.min(yA, yB) - Math.min($this$overlapWith.getRegion().getMin().getY(), other.getRegion().getMin().getY()));
    }

    public static final boolean isOnTopOf(@NotNull Section $this$isOnTopOf, @NotNull Section other) {
        Intrinsics.checkNotNullParameter((Object)$this$isOnTopOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual((Object)$this$isOnTopOf.getKey(), (Object)other.getAboveKey$deeperworld());
    }

    public static final boolean isAdjacentTo(@NotNull Section $this$isAdjacentTo, @NotNull Section other) {
        Intrinsics.checkNotNullParameter((Object)$this$isAdjacentTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return SectionUtils.isOnTopOf($this$isAdjacentTo, other) || SectionUtils.isOnTopOf(other, $this$isAdjacentTo);
    }

    @NotNull
    public static final Location getCenterLocation(@NotNull Section $this$centerLocation) {
        Intrinsics.checkNotNullParameter((Object)$this$centerLocation, (String)"<this>");
        return new Location($this$centerLocation.getWorld(), (double)$this$centerLocation.getRegion().getCenter().getX(), (double)$this$centerLocation.getRegion().getCenter().getY(), (double)$this$centerLocation.getRegion().getCenter().getZ());
    }
}

