/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.deeperworld.world;

import com.mineinabyss.deeperworld.DeeperConfigKt;
import com.mineinabyss.deeperworld.services.WorldManager;
import com.mineinabyss.deeperworld.world.section.AbstractSectionKey;
import com.mineinabyss.deeperworld.world.section.Section;
import com.mineinabyss.deeperworld.world.section.SectionKey;
import com.mineinabyss.deeperworld.world.section.SectionUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J/\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016\u00a2\u0006\u0002\u0010 J\u0018\u0010!\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J*\u0010\"\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u000eH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/mineinabyss/deeperworld/world/WorldManagerImpl;", "Lcom/mineinabyss/deeperworld/services/WorldManager;", "<init>", "()V", "sections", "", "Lcom/mineinabyss/deeperworld/world/section/Section;", "getSections", "()Ljava/util/Set;", "sectionMap", "", "Lcom/mineinabyss/deeperworld/world/section/SectionKey;", "registerSection", "name", "", "section", "sectionKey", "registerInternal", "key", "unregisterSection", "", "getDepthFor", "", "location", "Lorg/bukkit/Location;", "(Lorg/bukkit/Location;)Ljava/lang/Integer;", "x", "", "y", "z", "world", "Lorg/bukkit/World;", "(DDDLorg/bukkit/World;)Ljava/lang/Integer;", "internalGetDepthFor", "getSectionFor", "deeperworld"})
@SourceDebugExtension(value={"SMAP\nWorldManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldManagerImpl.kt\ncom/mineinabyss/deeperworld/world/WorldManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1220#2,2:80\n1249#2,4:82\n296#2,2:86\n*S KotlinDebug\n*F\n+ 1 WorldManagerImpl.kt\ncom/mineinabyss/deeperworld/world/WorldManagerImpl\n*L\n18#1:80,2\n18#1:82,4\n74#1:86,2\n*E\n"})
public final class WorldManagerImpl
implements WorldManager {
    @NotNull
    private final Map<SectionKey, Section> sectionMap;

    /*
     * WARNING - void declaration
     */
    public WorldManagerImpl() {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Iterable iterable = DeeperConfigKt.getDeeperWorld().getConfig().getSections();
        WorldManagerImpl worldManagerImpl = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var4_5 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Section section = (Section)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getKey(), element$iv$iv);
        }
        worldManagerImpl.sectionMap = MapsKt.toMutableMap((Map)destination$iv$iv);
    }

    @Override
    @NotNull
    public Set<Section> getSections() {
        return CollectionsKt.toSet((Iterable)this.sectionMap.values());
    }

    @Override
    @NotNull
    public SectionKey registerSection(@NotNull String name, @NotNull Section section) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)section, (String)"section");
        return this.registerInternal(new AbstractSectionKey.CustomSectionKey(name), section);
    }

    @Override
    @NotNull
    public SectionKey registerSection(@NotNull SectionKey sectionKey, @NotNull Section section) {
        Intrinsics.checkNotNullParameter((Object)sectionKey, (String)"sectionKey");
        Intrinsics.checkNotNullParameter((Object)section, (String)"section");
        return this.registerInternal(sectionKey, section);
    }

    private final SectionKey registerInternal(SectionKey key, Section section) {
        if (this.sectionMap.containsKey(key)) {
            throw new RuntimeException("Bruh");
        }
        this.sectionMap.put(key, section);
        return key;
    }

    @NotNull
    public Void unregisterSection(@NotNull SectionKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        throw new NotImplementedError(null, 1, null);
    }

    @Override
    @Nullable
    public Integer getDepthFor(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Section section = WorldManager.Companion.getSectionFor(location);
        if (section == null) {
            return null;
        }
        Section section2 = section;
        return this.internalGetDepthFor((int)Math.floor(location.getY()), section2);
    }

    @Override
    @Nullable
    public Integer getDepthFor(double x, double y, double z, @NotNull World world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        int yFloored = (int)Math.floor(y);
        Section section = WorldManager.Companion.getSectionFor((int)Math.floor(x), yFloored, (int)Math.floor(z), world);
        if (section == null) {
            return null;
        }
        Section section2 = section;
        return this.internalGetDepthFor(yFloored, section2);
    }

    private final int internalGetDepthFor(int y, Section section) {
        int depth = section.getRegion().getMax().getY() - y;
        Section currentSection = section;
        Section aboveSection = SectionUtils.getSection(section.getAboveKey$deeperworld());
        if (aboveSection != null) {
            ++depth;
        }
        while (aboveSection != null) {
            depth += aboveSection.getHeight();
            Integer n = SectionUtils.overlapWith(aboveSection, currentSection);
            depth -= n != null ? n : 0;
            currentSection = aboveSection;
            aboveSection = SectionUtils.getSection(currentSection.getAboveKey$deeperworld());
        }
        return depth;
    }

    @Override
    @Nullable
    public Section getSectionFor(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        int n = location.getBlockX();
        int n2 = location.getBlockY();
        int n3 = location.getBlockZ();
        World world = location.getWorld();
        Intrinsics.checkNotNull((Object)world);
        return this.getSectionFor(n, n2, n3, world);
    }

    @Override
    @Nullable
    public Section getSectionFor(int x, int y, int z, @NotNull World world) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Iterable $this$firstOrNull$iv = this.sectionMap.values();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Section it = (Section)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getWorld(), (Object)world) && it.getRegion().contains(x, y, z))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    @Nullable
    public Section getSectionFor(@NotNull SectionKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.sectionMap.get(key);
    }

    @Override
    @Nullable
    public Section getSectionFor(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.sectionMap.get(new AbstractSectionKey.CustomSectionKey(key));
    }
}

