/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.deeperworld.movement.transition;

import com.mineinabyss.deeperworld.movement.transition.SectionChecker;
import com.mineinabyss.deeperworld.movement.transition.SectionTransition;
import com.mineinabyss.deeperworld.movement.transition.TransitionKind;
import com.mineinabyss.deeperworld.world.section.Section;
import com.mineinabyss.deeperworld.world.section.SectionUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/mineinabyss/deeperworld/movement/transition/ConfigSectionChecker;", "Lcom/mineinabyss/deeperworld/movement/transition/SectionChecker;", "<init>", "()V", "inSection", "", "entity", "Lorg/bukkit/entity/Entity;", "checkForTransition", "Lcom/mineinabyss/deeperworld/movement/transition/SectionTransition;", "from", "Lorg/bukkit/Location;", "to", "deeperworld"})
public final class ConfigSectionChecker
implements SectionChecker {
    @NotNull
    public static final ConfigSectionChecker INSTANCE = new ConfigSectionChecker();

    private ConfigSectionChecker() {
    }

    @Override
    public boolean inSection(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Location location = entity.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        return SectionUtils.getSection(location) != null;
    }

    @Override
    @Nullable
    public SectionTransition checkForTransition(@NotNull Entity entity, @NotNull Location from, @NotNull Location to) {
        SectionTransition sectionTransition;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Section section = SectionUtils.getSection(from);
        if (section == null) {
            return null;
        }
        Section fromSection = section;
        Section section2 = SectionUtils.getSection(to);
        if (section2 == null) {
            return null;
        }
        Section toSection = section2;
        Object object = SectionUtils.getInSectionTransition(to) ? SectionUtils.getCorrespondingLocation(to) : (!Intrinsics.areEqual((Object)fromSection, (Object)toSection) ? to : null);
        if (object == null) {
            return null;
        }
        Location corrLoc = object;
        Section section3 = SectionUtils.getSection(corrLoc);
        if (section3 != null) {
            Section it = section3;
            boolean bl = false;
            sectionTransition = new SectionTransition(from, corrLoc, fromSection, it, to.getY() < from.getY() ? TransitionKind.DESCEND : TransitionKind.ASCEND, !Intrinsics.areEqual((Object)fromSection, (Object)toSection));
        } else {
            sectionTransition = null;
        }
        return sectionTransition;
    }
}

