/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.deeperworld.movement;

import com.mineinabyss.deeperworld.DeeperConfigKt;
import com.mineinabyss.deeperworld.movement.BedrockBlockingInvalidTeleportHandler;
import com.mineinabyss.deeperworld.movement.EmptyTeleportHandler;
import com.mineinabyss.deeperworld.movement.InvalidTeleportHandler;
import com.mineinabyss.deeperworld.movement.TeleportHandler;
import com.mineinabyss.deeperworld.movement.TransitionTeleportHandler;
import com.mineinabyss.deeperworld.movement.UndoMovementInvalidTeleportHandler;
import com.mineinabyss.deeperworld.movement.transition.ConfigSectionChecker;
import com.mineinabyss.deeperworld.movement.transition.SectionTransition;
import com.mineinabyss.deeperworld.movement.transition.SectionTransitionKt;
import com.mineinabyss.deeperworld.movement.transition.TransitionKind;
import com.mineinabyss.idofront.textcomponents.MiniMessageHelpersKt;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J\f\u0010\u0013\u001a\u00020\r*\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/mineinabyss/deeperworld/movement/MovementHandler;", "", "<init>", "()V", "sectionCheckers", "", "Lcom/mineinabyss/deeperworld/movement/transition/ConfigSectionChecker;", "teleportCooldown", "", "Ljava/util/UUID;", "getTeleportCooldown", "()Ljava/util/Set;", "handleMovement", "", "entity", "Lorg/bukkit/entity/Entity;", "from", "Lorg/bukkit/Location;", "to", "applyOutOfBoundsDamage", "Lorg/bukkit/entity/Player;", "getTeleportHandler", "Lcom/mineinabyss/deeperworld/movement/TeleportHandler;", "sectionTransition", "Lcom/mineinabyss/deeperworld/movement/transition/SectionTransition;", "deeperworld"})
@SourceDebugExtension(value={"SMAP\nMovementHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MovementHandler.kt\ncom/mineinabyss/deeperworld/movement/MovementHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 EventCalling.kt\ncom/mineinabyss/idofront/events/EventCallingKt\n*L\n1#1,71:1\n1807#2,3:72\n1#3:75\n24#4,4:76\n*S KotlinDebug\n*F\n+ 1 MovementHandler.kt\ncom/mineinabyss/deeperworld/movement/MovementHandler\n*L\n26#1:72,3\n29#1:76,4\n*E\n"})
public final class MovementHandler {
    @NotNull
    public static final MovementHandler INSTANCE = new MovementHandler();
    @NotNull
    private static final List<ConfigSectionChecker> sectionCheckers = CollectionsKt.listOf((Object)ConfigSectionChecker.INSTANCE);
    @NotNull
    private static final Set<UUID> teleportCooldown = new LinkedHashSet();

    private MovementHandler() {
    }

    @NotNull
    public final Set<UUID> getTeleportCooldown() {
        return teleportCooldown;
    }

    public final void handleMovement(@NotNull Entity entity, @NotNull Location from, @NotNull Location to) {
        block7: {
            block6: {
                TeleportHandler $this$handleMovement_u24lambda_u242_u240;
                block8: {
                    Object object;
                    block5: {
                        boolean bl;
                        block4: {
                            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
                            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
                            Iterable $this$any$iv = sectionCheckers;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    ConfigSectionChecker it = (ConfigSectionChecker)element$iv;
                                    boolean bl2 = false;
                                    if (!it.inSection(entity)) continue;
                                    bl = true;
                                    break block4;
                                }
                                bl = false;
                            }
                        }
                        if (!bl) break block6;
                        for (Object it : (Iterable)sectionCheckers) {
                            boolean bl3 = false;
                            if ((it = ((ConfigSectionChecker)it).checkForTransition(entity, from, to)) == null) continue;
                            object = it;
                            break block5;
                        }
                        object = null;
                    }
                    if (object == null) break block7;
                    Object it = object;
                    boolean bl = false;
                    $this$handleMovement_u24lambda_u242_u240 = INSTANCE.getTeleportHandler(entity, (SectionTransition)it);
                    boolean bl4 = false;
                    if (!$this$handleMovement_u24lambda_u242_u240.isValidTeleport() || !(entity instanceof Player)) break block8;
                    Event $this$call$iv = (Event)SectionTransitionKt.toEvent((SectionTransition)it, (Player)entity);
                    boolean $i$f$call = false;
                    Bukkit.getServer().getPluginManager().callEvent($this$call$iv);
                    if ($this$call$iv instanceof Cancellable && ((Cancellable)$this$call$iv).isCancelled()) break block7;
                    Event $this$handleMovement_u24lambda_u242_u240_u240 = $this$call$iv;
                    boolean bl5 = false;
                    $this$handleMovement_u24lambda_u242_u240.handleTeleport();
                    break block7;
                }
                $this$handleMovement_u24lambda_u242_u240.handleTeleport();
                break block7;
            }
            Player player = entity instanceof Player ? (Player)entity : null;
            if (player == null) break block7;
            this.applyOutOfBoundsDamage(player);
        }
    }

    private final void applyOutOfBoundsDamage(Player $this$applyOutOfBoundsDamage) {
        if (DeeperConfigKt.getDeeperWorld().getConfig().getDamageOutsideSections() > 0.0 && !DeeperConfigKt.getDeeperWorld().getConfig().getDamageExcludedWorlds().contains($this$applyOutOfBoundsDamage.getLocation().getWorld()) && ($this$applyOutOfBoundsDamage.getGameMode() == GameMode.SURVIVAL || $this$applyOutOfBoundsDamage.getGameMode() == GameMode.ADVENTURE) && DeeperConfigKt.getDeeperWorld().getConfig().getWorlds().contains($this$applyOutOfBoundsDamage.getLocation().getWorld())) {
            $this$applyOutOfBoundsDamage.damage(0.01);
            AttributeInstance attributeInstance = $this$applyOutOfBoundsDamage.getAttribute(Attribute.MAX_HEALTH);
            $this$applyOutOfBoundsDamage.setHealth(((Number)((Object)RangesKt.coerceIn((Comparable)Double.valueOf($this$applyOutOfBoundsDamage.getHealth() - DeeperConfigKt.getDeeperWorld().getConfig().getDamageOutsideSections() / (double)10), (Comparable)Double.valueOf(0.0), (Comparable)(attributeInstance != null ? Double.valueOf(attributeInstance.getValue()) : null)))).doubleValue());
            Component component = MiniMessageHelpersKt.miniMsg$default((String)"You are not in a managed section", null, (int)1, null).color((TextColor)NamedTextColor.RED);
            Component component2 = MiniMessageHelpersKt.miniMsg$default((String)"You will take damage upon moving!", null, (int)1, null).color((TextColor)NamedTextColor.GRAY);
            long l = DurationKt.toDuration((int)0, (DurationUnit)DurationUnit.SECONDS);
            int n = Duration.getNanosecondsComponent-impl((long)l);
            long l2 = Duration.getInWholeSeconds-impl((long)l);
            java.time.Duration duration = java.time.Duration.ofSeconds(l2, n);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"toComponents-impl(...)");
            l = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS);
            n = Duration.getNanosecondsComponent-impl((long)l);
            l2 = Duration.getInWholeSeconds-impl((long)l);
            java.time.Duration duration2 = java.time.Duration.ofSeconds(l2, n);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"toComponents-impl(...)");
            l = DurationKt.toDuration((double)0.5, (DurationUnit)DurationUnit.SECONDS);
            n = Duration.getNanosecondsComponent-impl((long)l);
            l2 = Duration.getInWholeSeconds-impl((long)l);
            java.time.Duration duration3 = java.time.Duration.ofSeconds(l2, n);
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"toComponents-impl(...)");
            $this$applyOutOfBoundsDamage.showTitle(Title.title((Component)component, (Component)component2, (Title.Times)Title.Times.times((java.time.Duration)duration, (java.time.Duration)duration2, (java.time.Duration)duration3)));
        }
    }

    private final TeleportHandler getTeleportHandler(Entity entity, SectionTransition sectionTransition) {
        TeleportHandler teleportHandler;
        if (sectionTransition.getTeleportUnnecessary() || teleportCooldown.contains(entity.getUniqueId())) {
            teleportHandler = EmptyTeleportHandler.INSTANCE;
        } else if (entity instanceof Player && ((Player)entity).getGameMode() != GameMode.SPECTATOR && sectionTransition.getTo().getBlock().isSolid()) {
            teleportHandler = WhenMappings.$EnumSwitchMapping$0[sectionTransition.getKind().ordinal()] == 1 ? (InvalidTeleportHandler)new UndoMovementInvalidTeleportHandler((Player)entity, sectionTransition) : (InvalidTeleportHandler)new BedrockBlockingInvalidTeleportHandler((Player)entity, sectionTransition);
        } else {
            Entity entity2 = entity.getVehicle();
            if (entity2 == null) {
                entity2 = entity;
            }
            teleportHandler = new TransitionTeleportHandler(entity2, sectionTransition);
        }
        return teleportHandler;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TransitionKind.values().length];
            try {
                nArray[TransitionKind.ASCEND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

