/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.deeperworld.world;

import com.mineinabyss.deeperworld.world.CubePoint;
import com.mineinabyss.deeperworld.world.RegionSerializer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=RegionSerializer.class)
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u0000 &2\u00020\u0001:\u0001&B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B9\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\b\u0012\u0006\u0010\r\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\u000eJ\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bJ\u0011\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0003H\u0086\u0002J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010!\u001a\u00020\u00192\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010#\u001a\u00020\bH\u00d6\u0081\u0004J\n\u0010$\u001a\u00020%H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0014\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\u0016\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0010\u00a8\u0006'"}, d2={"Lcom/mineinabyss/deeperworld/world/Region;", "", "start", "Lcom/mineinabyss/deeperworld/world/CubePoint;", "end", "<init>", "(Lcom/mineinabyss/deeperworld/world/CubePoint;Lcom/mineinabyss/deeperworld/world/CubePoint;)V", "ax", "", "ay", "az", "bx", "by", "bz", "(IIIIII)V", "getStart", "()Lcom/mineinabyss/deeperworld/world/CubePoint;", "getEnd", "min", "getMin", "max", "getMax", "center", "getCenter", "contains", "", "x", "y", "z", "p", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "", "Companion", "deeperworld"})
public final class Region {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CubePoint start;
    @NotNull
    private final CubePoint end;
    @NotNull
    private final CubePoint min;
    @NotNull
    private final CubePoint max;

    public Region(@NotNull CubePoint start, @NotNull CubePoint end) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        this.start = start;
        this.end = end;
        this.min = new CubePoint(Math.min(this.start.getX(), this.end.getX()), Math.min(this.start.getY(), this.end.getY()), Math.min(this.start.getZ(), this.end.getZ()));
        this.max = new CubePoint(Math.max(this.start.getX(), this.end.getX()), Math.max(this.start.getY(), this.end.getY()), Math.max(this.start.getZ(), this.end.getZ()));
    }

    @NotNull
    public final CubePoint getStart() {
        return this.start;
    }

    @NotNull
    public final CubePoint getEnd() {
        return this.end;
    }

    @NotNull
    public final CubePoint getMin() {
        return this.min;
    }

    @NotNull
    public final CubePoint getMax() {
        return this.max;
    }

    public Region(int ax, int ay, int az, int bx, int by, int bz) {
        this(new CubePoint(ax, ay, az), new CubePoint(bx, by, bz));
    }

    @NotNull
    public final CubePoint getCenter() {
        return this.start.plus(this.end).div(2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean contains(int x, int y, int z) {
        int n = Math.min(this.start.getX(), this.end.getX());
        if (x > Math.max(this.start.getX(), this.end.getX())) return false;
        if (n > x) return false;
        boolean bl = true;
        if (!bl) return false;
        n = Math.min(this.start.getY(), this.end.getY());
        if (y > Math.max(this.start.getY(), this.end.getY())) return false;
        if (n > y) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        n = Math.min(this.start.getZ(), this.end.getZ());
        if (z > Math.max(this.start.getZ(), this.end.getZ())) return false;
        if (n > z) return false;
        return true;
    }

    public final boolean contains(@NotNull CubePoint p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return this.contains(p.getX(), p.getY(), p.getZ());
    }

    @NotNull
    public final CubePoint component1() {
        return this.start;
    }

    @NotNull
    public final CubePoint component2() {
        return this.end;
    }

    @NotNull
    public final Region copy(@NotNull CubePoint start, @NotNull CubePoint end) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        return new Region(start, end);
    }

    public static /* synthetic */ Region copy$default(Region region, CubePoint cubePoint, CubePoint cubePoint2, int n, Object object) {
        if ((n & 1) != 0) {
            cubePoint = region.start;
        }
        if ((n & 2) != 0) {
            cubePoint2 = region.end;
        }
        return region.copy(cubePoint, cubePoint2);
    }

    @NotNull
    public String toString() {
        return "Region(start=" + this.start + ", end=" + this.end + ")";
    }

    public int hashCode() {
        int result = this.start.hashCode();
        result = result * 31 + this.end.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Region)) {
            return false;
        }
        Region region = (Region)other;
        if (!Intrinsics.areEqual((Object)this.start, (Object)region.start)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.end, (Object)region.end);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/mineinabyss/deeperworld/world/Region$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/mineinabyss/deeperworld/world/Region;", "deeperworld"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<Region> serializer() {
            return RegionSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

