/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.deeperworld.listeners;

import com.mineinabyss.deeperworld.services.PlayerManagerKt;
import com.mineinabyss.deeperworld.world.section.Section;
import com.mineinabyss.deeperworld.world.section.SectionUtils;
import com.mineinabyss.idofront.location.LocationUtilsKt;
import com.mineinabyss.idofront.messaging.LoggingKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0007J\f\u0010\u0007\u001a\u00020\u0005*\u00020\bH\u0007J\f\u0010\t\u001a\u00020\u0005*\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/mineinabyss/deeperworld/listeners/PlayerListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onPlayerTeleport", "", "Lorg/bukkit/event/player/PlayerTeleportEvent;", "onEnterVehicle", "Lorg/bukkit/event/vehicle/VehicleEnterEvent;", "onExitVehicle", "Lorg/bukkit/event/vehicle/VehicleExitEvent;", "deeperworld"})
public final class PlayerListener
implements Listener {
    @NotNull
    public static final PlayerListener INSTANCE = new PlayerListener();

    private PlayerListener() {
    }

    @EventHandler
    public final void onPlayerTeleport(@NotNull PlayerTeleportEvent $this$onPlayerTeleport) {
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)$this$onPlayerTeleport, (String)"<this>");
                if ($this$onPlayerTeleport.getPlayer().getGameMode() == GameMode.CREATIVE) break block7;
                Player player = $this$onPlayerTeleport.getPlayer();
                Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
                if (PlayerManagerKt.getCanMoveSections(player)) break block8;
            }
            return;
        }
        if ($this$onPlayerTeleport.getCause() != PlayerTeleportEvent.TeleportCause.ENDER_PEARL && $this$onPlayerTeleport.getCause() != PlayerTeleportEvent.TeleportCause.CONSUMABLE_EFFECT) {
            return;
        }
        Location location = $this$onPlayerTeleport.getTo();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getTo(...)");
        if (SectionUtils.getSection(location) != null) {
            Location location2 = $this$onPlayerTeleport.getTo();
            Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"getTo(...)");
            Section section = SectionUtils.getSection(location2);
            Location location3 = $this$onPlayerTeleport.getPlayer().getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location3, (String)"getLocation(...)");
            if (Intrinsics.areEqual((Object)section, (Object)SectionUtils.getSection(location3))) {
                Location location4 = $this$onPlayerTeleport.getTo();
                Intrinsics.checkNotNullExpressionValue((Object)location4, (String)"getTo(...)");
                if (!SectionUtils.getInSectionTransition(location4)) {
                    return;
                }
            }
        }
        Player player = $this$onPlayerTeleport.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        LoggingKt.error((CommandSender)((CommandSender)player), (Object)"Teleportation is disabled between Layers and Sections.");
        $this$onPlayerTeleport.setCancelled(true);
    }

    @EventHandler
    public final void onEnterVehicle(@NotNull VehicleEnterEvent $this$onEnterVehicle) {
        Intrinsics.checkNotNullParameter((Object)$this$onEnterVehicle, (String)"<this>");
        Location location = $this$onEnterVehicle.getVehicle().getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        if (SectionUtils.getSection(LocationUtilsKt.up((Location)location, (Number)1)) != null) {
            return;
        }
        Entity entity = $this$onEnterVehicle.getEntered();
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getEntered(...)");
        LoggingKt.error((CommandSender)((CommandSender)entity), (Object)"The Abyss prevents you from mounting here...");
        $this$onEnterVehicle.setCancelled(true);
    }

    @EventHandler
    public final void onExitVehicle(@NotNull VehicleExitEvent $this$onExitVehicle) {
        Intrinsics.checkNotNullParameter((Object)$this$onExitVehicle, (String)"<this>");
        Location location = $this$onExitVehicle.getVehicle().getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        if (SectionUtils.getSection(LocationUtilsKt.up((Location)location, (Number)1)) != null) {
            return;
        }
        LivingEntity livingEntity = $this$onExitVehicle.getExited();
        Intrinsics.checkNotNullExpressionValue((Object)livingEntity, (String)"getExited(...)");
        LoggingKt.error((CommandSender)((CommandSender)livingEntity), (Object)"The Abyss prevents you from dismounting here...");
        $this$onExitVehicle.setCancelled(true);
    }
}

