package com.mineinabyss.deeperworld.synchronization

import com.mineinabyss.deeperworld.world.section.correspondingLocation
import com.mineinabyss.deeperworld.world.section.correspondingSection
import com.mineinabyss.deeperworld.world.section.inSectionOverlap
import io.papermc.paper.event.block.BlockBreakBlockEvent
import org.bukkit.Material
import org.bukkit.block.Block
import org.bukkit.event.EventHandler
import org.bukkit.event.Listener
import org.bukkit.event.block.BlockPistonExtendEvent
import org.bukkit.event.block.BlockPistonRetractEvent

object ExploitPreventionListener : Listener {

    @EventHandler(ignoreCancelled = true)
    fun BlockPistonExtendEvent.onPistonExtendEvent() {
        //TODO handle pistons properly instead of just cancelling the event
        if (blocks.any { it.location.correspondingSection != null })
            isCancelled = true
//        val corrBlock = block.location.correspondingLocation?.block ?: return
//        val corrBlocks = mutableListOf<Block>()
//
//        if (blocks.all { b -> !b.location.inSectionOverlap }) return
//        if (!corrBlock.location.isChunkLoaded) corrBlock.chunk.load()
//        corrBlocks.addAll(blocks.map { b -> b.location.correspondingLocation?.block ?: return@map null }.filterNotNull())
//        BlockPistonExtendEvent(corrBlock, corrBlocks, direction).callEvent()
    }

    @EventHandler(ignoreCancelled = true)
    fun BlockPistonRetractEvent.onPistonRetractEvent() {
        //TODO handle pistons properly instead of just cancelling the event
        if (blocks.any { it.location.correspondingSection != null })
            isCancelled = true
//        val corrBlock = block.location.correspondingLocation?.block ?: return
//        val corrBlocks = mutableListOf<Block>()
//
//        if (blocks.all { b -> !b.location.inSectionOverlap }) return
//        if (!corrBlock.location.isChunkLoaded) corrBlock.chunk.load()
//
//        corrBlocks.addAll(blocks.map { b -> b.location.correspondingLocation?.block ?: return@map null }.filterNotNull())
//        BlockPistonRetractEvent(corrBlock, corrBlocks, direction).callEvent()
    }

    @EventHandler
    fun BlockBreakBlockEvent.onPistonBreakBlock() {
        val corrBlock = block.location.correspondingLocation?.block ?: return
        source.location.correspondingLocation?.block ?: return
        corrBlock.setType(Material.AIR, false)
    }
}
