/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.chatty.listeners;

import com.mineinabyss.chatty.ChattyChannel;
import com.mineinabyss.chatty.ChattyContextKt;
import com.mineinabyss.chatty.components.ChannelData;
import com.mineinabyss.chatty.components.ChannelType;
import com.mineinabyss.chatty.helpers.ChatHelpersKt;
import com.mineinabyss.chatty.queries.SpyingPlayersQuery;
import com.mineinabyss.geary.datatypes.Entity;
import com.mineinabyss.geary.engine.archetypes.Archetype;
import com.mineinabyss.geary.helpers.EngineHelpersKt;
import com.mineinabyss.geary.modules.Geary;
import com.mineinabyss.geary.papermc.tracking.entities.ConversionKt;
import com.mineinabyss.geary.systems.accessors.type.ComponentAccessor;
import com.mineinabyss.geary.systems.query.CachedQuery;
import com.mineinabyss.geary.systems.query.QueriedEntity;
import com.mineinabyss.geary.systems.query.Query;
import com.mineinabyss.idofront.textcomponents.MiniMessageHelpersKt;
import github.scarsz.discordsrv.Debug;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.jda.api.Permission;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Guild;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageEmbed;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import github.scarsz.discordsrv.util.DiscordUtil;
import github.scarsz.discordsrv.util.MessageUtil;
import github.scarsz.discordsrv.util.PlaceholderUtil;
import github.scarsz.discordsrv.util.WebhookUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010J\f\u0010\u0013\u001a\u00020\u0007*\u00020\u0007H\u0002R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/mineinabyss/chatty/listeners/ChattyProxyListener;", "Lorg/bukkit/plugin/messaging/PluginMessageListener;", "<init>", "()V", "onPluginMessageReceived", "", "ch", "", "player", "Lorg/bukkit/entity/Player;", "byteArray", "", "sendToDiscord", "message", "senderName", "channel", "Lcom/mineinabyss/chatty/ChattyChannel;", "translateMentions", "", "translateEmoteIDsToComponent", "chatty-paper"})
@SourceDebugExtension(value={"SMAP\nChattyProxyListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChattyProxyListener.kt\ncom/mineinabyss/chatty/listeners/ChattyProxyListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CachedQuery.kt\ncom/mineinabyss/geary/systems/query/CachedQuery\n+ 4 Iteration.kt\ncom/mineinabyss/geary/helpers/IterationKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 Entity.kt\ncom/mineinabyss/geary/datatypes/Entity\n*L\n1#1,117:1\n777#2:118\n873#2,2:119\n1642#2,10:153\n1915#2:163\n1916#2:165\n1652#2:166\n777#2:167\n873#2,2:168\n777#2:170\n873#2:171\n874#2:177\n1915#2,2:178\n1915#2,2:180\n177#3,2:121\n27#3,15:123\n42#3,2:141\n180#3:143\n181#3:145\n44#3,6:146\n182#3:152\n12#4,3:138\n1#5:144\n1#5:164\n147#6,5:172\n*S KotlinDebug\n*F\n+ 1 ChattyProxyListener.kt\ncom/mineinabyss/chatty/listeners/ChattyProxyListener\n*L\n36#1:118\n36#1:119,2\n40#1:153,10\n40#1:163\n40#1:165\n40#1:166\n50#1:167\n50#1:168,2\n51#1:170\n51#1:171\n51#1:177\n54#1:178,2\n109#1:180,2\n38#1:121,2\n38#1:123,15\n38#1:141,2\n38#1:143\n38#1:145\n38#1:146,6\n38#1:152\n38#1:138,3\n40#1:164\n52#1:172,5\n*E\n"})
public final class ChattyProxyListener
implements PluginMessageListener {
    private final boolean translateMentions = !ChattyContextKt.getChatty().isDiscordSRVLoaded() ? false : DiscordSRV.config().getBoolean("DiscordChatChannelTranslateMentions");

    /*
     * WARNING - void declaration
     */
    public void onPluginMessageReceived(@NotNull String ch, @NotNull Player player, @NotNull byte[] byteArray) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        if (!(Intrinsics.areEqual((Object)ch, (Object)"chatty:proxy") || Intrinsics.areEqual((Object)ch, (Object)"chatty:discordsrv") && !ChattyContextKt.getChatty().isDiscordSRVLoaded())) {
            return;
        }
        Component component = ChatHelpersKt.getGson().deserialize((Object)StringsKt.decodeToString((byte[])byteArray));
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"deserialize(...)");
        Component decoded = component;
        Object e = decoded.children().get(0);
        Object object = e instanceof TextComponent ? (TextComponent)e : null;
        if (object == null || (object = object.content()) == null) {
            return;
        }
        Object senderName = object;
        Object e2 = decoded.children().get(1);
        Object object2 = e2 instanceof TextComponent ? (TextComponent)e2 : null;
        if (object2 == null || (object2 = object2.content()) == null) {
            return;
        }
        Object channelId = object2;
        Component component2 = (Component)decoded.children().get(2);
        if (component2 == null) {
            return;
        }
        Component message = component2;
        Component component3 = (Component)decoded.children().get(3);
        if (component3 == null) {
            return;
        }
        Component simpleMessage = component3;
        ChattyChannel channel = ChattyContextKt.getChatty().getConfig().getChannels().get(channelId);
        Collection collection = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getOnlinePlayers(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Player it = (Player)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getServer(), (Object)Bukkit.getServer())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List onlinePlayers = (List)destination$iv$iv;
        Object this_$iv = ChattyContextKt.getChatty().getSpyingPlayers();
        boolean $i$f$mapWithEntity = false;
        List deferred$iv = new ArrayList();
        CachedQuery<SpyingPlayersQuery> this_$iv$iv = this_$iv;
        boolean $i$f$forEach = false;
        List matched$iv$iv = this_$iv$iv.getMatchedArchetypes();
        int size$iv$iv = matched$iv$iv.size();
        Query accessors$iv$iv = this_$iv$iv.getCachingAccessors();
        for (int n$iv$iv = 0; n$iv$iv < size$iv$iv; ++n$iv$iv) {
            Archetype archetype$iv$iv = (Archetype)matched$iv$iv.get(n$iv$iv);
            int upTo$iv$iv = archetype$iv$iv.getSize();
            int row$iv$iv = 0;
            this_$iv$iv.getQuery().row = 0;
            this_$iv$iv.getQuery().archetype = archetype$iv$iv;
            Query $this$fastForEach$iv$iv$iv = accessors$iv$iv;
            int $i$f$fastForEach = 0;
            int n$iv$iv$iv = 0;
            while (n$iv$iv$iv < ((ComponentAccessor[])$this$fastForEach$iv$iv$iv).length) {
                ComponentAccessor it$iv$iv = $this$fastForEach$iv$iv$iv[n$iv$iv$iv++];
                boolean bl = false;
                it$iv$iv.updateCache(archetype$iv$iv);
            }
            while (row$iv$iv < upTo$iv$iv) {
                void q;
                Player player2;
                Query it$iv = this_$iv$iv.getQuery();
                boolean bl = false;
                SpyingPlayersQuery spyingPlayersQuery = (SpyingPlayersQuery)it$iv;
                List list = deferred$iv;
                boolean bl2 = false;
                Player it = player2 = q.getPlayer();
                boolean bl3 = false;
                Entity entity = new Entity(((QueriedEntity)it$iv).getUnsafeEntity-s-VKNKU(), ((QueriedEntity)it$iv).getWorld(), null);
                Player player3 = q.getSpying().getChannels().contains(channelId) ? player2 : null;
                list.add(new CachedQuery.Deferred((Object)player3, entity));
                $this$fastForEach$iv$iv$iv = this_$iv$iv.getQuery();
                $i$f$fastForEach = $this$fastForEach$iv$iv$iv.row;
                $this$fastForEach$iv$iv$iv.row = $i$f$fastForEach + 1;
                ++row$iv$iv;
            }
        }
        this_$iv = deferred$iv;
        boolean $i$f$mapNotNull = false;
        deferred$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Player it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            CachedQuery.Deferred it = (CachedQuery.Deferred)element$iv$iv;
            boolean bl4 = false;
            if ((Player)it.getData() == null) continue;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List canSpy = (List)destination$iv$iv2;
        if (channel != null) {
            void $this$forEach$iv;
            if (channel.getLogToConsole()) {
                Bukkit.getConsoleSender().sendMessage(simpleMessage);
            }
            $this$mapNotNull$iv = switch (WhenMappings.$EnumSwitchMapping$0[channel.getChannelType().ordinal()]) {
                case 1 -> onlinePlayers;
                case 2 -> canSpy;
                case 3 -> {
                    Player it;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = onlinePlayers;
                    boolean $i$f$filter = false;
                    Iterable $i$f$mapNotNullTo = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        it = (Player)element$iv$iv;
                        boolean $i$a$-filter-ChattyProxyListener$onPluginMessageReceived$1 = false;
                        if (!(it.hasPermission(channel.getPermission()) || canSpy.contains(it))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    yield (List)destination$iv$iv;
                }
                case 4 -> {
                    Player it;
                    Iterable $this$filter$iv = onlinePlayers;
                    boolean $i$f$filter = false;
                    Iterable $this$filterTo$iv$iv = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        void this_$iv$iv;
                        it = (Player)element$iv$iv;
                        boolean $i$a$-filter-ChattyProxyListener$onPluginMessageReceived$2 = false;
                        Intrinsics.checkNotNull((Object)it);
                        Entity this_$iv = ConversionKt.toGeary((org.bukkit.entity.Entity)((org.bukkit.entity.Entity)it));
                        boolean $i$f$get = false;
                        Entity it$iv$iv = this_$iv;
                        KClass kClass$iv$iv = Reflection.getOrCreateKotlinClass(ChannelData.class);
                        boolean $i$f$get = false;
                        Object v7 = this_$iv$iv.get-VKZWuLQ(EngineHelpersKt.componentId((Geary)this_$iv$iv.getWorld(), (KClassifier)((KClassifier)kClass$iv$iv)));
                        if (!(v7 instanceof ChannelData)) {
                            v7 = null;
                        }
                        ChannelData v8 = (ChannelData)v7;
                        ChannelData v9 = v8;
                        if (!(Intrinsics.areEqual((Object)(v8 != null && (v9 = v9.withChannelVerified()) != null ? v9.getChannel() : null), (Object)channel) || canSpy.contains(it))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    yield (List)destination$iv$iv;
                }
                default -> throw new NoWhenBranchMatchedException();
            };
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv) {
                Player it = (Player)element$iv;
                boolean bl = false;
                it.sendMessage(message);
            }
        }
        if (ChattyContextKt.getChatty().getConfig().getProxy().getProxyToDiscord()) {
            ChattyChannel chattyChannel = channel;
            boolean bl = chattyChannel != null ? chattyChannel.getDiscordsrv() : false;
            if (bl && ChattyContextKt.getChatty().isDiscordSRVLoaded()) {
                this.sendToDiscord(MiniMessageHelpersKt.serialize((Component)message), (String)senderName, channel);
            }
        }
    }

    public final void sendToDiscord(@NotNull String message, @NotNull String senderName, @NotNull ChattyChannel channel) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)senderName, (String)"senderName");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        boolean reserializer = DiscordSRV.config().getBoolean("Experiment_MCDiscordReserializer_ToDiscord");
        TextChannel discordChannel = DiscordSRV.getPlugin().getDestinationTextChannelForGameChannelName(ChattyContextKt.getChatty().getConfig().getProxy().getDiscordSrvChannelID());
        if (discordChannel == null) {
            DiscordSRV.debug((Debug)Debug.MINECRAFT_TO_DISCORD, (String)("Failed to find Discord channel to forward message from game channel " + channel));
        } else if (!DiscordUtil.checkPermission((Guild)discordChannel.getGuild(), (Permission)Permission.MANAGE_WEBHOOKS)) {
            DiscordSRV.error((String)"Couldn't deliver chat message as webhook because the bot lacks the \"Manage Webhooks\" permission.");
        } else {
            String $this$sendToDiscord_u24lambda_u240 = message;
            boolean bl = false;
            String $this$sendToDiscord_u24lambda_u241 = PlaceholderUtil.replacePlaceholdersToDiscord((String)$this$sendToDiscord_u24lambda_u240);
            boolean bl2 = false;
            String $this$sendToDiscord_u24lambda_u242 = !reserializer ? MessageUtil.strip((String)$this$sendToDiscord_u24lambda_u241) : $this$sendToDiscord_u24lambda_u241;
            boolean $i$a$-run-ChattyProxyListener$sendToDiscord$discordMessage$42 = false;
            String discordMessage = this.translateMentions ? DiscordUtil.convertMentionsFromNames((String)$this$sendToDiscord_u24lambda_u242, (Guild)DiscordSRV.getPlugin().getMainGuild()) : $this$sendToDiscord_u24lambda_u242;
            String string = DiscordSRV.config().getString("Experiment_WebhookChatMessageUsernameFormat");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            CharSequence charSequence = string;
            String $i$a$-run-ChattyProxyListener$sendToDiscord$discordMessage$42 = "(%displayname%)|(%username%)";
            String it = new Regex($i$a$-run-ChattyProxyListener$sendToDiscord$discordMessage$42).replace(charSequence, senderName);
            boolean bl3 = false;
            String whUsername = MessageUtil.strip((String)PlaceholderUtil.replacePlaceholders((String)it));
            Player player = ChatHelpersKt.toPlayer(senderName);
            String string2 = DiscordSRV.getAvatarUrl((String)senderName, (UUID)(player != null ? player.getUniqueId() : null));
            Intrinsics.checkNotNull((Object)discordMessage);
            WebhookUtil.deliverMessage((TextChannel)discordChannel, (String)whUsername, (String)string2, (String)this.translateEmoteIDsToComponent(discordMessage), (MessageEmbed)new MessageEmbed(null, null, null, null, null, 10, null, null, null, null, null, null, null));
        }
    }

    private final String translateEmoteIDsToComponent(String $this$translateEmoteIDsToComponent) {
        String translated = null;
        translated = $this$translateEmoteIDsToComponent;
        Iterable $this$forEach$iv = ChattyContextKt.getChatty().getEmotefixer().getEmotes().entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            String emoteId = (String)entry.getKey();
            String replacement = (String)entry.getValue();
            String id = ":" + emoteId + ":";
            if (!StringsKt.contains$default((CharSequence)translated, (CharSequence)id, (boolean)false, (int)2, null)) continue;
            translated = StringsKt.replace$default((String)translated, (String)id, (String)("<" + replacement), (boolean)false, (int)4, null);
        }
        return StringsKt.replace$default((String)translated, (String)"<<", (String)"<", (boolean)false, (int)4, null);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ChannelType.values().length];
            try {
                nArray[ChannelType.GLOBAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChannelType.RADIUS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChannelType.PERMISSION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChannelType.CUSTOM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

