/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.bonfire.listeners;

import com.mineinabyss.blocky.helpers.GenericHelpers;
import com.mineinabyss.bonfire.BonfireContextKt;
import com.mineinabyss.bonfire.components.Bonfire;
import com.mineinabyss.bonfire.components.BonfireDebug;
import com.mineinabyss.bonfire.extensions.BonfireHelpersKt;
import com.mineinabyss.geary.datatypes.Entity;
import com.mineinabyss.geary.helpers.EngineHelpersKt;
import com.mineinabyss.geary.modules.Geary;
import com.mineinabyss.geary.papermc.tracking.entities.ConversionKt;
import com.mineinabyss.idofront.entities.PlayersKt;
import com.mineinabyss.idofront.textcomponents.MiniMessageHelpersKt;
import io.papermc.paper.adventure.PaperAdventure;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0007J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0007H\u0007J\u0014\u0010\u000e\u001a\u00020\u0005*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0014\u0012\u0012\u0012\b\u0012\u00060\nj\u0002`\u000b\u0012\u0004\u0012\u00020\f0\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/mineinabyss/bonfire/listeners/DebugListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onDebugToggle", "", "Lorg/bukkit/event/player/PlayerToggleSneakEvent;", "Lorg/bukkit/event/player/PlayerGameModeChangeEvent;", "debugIdMap", "", "Ljava/util/UUID;", "Lcom/mineinabyss/blocky/helpers/FurnitureUUID;", "", "backgroundColor", "sendDebugTextDisplay", "Lorg/bukkit/entity/Player;", "baseEntity", "Lorg/bukkit/entity/ItemDisplay;", "removeDebugTextDisplay", "player", "createDebugText", "", "bonfire", "Lcom/mineinabyss/bonfire/components/Bonfire;"})
@SourceDebugExtension(value={"SMAP\nDebugListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugListener.kt\ncom/mineinabyss/bonfire/listeners/DebugListener\n+ 2 Entity.kt\ncom/mineinabyss/geary/datatypes/Entity\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,86:1\n173#2,5:87\n173#2,5:95\n147#2,5:107\n774#3:92\n865#3,2:93\n381#4,7:100\n*S KotlinDebug\n*F\n+ 1 DebugListener.kt\ncom/mineinabyss/bonfire/listeners/DebugListener\n*L\n40#1:87,5\n47#1:95,5\n63#1:107,5\n40#1:92\n40#1:93,2\n57#1:100,7\n*E\n"})
public final class DebugListener
implements Listener {
    @NotNull
    private final Map<UUID, Map<UUID, Integer>> debugIdMap = new LinkedHashMap();
    private final int backgroundColor = Color.fromARGB((int)0, (int)0, (int)0, (int)0).asARGB();

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public final void onDebugToggle(@NotNull PlayerToggleSneakEvent $this$onDebugToggle) {
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$onDebugToggle, (String)"<this>");
        Player player = $this$onDebugToggle.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Object this_$iv = ConversionKt.toGeary((org.bukkit.entity.Entity)((org.bukkit.entity.Entity)player));
        boolean $i$f$has = false;
        Entity entity = this_$iv;
        KClass kClass$iv$iv = Reflection.getOrCreateKotlinClass(BonfireDebug.class);
        boolean $i$f$has2 = false;
        if (this_$iv$iv.has-VKZWuLQ(EngineHelpersKt.componentId((Geary)this_$iv$iv.getWorld(), (KClassifier)((KClassifier)kClass$iv$iv))) && $this$onDebugToggle.isSneaking()) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            List list = $this$onDebugToggle.getPlayer().getWorld().getEntities();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntities(...)");
            this_$iv = list;
            Player player2 = $this$onDebugToggle.getPlayer();
            boolean $i$f$filter = false;
            kClass$iv$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                org.bukkit.entity.Entity p0 = (org.bukkit.entity.Entity)element$iv$iv;
                boolean bl = false;
                if (!player2.canSee(p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            BonfireHelpersKt.forEachBonfire((List)destination$iv$iv, (Function1<? super ItemDisplay, Unit>)((Function1)arg_0 -> DebugListener.onDebugToggle$lambda$0(this, $this$onDebugToggle, arg_0)));
        } else {
            Player player3 = $this$onDebugToggle.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)player3, (String)"getPlayer(...)");
            this.removeDebugTextDisplay(player3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public final void onDebugToggle(@NotNull PlayerGameModeChangeEvent $this$onDebugToggle) {
        void this_$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$onDebugToggle, (String)"<this>");
        Player player = $this$onDebugToggle.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Entity this_$iv = ConversionKt.toGeary((org.bukkit.entity.Entity)((org.bukkit.entity.Entity)player));
        boolean $i$f$has = false;
        Entity entity = this_$iv;
        KClass kClass$iv$iv = Reflection.getOrCreateKotlinClass(BonfireDebug.class);
        boolean $i$f$has2 = false;
        if (this_$iv$iv.has-VKZWuLQ(EngineHelpersKt.componentId((Geary)this_$iv$iv.getWorld(), (KClassifier)((KClassifier)kClass$iv$iv))) && $this$onDebugToggle.getNewGameMode() == GameMode.SPECTATOR) {
            List list = $this$onDebugToggle.getPlayer().getNearbyEntities(16.0, 16.0, 16.0);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getNearbyEntities(...)");
            BonfireHelpersKt.forEachBonfire(list, (Function1<? super ItemDisplay, Unit>)((Function1)arg_0 -> DebugListener.onDebugToggle$lambda$1(this, $this$onDebugToggle, arg_0)));
        } else {
            Player player2 = $this$onDebugToggle.getPlayer();
            Intrinsics.checkNotNullExpressionValue((Object)player2, (String)"getPlayer(...)");
            this.removeDebugTextDisplay(player2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void sendDebugTextDisplay(Player $this$sendDebugTextDisplay, ItemDisplay baseEntity) {
        Object object;
        ClientboundAddEntityPacket textEntityPacket;
        int entityId;
        block8: {
            block7: {
                void this_$iv$iv;
                Object object2;
                void $this$getOrPut$iv;
                Map entityIds;
                Location location = baseEntity.getLocation().clone();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"clone(...)");
                Location location2 = GenericHelpers.INSTANCE.toBlockCenterLocation(location).add(BonfireContextKt.getBonfire().getConfig().getDebugTextOffset());
                Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"add(...)");
                Location loc = location2;
                Map map2 = this.debugIdMap.computeIfAbsent($this$sendDebugTextDisplay.getUniqueId(), arg_0 -> DebugListener.sendDebugTextDisplay$lambda$3(arg_0 -> DebugListener.sendDebugTextDisplay$lambda$2(baseEntity, arg_0), arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"computeIfAbsent(...)");
                Map map3 = entityIds = map2;
                UUID key$iv = baseEntity.getUniqueId();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Integer answer$iv = net.minecraft.world.entity.Entity.nextEntityId();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                entityId = ((Number)object2).intValue();
                textEntityPacket = new ClientboundAddEntityPacket(entityId, UUID.randomUUID(), loc.getX(), loc.getY(), loc.getZ(), loc.getPitch(), loc.getYaw(), EntityType.TEXT_DISPLAY, 0, Vec3.ZERO, 0.0);
                object = ConversionKt.toGearyOrNull((org.bukkit.entity.Entity)((org.bukkit.entity.Entity)baseEntity));
                if (object == null) break block7;
                Entity this_$iv = object;
                boolean $i$f$get = false;
                Entity entity = this_$iv;
                KClass kClass$iv$iv = Reflection.getOrCreateKotlinClass(Bonfire.class);
                boolean $i$f$get2 = false;
                Object object3 = this_$iv$iv.get-VKZWuLQ(EngineHelpersKt.componentId((Geary)this_$iv$iv.getWorld(), (KClassifier)((KClassifier)kClass$iv$iv)));
                if (!(object3 instanceof Bonfire)) {
                    object3 = null;
                }
                Bonfire bonfire = (Bonfire)object3;
                object = bonfire;
                if (bonfire != null) break block8;
            }
            return;
        }
        net.minecraft.network.chat.Component component = PaperAdventure.asVanilla((Component)MiniMessageHelpersKt.miniMsg$default((String)this.createDebugText((Bonfire)object), null, (int)1, null));
        if (component == null) {
            component = (net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.empty();
        }
        net.minecraft.network.chat.Component text = component;
        Object[] objectArray = new SynchedEntityData.DataValue[]{new SynchedEntityData.DataValue(15, EntityDataSerializers.BYTE, (Object)1), new SynchedEntityData.DataValue(23, EntityDataSerializers.COMPONENT, (Object)text), new SynchedEntityData.DataValue(25, EntityDataSerializers.INT, (Object)this.backgroundColor), new SynchedEntityData.DataValue(27, EntityDataSerializers.BYTE, (Object)1)};
        ClientboundSetEntityDataPacket textMetaPacket = new ClientboundSetEntityDataPacket(entityId, CollectionsKt.listOf((Object[])objectArray));
        Player player = $this$sendDebugTextDisplay.getPlayer();
        Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type org.bukkit.craftbukkit.entity.CraftPlayer");
        objectArray = new Packet[]{textEntityPacket, textMetaPacket};
        ((CraftPlayer)player).getHandle().connection.send((Packet)new ClientboundBundlePacket((Iterable)CollectionsKt.listOf((Object[])objectArray)));
    }

    private final void removeDebugTextDisplay(Player player) {
        Map<UUID, Integer> map2;
        block3: {
            block2: {
                map2 = this.debugIdMap.remove(player.getUniqueId());
                if (map2 == null || (map2 = map2.values()) == null) break block2;
                int[] nArray = CollectionsKt.toIntArray((Collection)((Object)map2));
                map2 = (Map<UUID, Integer>)nArray;
                if (nArray != null) break block3;
            }
            return;
        }
        Map<UUID, Integer> map3 = map2;
        IntList ids = IntList.of((int[])Arrays.copyOf((int[])map3, ((Object)map3).length));
        Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type org.bukkit.craftbukkit.entity.CraftPlayer");
        ((CraftPlayer)player).getHandle().connection.send((Packet)new ClientboundRemoveEntitiesPacket(ids));
    }

    private final String createDebugText(Bonfire bonfire) {
        return StringsKt.trimIndent((String)("\n        <yellow>Bonfire-size <gold>" + bonfire.getBonfirePlayers().size() + "/" + bonfire.getMaxPlayerCount() + "\n        <gray>Players: " + CollectionsKt.joinToString$default((Iterable)bonfire.getBonfirePlayers(), null, null, null, (int)0, null, DebugListener::createDebugText$lambda$5, (int)31, null) + "\n    "));
    }

    private static final Unit onDebugToggle$lambda$0(DebugListener this$0, PlayerToggleSneakEvent $this_onDebugToggle, ItemDisplay it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Player player = $this_onDebugToggle.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        this$0.sendDebugTextDisplay(player, it);
        return Unit.INSTANCE;
    }

    private static final Unit onDebugToggle$lambda$1(DebugListener this$0, PlayerGameModeChangeEvent $this_onDebugToggle, ItemDisplay it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Player player = $this_onDebugToggle.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        this$0.sendDebugTextDisplay(player, it);
        return Unit.INSTANCE;
    }

    private static final Map sendDebugTextDisplay$lambda$2(ItemDisplay $baseEntity, UUID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)$baseEntity.getUniqueId(), (Object)net.minecraft.world.entity.Entity.nextEntityId())};
        return MapsKt.mutableMapOf((Pair[])pairArray);
    }

    private static final Map sendDebugTextDisplay$lambda$3(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }

    private static final CharSequence createDebugText$lambda$5(UUID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return String.valueOf(PlayersKt.toOfflinePlayer((UUID)it).getName());
    }
}

