/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.blocky.components.core;

import androidx.compose.runtime.internal.StabilityInferred;
import com.destroystokyo.paper.ParticleBuilder;
import com.mineinabyss.blocky.components.core.VanillaNoteBlock$;
import com.mineinabyss.blocky.components.features.blocks.BlockyInstrument;
import com.mineinabyss.blocky.helpers.GenericHelpers;
import com.mineinabyss.blocky.helpers.GenericHelpersKt;
import com.mineinabyss.blocky.helpers.NoteBlockHelpersKt;
import com.mineinabyss.geary.datatypes.Entity;
import com.mineinabyss.geary.helpers.EngineHelpersKt;
import com.mineinabyss.geary.modules.Geary;
import com.mineinabyss.geary.papermc.datastore.DataStoreKt;
import com.mineinabyss.geary.papermc.tracking.blocks.helpers.HelpersKt;
import com.mineinabyss.idofront.location.LocationUtilsKt;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialName;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import org.bukkit.GameEvent;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.persistence.PersistentDataContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@SerialName(value="blocky:vanilla_note_block")
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 /2\u00020\u0001:\u0002./B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B+\b\u0010\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0006\u0010\u000bJ3\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u00020\u000ej\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0016J\u0006\u0010\u0004\u001a\u00020\u0005J'\u0010\u0004\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0005R\u00020\u000ej\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0018J\u0006\u0010\u0002\u001a\u00020\u0003J'\u0010\u0002\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003R\u00020\u000ej\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0019J-\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002R\u00020\u000ej\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001d\u0010\u001d\u001a\u00020\u001e*\u00020\u0011H\u0002R\u00020\u000ej\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u001fJ\t\u0010 \u001a\u00020\u0003H\u00c2\u0003J\t\u0010!\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010#\u001a\u00020\u00052\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010%\u001a\u00020\u0003H\u00d6\u0081\u0004J\n\u0010&\u001a\u00020\u001eH\u00d6\u0081\u0004J%\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0001\u00a2\u0006\u0002\b-R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/mineinabyss/blocky/components/core/VanillaNoteBlock;", "", "note", "", "powered", "", "<init>", "(IZ)V", "seen0", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IIZLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "interact", "", "Lcom/mineinabyss/geary/modules/Geary;", "Geary", "block", "Lorg/bukkit/block/Block;", "source", "Lorg/bukkit/entity/Player;", "action", "Lorg/bukkit/event/block/Action;", "(Lcom/mineinabyss/geary/modules/Geary;Lorg/bukkit/block/Block;Lorg/bukkit/entity/Player;Lorg/bukkit/event/block/Action;)V", "state", "(Lcom/mineinabyss/geary/modules/Geary;Lorg/bukkit/block/Block;Z)V", "(Lcom/mineinabyss/geary/modules/Geary;Lorg/bukkit/block/Block;I)V", "playSoundNaturally", "(Lcom/mineinabyss/geary/modules/Geary;Lorg/bukkit/block/Block;Lorg/bukkit/entity/Player;)V", "isSkullAbove", "instrumentSound", "", "(Lcom/mineinabyss/geary/modules/Geary;Lorg/bukkit/block/Block;)Ljava/lang/String;", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "write$Self", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$blocky", "$serializer", "Companion", "blocky"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nVanillaNoteBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VanillaNoteBlock.kt\ncom/mineinabyss/blocky/components/core/VanillaNoteBlock\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Entity.kt\ncom/mineinabyss/geary/datatypes/Entity\n*L\n1#1,88:1\n1#2:89\n147#3,5:90\n*S KotlinDebug\n*F\n+ 1 VanillaNoteBlock.kt\ncom/mineinabyss/blocky/components/core/VanillaNoteBlock\n*L\n80#1:90,5\n*E\n"})
public final class VanillaNoteBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int note;
    private boolean powered;
    public static final int $stable = 8;

    public VanillaNoteBlock(int note, boolean powered) {
        this.note = note;
        this.powered = powered;
    }

    public /* synthetic */ VanillaNoteBlock(int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        this(n, bl);
    }

    public final void interact(@NotNull Geary $context_receiver_0, @NotNull Block block, @Nullable Player source, @NotNull Action action) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.playSoundNaturally($context_receiver_0, block, source);
        if (action == Action.RIGHT_CLICK_BLOCK) {
            this.note($context_receiver_0, block, (this.note + 1) % 25);
        }
    }

    public static /* synthetic */ void interact$default(VanillaNoteBlock vanillaNoteBlock, Geary geary, Block block, Player player, Action action, int n, Object object) {
        if ((n & 4) != 0) {
            player = null;
        }
        vanillaNoteBlock.interact(geary, block, player, action);
    }

    public final boolean powered() {
        return this.powered;
    }

    public final void powered(@NotNull Geary $context_receiver_0, @NotNull Block block, boolean state) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        if (this.powered == state || !NoteBlockHelpersKt.isVanillaNoteBlock(block)) {
            return;
        }
        this.powered = state;
        DataStoreKt.encode$default((Geary)$context_receiver_0, (PersistentDataContainer)GenericHelpersKt.getPersistentDataContainer(block), (Object)this, null, null, (int)12, null);
    }

    public final int note() {
        return this.note;
    }

    public final void note(@NotNull Geary $context_receiver_0, @NotNull Block block, int note) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        if (this.note == note || !NoteBlockHelpersKt.isVanillaNoteBlock(block)) {
            return;
        }
        this.note = note;
        DataStoreKt.encode$default((Geary)$context_receiver_0, (PersistentDataContainer)GenericHelpersKt.getPersistentDataContainer(block), (Object)this, null, null, (int)12, null);
    }

    private final void playSoundNaturally(Geary $context_receiver_0, Block block, Player source) {
        double particleColor = (double)this.note / 24.0;
        String sound = this.instrumentSound($context_receiver_0, block);
        float pitch = (float)Math.pow(2.0f, ((float)this.note - 12.0f) / 12.0f);
        World world = block.getWorld();
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorld(...)");
        World world2 = world;
        boolean isSkullAbove = this.isSkullAbove(block);
        Location location = block.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        Location loc = GenericHelpers.INSTANCE.toBlockCenterLocation(location);
        if (!block.getRelative(BlockFace.UP).isEmpty() && !isSkullAbove) {
            return;
        }
        if (!isSkullAbove) {
            world2.playSound(loc, sound, 1.0f, pitch);
            ParticleBuilder particleBuilder = Particle.NOTE.builder().count(0).offset(particleColor, 0.0, 0.0).location(LocationUtilsKt.up((Location)loc, (Number)1.2)).receivers(32).spawn();
            Intrinsics.checkNotNull((Object)particleBuilder);
        } else {
            world2.playSound(loc, sound, 1.0f, 1.0f);
        }
        world2.sendGameEvent((org.bukkit.entity.Entity)source, GameEvent.NOTE_BLOCK_PLAY, loc.toVector());
    }

    static /* synthetic */ void playSoundNaturally$default(VanillaNoteBlock vanillaNoteBlock, Geary geary, Block block, Player player, int n, Object object) {
        if ((n & 4) != 0) {
            player = null;
        }
        vanillaNoteBlock.playSoundNaturally(geary, block, player);
    }

    private final boolean isSkullAbove(Block block) {
        BlockState blockState = block.getRelative(BlockFace.UP).getState();
        Intrinsics.checkNotNull((Object)blockState, (String)"null cannot be cast to non-null type org.bukkit.craftbukkit.block.CraftBlockState");
        return ((CraftBlockState)blockState).getHandle().instrument().worksAboveNoteBlock();
    }

    /*
     * WARNING - void declaration
     */
    private final String instrumentSound(Geary $context_receiver_0, Block $this$instrumentSound) {
        Object object;
        String instrumentAbove;
        block6: {
            Object object2;
            Object it;
            block5: {
                void this_$iv$iv;
                Identifier identifier;
                NoteBlockInstrument noteBlockInstrument;
                BlockState blockState = $this$instrumentSound.getRelative(BlockFace.UP).getState();
                Intrinsics.checkNotNull((Object)blockState, (String)"null cannot be cast to non-null type org.bukkit.craftbukkit.block.CraftBlockState");
                CraftBlockState craftBlockState = (CraftBlockState)blockState;
                BlockState blockState2 = $this$instrumentSound.getRelative(BlockFace.DOWN).getState();
                Intrinsics.checkNotNull((Object)blockState2, (String)"null cannot be cast to non-null type org.bukkit.craftbukkit.block.CraftBlockState");
                Pair pair = TuplesKt.to((Object)craftBlockState, (Object)((CraftBlockState)blockState2));
                CraftBlockState stateAbove = (CraftBlockState)pair.component1();
                CraftBlockState stateBelow = (CraftBlockState)pair.component2();
                it = noteBlockInstrument = stateAbove.getHandle().instrument();
                boolean bl = false;
                NoteBlockInstrument noteBlockInstrument2 = it.worksAboveNoteBlock() ? noteBlockInstrument : null;
                instrumentAbove = noteBlockInstrument2 != null && (noteBlockInstrument = noteBlockInstrument2.getSoundEvent()) != null && (it = noteBlockInstrument.unwrapKey()) != null && (bl = (ResourceKey)OptionalsKt.getOrNull((Optional)it)) != null && (identifier = bl.identifier()) != null ? identifier.getPath() : null;
                it = noteBlockInstrument = stateBelow.getHandle().instrument();
                boolean bl2 = false;
                it = !it.worksAboveNoteBlock() ? noteBlockInstrument : null;
                boolean bl3 = false;
                CraftBlock craftBlock = stateBelow.getBlock();
                Intrinsics.checkNotNullExpressionValue((Object)craftBlock, (String)"getBlock(...)");
                object = HelpersKt.toGearyOrNull((Block)((Block)craftBlock));
                if (object == null) break block5;
                Entity this_$iv = object;
                boolean $i$f$get = false;
                Entity entity = this_$iv;
                KClass kClass$iv$iv = Reflection.getOrCreateKotlinClass(BlockyInstrument.class);
                boolean $i$f$get2 = false;
                Object object3 = this_$iv$iv.get-VKZWuLQ(EngineHelpersKt.componentId((Geary)this_$iv$iv.getWorld(), (KClassifier)((KClassifier)kClass$iv$iv)));
                if (!(object3 instanceof BlockyInstrument)) {
                    object3 = null;
                }
                BlockyInstrument blockyInstrument = (BlockyInstrument)object3;
                object = blockyInstrument;
                if (blockyInstrument != null && (object = ((BlockyInstrument)object).getInstrument()) != null && (object = object.asString()) != null) break block6;
            }
            object = (object2 = it) != null && (object2 = object2.getSoundEvent()) != null && (object2 = object2.unwrapKey()) != null && (object2 = (ResourceKey)OptionalsKt.getOrNull((Optional)object2)) != null && (object2 = object2.identifier()) != null ? object2.getPath() : null;
        }
        Entity instrumentBelow = object;
        String string = instrumentAbove;
        if (string == null && (string = instrumentBelow) == null) {
            String string2 = NoteBlockInstrument.BASS.getSerializedName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSerializedName(...)");
        }
        return string;
    }

    private final int component1() {
        return this.note;
    }

    private final boolean component2() {
        return this.powered;
    }

    @NotNull
    public final VanillaNoteBlock copy(int note, boolean powered) {
        return new VanillaNoteBlock(note, powered);
    }

    public static /* synthetic */ VanillaNoteBlock copy$default(VanillaNoteBlock vanillaNoteBlock, int n, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = vanillaNoteBlock.note;
        }
        if ((n2 & 2) != 0) {
            bl = vanillaNoteBlock.powered;
        }
        return vanillaNoteBlock.copy(n, bl);
    }

    @NotNull
    public String toString() {
        return "VanillaNoteBlock(note=" + this.note + ", powered=" + this.powered + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.note);
        result = result * 31 + Boolean.hashCode(this.powered);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VanillaNoteBlock)) {
            return false;
        }
        VanillaNoteBlock vanillaNoteBlock = (VanillaNoteBlock)other;
        if (this.note != vanillaNoteBlock.note) {
            return false;
        }
        return this.powered == vanillaNoteBlock.powered;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$blocky(VanillaNoteBlock self, CompositeEncoder output, SerialDescriptor serialDesc) {
        if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.note != 0) {
            output.encodeIntElement(serialDesc, 0, self.note);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : self.powered) {
            output.encodeBooleanElement(serialDesc, 1, self.powered);
        }
    }

    public /* synthetic */ VanillaNoteBlock(int seen0, int note, boolean powered, SerializationConstructorMarker serializationConstructorMarker) {
        if ((0 & seen0) != 0) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.note = (seen0 & 1) == 0 ? 0 : note;
        this.powered = (seen0 & 2) == 0 ? false : powered;
    }

    public VanillaNoteBlock() {
        this(0, false, 3, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/mineinabyss/blocky/components/core/VanillaNoteBlock$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/mineinabyss/blocky/components/core/VanillaNoteBlock;", "blocky"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<VanillaNoteBlock> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

