/*
 * Decompiled with CFR 0.152.
 */
package com.mineinabyss.blocky.helpers;

import androidx.compose.runtime.internal.StabilityInferred;
import com.mineinabyss.blocky.api.events.block.BlockyBlockBreakEvent;
import com.mineinabyss.blocky.helpers.GenericHelpersKt;
import com.mineinabyss.geary.datatypes.Entity;
import com.mineinabyss.geary.helpers.EngineHelpersKt;
import com.mineinabyss.geary.modules.Geary;
import com.mineinabyss.geary.papermc.WorldManagerKt;
import com.mineinabyss.geary.papermc.tracking.blocks.Block2Prefab;
import com.mineinabyss.geary.papermc.tracking.blocks.BlockTrackingKt;
import com.mineinabyss.geary.papermc.tracking.blocks.BlockTrackingModule;
import com.mineinabyss.geary.papermc.tracking.blocks.components.SetBlock;
import com.mineinabyss.geary.papermc.tracking.blocks.helpers.HelpersKt;
import com.mineinabyss.geary.papermc.tracking.items.GearyItemProvider;
import com.mineinabyss.geary.papermc.tracking.items.ItemTrackingKt;
import com.mineinabyss.geary.papermc.tracking.items.ItemTrackingModule;
import com.mineinabyss.idofront.nms.nbt.FastItemPDCKt;
import com.nexomc.protectionlib.ProtectionLib;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rR\u00020\nj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u001f\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014R\u00020\nj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lcom/mineinabyss/blocky/helpers/CaveVineHelpers;", "", "<init>", "()V", "defaultBlockData", "Lorg/bukkit/block/data/BlockData;", "Lorg/jetbrains/annotations/NotNull;", "getDefaultBlockData", "()Lorg/bukkit/block/data/BlockData;", "blockyCaveVine", "Lcom/mineinabyss/geary/modules/Geary;", "Geary", "setBlock", "Lcom/mineinabyss/geary/papermc/tracking/blocks/components/SetBlock;", "(Lcom/mineinabyss/geary/modules/Geary;Lcom/mineinabyss/geary/papermc/tracking/blocks/components/SetBlock;)Lorg/bukkit/block/data/BlockData;", "isBlockyCaveVine", "", "block", "Lorg/bukkit/block/Block;", "itemStack", "Lorg/bukkit/inventory/ItemStack;", "(Lcom/mineinabyss/geary/modules/Geary;Lorg/bukkit/inventory/ItemStack;)Z", "breakCaveVineBlock", "player", "Lorg/bukkit/entity/Player;", "blocky"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nCaveVineHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CaveVineHelpers.kt\ncom/mineinabyss/blocky/helpers/CaveVineHelpers\n+ 2 GenericHelpers.kt\ncom/mineinabyss/blocky/helpers/GenericHelpersKt\n+ 3 Entity.kt\ncom/mineinabyss/geary/datatypes/Entity\n*L\n1#1,48:1\n78#2:49\n147#3,5:50\n173#3,5:55\n*S KotlinDebug\n*F\n+ 1 CaveVineHelpers.kt\ncom/mineinabyss/blocky/helpers/CaveVineHelpers\n*L\n29#1:49\n29#1:50,5\n33#1:55,5\n*E\n"})
public final class CaveVineHelpers {
    @NotNull
    public static final CaveVineHelpers INSTANCE = new CaveVineHelpers();
    @NotNull
    private static final BlockData defaultBlockData;
    public static final int $stable;

    private CaveVineHelpers() {
    }

    @NotNull
    public final BlockData getDefaultBlockData() {
        return defaultBlockData;
    }

    @NotNull
    public final BlockData blockyCaveVine(@NotNull Geary $context_receiver_0, @NotNull SetBlock setBlock) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)setBlock, (String)"setBlock");
        Object v = ((BlockTrackingModule)$context_receiver_0.getAddon(BlockTrackingKt.getBlockTracking())).getBlock2Prefab().getBlockMap().get(setBlock.getBlockType());
        Intrinsics.checkNotNull(v);
        return ((BlockData[])v)[setBlock.getBlockId()];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isBlockyCaveVine(@NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        if (block.getType() != Material.CAVE_VINES) return false;
        World world = block.getWorld();
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorld(...)");
        Block2Prefab block2Prefab = ((BlockTrackingModule)WorldManagerKt.toGeary((World)world).getAddon(BlockTrackingKt.getBlockTracking())).getBlock2Prefab();
        BlockData blockData = block.getBlockData();
        Intrinsics.checkNotNullExpressionValue((Object)blockData, (String)"getBlockData(...)");
        if (!block2Prefab.contains(blockData)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isBlockyCaveVine(@NotNull Geary $context_receiver_0, @NotNull ItemStack itemStack) {
        SetBlock setBlock;
        void $context_receiver_0$iv;
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Geary geary = $context_receiver_0;
        ItemStack $this$decode$iv = itemStack;
        boolean $i$f$decode = false;
        Entity entity = GearyItemProvider.deserializeItemStackToEntity$default((GearyItemProvider)((ItemTrackingModule)$context_receiver_0$iv.getAddon(ItemTrackingKt.getItemTracking())).getItemProvider(), (PersistentDataContainer)((PersistentDataContainer)FastItemPDCKt.getFastPDC((ItemStack)$this$decode$iv)), null, (int)2, null);
        if (entity != null) {
            void this_$iv$iv$iv;
            Entity this_$iv$iv = entity;
            boolean $i$f$get = false;
            Entity entity2 = this_$iv$iv;
            KClass kClass$iv$iv$iv = Reflection.getOrCreateKotlinClass(SetBlock.class);
            boolean $i$f$get2 = false;
            Object object = this_$iv$iv$iv.get-VKZWuLQ(EngineHelpersKt.componentId((Geary)this_$iv$iv$iv.getWorld(), (KClassifier)((KClassifier)kClass$iv$iv$iv)));
            if (!(object instanceof SetBlock)) {
                object = null;
            }
            setBlock = (SetBlock)object;
        } else {
            setBlock = null;
        }
        return (setBlock != null ? setBlock.getBlockType() : null) == SetBlock.BlockType.CAVEVINE;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean breakCaveVineBlock(@NotNull Block block, @Nullable Player player) {
        void this_$iv$iv;
        Entity gearyBlock;
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        World world = block.getWorld();
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorld(...)");
        Geary $this$breakCaveVineBlock_u24lambda_u241 = WorldManagerKt.toGeary((World)world);
        boolean bl = false;
        Entity entity = HelpersKt.toGearyOrNull((Block)block);
        if (entity == null) {
            return false;
        }
        Entity this_$iv = gearyBlock = entity;
        boolean $i$f$has = false;
        Entity entity2 = this_$iv;
        KClass kClass$iv$iv = Reflection.getOrCreateKotlinClass(SetBlock.class);
        boolean $i$f$has2 = false;
        if (!this_$iv$iv.has-VKZWuLQ(EngineHelpersKt.componentId((Geary)this_$iv$iv.getWorld(), (KClassifier)((KClassifier)kClass$iv$iv)))) {
            return false;
        }
        Player player2 = player;
        if (player2 != null) {
            Player it = player2;
            boolean bl2 = false;
            if (!new BlockyBlockBreakEvent(block, player).callEvent()) {
                return false;
            }
            Location location = block.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
            if (!ProtectionLib.canBreak(player, location)) {
                return false;
            }
            GenericHelpersKt.handleBlockyDrops(block, player);
        }
        block.setType(Material.AIR, false);
        if (block.getRelative(BlockFace.DOWN).getType() == Material.CAVE_VINES) {
            Block block2 = block.getRelative(BlockFace.DOWN);
            Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"getRelative(...)");
            INSTANCE.breakCaveVineBlock(block2, null);
        }
        return true;
    }

    static {
        BlockData blockData = Material.CAVE_VINES.createBlockData();
        Intrinsics.checkNotNullExpressionValue((Object)blockData, (String)"createBlockData(...)");
        defaultBlockData = blockData;
        $stable = 8;
    }
}

