/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.util;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.objects.GSeat;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.entity.LivingEntity;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class SitUtil {
    private final GSitMain GPM;

    public SitUtil(GSitMain GPluginMain) {
        this.GPM = GPluginMain;
    }

    public boolean isSeatBlock(Block Block2) {
        return Block2.hasMetadata(this.GPM.NAME);
    }

    public List<GSeat> getSeats(Block Block2) {
        MetadataValue metadataValue;
        ArrayList<GSeat> seats = new ArrayList<GSeat>();
        if (this.isSeatBlock(Block2) && (metadataValue = (MetadataValue)Block2.getMetadata(this.GPM.NAME).stream().filter(s -> this.GPM.equals(s.getOwningPlugin())).findFirst().orElse(null)) != null) {
            seats = new ArrayList((List)metadataValue.value());
        }
        return seats;
    }

    public List<GSeat> getSeats(List<Block> Blocks) {
        ArrayList<GSeat> seats = new ArrayList<GSeat>();
        for (Block block : Blocks) {
            for (GSeat seat : this.getSeats(block)) {
                if (seats.contains(seat)) continue;
                seats.add(seat);
            }
        }
        return seats;
    }

    public void setSeatBlock(Block Block2, GSeat Seat) {
        List<GSeat> seats = this.getSeats(Block2);
        if (!seats.contains(Seat)) {
            seats.add(Seat);
        }
        Block2.setMetadata(this.GPM.NAME, (MetadataValue)new FixedMetadataValue((Plugin)this.GPM, seats));
    }

    public void removeSeatBlock(Block Block2, GSeat Seat) {
        List<GSeat> seats = this.getSeats(Block2);
        seats.remove(Seat);
        if (seats.size() > 0) {
            Block2.setMetadata(this.GPM.NAME, (MetadataValue)new FixedMetadataValue((Plugin)this.GPM, seats));
        } else {
            Block2.removeMetadata(this.GPM.NAME, (Plugin)this.GPM);
        }
    }

    public GSeat createSeatForStair(Block Block2, LivingEntity Entity2) {
        GSeat seat = null;
        Stairs blockData = (Stairs)Block2.getBlockData();
        if (blockData.getHalf() != Bisected.Half.BOTTOM) {
            return this.GPM.getSitManager().createSeat(Block2, Entity2);
        }
        BlockFace blockFace = blockData.getFacing().getOppositeFace();
        Stairs.Shape stairShape = blockData.getShape();
        if (blockData.getShape() == Stairs.Shape.STRAIGHT) {
            switch (blockFace) {
                case EAST: {
                    seat = this.GPM.getSitManager().createSeat(Block2, Entity2, false, 0.123, -0.5, 0.0, -90.0f, true, this.GPM.getCManager().GET_UP_SNEAK);
                    break;
                }
                case SOUTH: {
                    seat = this.GPM.getSitManager().createSeat(Block2, Entity2, false, 0.0, -0.5, 0.123, 0.0f, true, this.GPM.getCManager().GET_UP_SNEAK);
                    break;
                }
                case WEST: {
                    seat = this.GPM.getSitManager().createSeat(Block2, Entity2, false, -0.123, -0.5, 0.0, 90.0f, true, this.GPM.getCManager().GET_UP_SNEAK);
                    break;
                }
                case NORTH: {
                    seat = this.GPM.getSitManager().createSeat(Block2, Entity2, false, 0.0, -0.5, -0.123, 180.0f, true, this.GPM.getCManager().GET_UP_SNEAK);
                    break;
                }
            }
        } else if (blockFace == BlockFace.NORTH && stairShape == Stairs.Shape.OUTER_RIGHT || blockFace == BlockFace.EAST && stairShape == Stairs.Shape.OUTER_LEFT || blockFace == BlockFace.NORTH && stairShape == Stairs.Shape.INNER_RIGHT || blockFace == BlockFace.EAST && stairShape == Stairs.Shape.INNER_LEFT) {
            seat = this.GPM.getSitManager().createSeat(Block2, Entity2, false, 0.123, -0.5, -0.123, -135.0f, true, this.GPM.getCManager().GET_UP_SNEAK);
        } else if (blockFace == BlockFace.NORTH && stairShape == Stairs.Shape.OUTER_LEFT || blockFace == BlockFace.WEST && stairShape == Stairs.Shape.OUTER_RIGHT || blockFace == BlockFace.NORTH && stairShape == Stairs.Shape.INNER_LEFT || blockFace == BlockFace.WEST && stairShape == Stairs.Shape.INNER_RIGHT) {
            seat = this.GPM.getSitManager().createSeat(Block2, Entity2, false, -0.123, -0.5, -0.123, 135.0f, true, this.GPM.getCManager().GET_UP_SNEAK);
        } else if (blockFace == BlockFace.SOUTH && stairShape == Stairs.Shape.OUTER_RIGHT || blockFace == BlockFace.WEST && stairShape == Stairs.Shape.OUTER_LEFT || blockFace == BlockFace.SOUTH && stairShape == Stairs.Shape.INNER_RIGHT || blockFace == BlockFace.WEST && stairShape == Stairs.Shape.INNER_LEFT) {
            seat = this.GPM.getSitManager().createSeat(Block2, Entity2, false, -0.123, -0.5, 0.123, 45.0f, true, this.GPM.getCManager().GET_UP_SNEAK);
        } else if (blockFace == BlockFace.SOUTH && stairShape == Stairs.Shape.OUTER_LEFT || blockFace == BlockFace.EAST && stairShape == Stairs.Shape.OUTER_RIGHT || blockFace == BlockFace.SOUTH && stairShape == Stairs.Shape.INNER_LEFT || blockFace == BlockFace.EAST && stairShape == Stairs.Shape.INNER_RIGHT) {
            seat = this.GPM.getSitManager().createSeat(Block2, Entity2, false, 0.123, -0.5, 0.123, -45.0f, true, this.GPM.getCManager().GET_UP_SNEAK);
        }
        return seat;
    }
}

