/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.util;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.objects.IGPoseSeat;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class PoseUtil {
    private final GSitMain GPM;

    public PoseUtil(GSitMain GPluginMain) {
        this.GPM = GPluginMain;
    }

    public boolean isPoseBlock(Block Block2) {
        return Block2.hasMetadata(this.GPM.NAME + "P");
    }

    public List<IGPoseSeat> getPoses(Block Blocks) {
        MetadataValue metadataValue;
        ArrayList<IGPoseSeat> poses = new ArrayList<IGPoseSeat>();
        if (this.isPoseBlock(Blocks) && (metadataValue = (MetadataValue)Blocks.getMetadata(this.GPM.NAME + "P").stream().filter(s -> this.GPM.equals(s.getOwningPlugin())).findFirst().orElse(null)) != null) {
            poses = new ArrayList((List)metadataValue.value());
        }
        return poses;
    }

    public List<IGPoseSeat> getPoses(List<Block> Blocks) {
        ArrayList<IGPoseSeat> poses = new ArrayList<IGPoseSeat>();
        for (Block block : Blocks) {
            for (IGPoseSeat poseSeat : this.getPoses(block)) {
                if (poses.contains(poseSeat)) continue;
                poses.add(poseSeat);
            }
        }
        return poses;
    }

    public void setPoseBlock(Block Block2, IGPoseSeat PoseSeat) {
        List<IGPoseSeat> poses = this.getPoses(Block2);
        if (!poses.contains(PoseSeat)) {
            poses.add(PoseSeat);
        }
        Block2.setMetadata(this.GPM.NAME + "P", (MetadataValue)new FixedMetadataValue((Plugin)this.GPM, poses));
    }

    public void removePoseBlock(Block Block2, IGPoseSeat PoseSeat) {
        List<IGPoseSeat> poses = this.getPoses(Block2);
        poses.remove(PoseSeat);
        if (poses.size() > 0) {
            Block2.setMetadata(this.GPM.NAME + "P", (MetadataValue)new FixedMetadataValue((Plugin)this.GPM, poses));
        } else {
            Block2.removeMetadata(this.GPM.NAME + "P", (Plugin)this.GPM);
        }
    }
}

