/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.util;

import dev.geco.gsit.objects.GEmote;
import dev.geco.gsit.objects.GEmotePart;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Vibration;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class EmoteUtil {
    public GEmote createEmoteFromRawData(File File2) {
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)File2);
        List pattern = configuration.getStringList("pattern");
        ArrayList<GEmotePart> parts = new ArrayList<GEmotePart>();
        for (String part : pattern) {
            Supplier<Stream> sPart = () -> Arrays.stream(part.toLowerCase().split(" "));
            try {
                Particle particle;
                try {
                    particle = Particle.valueOf((String)sPart.get().filter(s -> s.startsWith("particle:")).findFirst().orElse(":.").split(":")[1].toUpperCase());
                }
                catch (Exception ignored) {
                    continue;
                }
                String sDelay = sPart.get().filter(s -> s.startsWith("delay:")).findFirst().orElse(":0").split(":")[1];
                long delay = Long.parseLong(sDelay);
                String sRepeat = sPart.get().filter(s -> s.startsWith("repeat:")).findFirst().orElse(":1").split(":")[1];
                long repeat = Long.parseLong(sRepeat);
                String sLoop = sPart.get().filter(s -> s.startsWith("loop:")).findFirst().orElse(":1").split(":")[1];
                boolean loop = Byte.parseByte(sLoop) == 1;
                String sAmount = sPart.get().filter(s -> s.startsWith("amount:")).findFirst().orElse(":1").split(":")[1];
                int amount = Integer.parseInt(sAmount);
                String sXOffset = sPart.get().filter(s -> s.startsWith("xoffset:")).findFirst().orElse(":0.0").split(":")[1];
                double xoffset = Double.parseDouble(sXOffset);
                String sYOffset = sPart.get().filter(s -> s.startsWith("yoffset:")).findFirst().orElse(":0.0").split(":")[1];
                double yoffset = Double.parseDouble(sYOffset);
                String sZOffset = sPart.get().filter(s -> s.startsWith("zoffset:")).findFirst().orElse(":0.0").split(":")[1];
                double zoffset = Double.parseDouble(sZOffset);
                String sExtra = sPart.get().filter(s -> s.startsWith("extra:")).findFirst().orElse(":1.0").split(":")[1];
                double extra = Double.parseDouble(sExtra);
                String[] sData = sPart.get().filter(s -> s.startsWith("data:")).findFirst().orElse(":.").split(":");
                Object data = null;
                if (Particle.DustOptions.class.equals((Object)particle.getDataType())) {
                    data = new Particle.DustOptions(Color.fromRGB((int)Integer.parseInt(sData[1]), (int)Integer.parseInt(sData[2]), (int)Integer.parseInt(sData[3])), sData.length > 4 ? Float.parseFloat(sData[4]) : 1.0f);
                } else if (BlockData.class.equals((Object)particle.getDataType())) {
                    data = Material.getMaterial((String)sData[1].toUpperCase()).createBlockData();
                } else if (ItemStack.class.equals((Object)particle.getDataType())) {
                    data = new ItemStack(Material.getMaterial((String)sData[1].toUpperCase()));
                } else if (Particle.DustTransition.class.equals((Object)particle.getDataType())) {
                    data = new Particle.DustTransition(Color.fromRGB((int)Integer.parseInt(sData[1]), (int)Integer.parseInt(sData[2]), (int)Integer.parseInt(sData[3])), Color.fromRGB((int)Integer.parseInt(sData[4]), (int)Integer.parseInt(sData[5]), (int)Integer.parseInt(sData[6])), sData.length > 7 ? Float.parseFloat(sData[7]) : 1.0f);
                } else if (Float.class.equals((Object)particle.getDataType())) {
                    data = Float.valueOf(Float.parseFloat(sData[1]));
                } else if (Integer.class.equals((Object)particle.getDataType())) {
                    data = Integer.parseInt(sData[1]);
                } else if (Vibration.class.equals((Object)particle.getDataType())) {
                    // empty if block
                }
                int i = 0;
                while ((long)i < repeat) {
                    parts.add(new GEmotePart(particle, delay, repeat, loop, amount, xoffset, yoffset, zoffset, extra, data));
                    ++i;
                }
            }
            catch (Error | Exception e) {
                e.printStackTrace();
            }
        }
        return new GEmote(File2.getName().replace(".gex", "").toLowerCase(), parts, configuration.getLong("loop", 0L), configuration.getBoolean("head", true));
    }
}

