/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.objects;

import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class GEmotePart {
    protected final Particle particle;
    protected final long delay;
    protected final long repeat;
    protected final boolean loop;
    protected final int amount;
    protected final double xoffset;
    protected final double yoffset;
    protected final double zoffset;
    protected final double extra;
    protected final Object data;

    public GEmotePart(Particle Particle2, long Delay, long Repeat, boolean Loop2, int Amount, double XOffset, double YOffset, double ZOffset, double Extra, Object Data) {
        this.particle = Particle2;
        this.delay = Math.max(Delay, 0L);
        this.repeat = Math.max(Repeat, 1L);
        this.loop = Loop2;
        this.amount = Math.max(Amount, 1);
        this.xoffset = XOffset;
        this.yoffset = YOffset;
        this.zoffset = ZOffset;
        this.extra = Extra < 0.0 ? 1.0 : Extra;
        this.data = Data != null && Particle2.getDataType().equals(Data.getClass()) ? Data : null;
    }

    private Vector getCords(LivingEntity Entity2) {
        float yaw = Entity2.getLocation().getYaw();
        float yawF = yaw + 180.0f;
        Vector xVector = new Vector(Math.cos(Math.toRadians(yawF)) * this.getXOffset(), 0.0, Math.sin(Math.toRadians(yawF)) * this.getXOffset());
        Vector zVector = new Vector(-Math.sin(Math.toRadians(yaw)) * this.getZOffset(), 0.0, Math.cos(Math.toRadians(yaw)) * this.getZOffset());
        Location location = Entity2.getLocation().clone().add(xVector).add(zVector);
        return new Vector(location.getX(), 0.0, location.getZ());
    }

    protected void start(Player Player2, LivingEntity Origin, boolean Head) {
        if (this.getParticle() == null) {
            return;
        }
        Vector vector = this.getCords(Origin);
        Player2.spawnParticle(this.getParticle(), vector.getX(), (Head ? Origin.getEyeLocation() : Origin.getLocation()).getY() + this.getYOffset(), vector.getZ(), this.getAmount(), 0.0, 0.0, 0.0, this.getExtra(), this.getData());
    }

    public Particle getParticle() {
        return this.particle;
    }

    public long getDelay() {
        return this.delay;
    }

    public long getRepeat() {
        return this.repeat;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public int getAmount() {
        return this.amount;
    }

    public double getXOffset() {
        return this.xoffset;
    }

    public double getYOffset() {
        return this.yoffset;
    }

    public double getZOffset() {
        return this.zoffset;
    }

    public double getExtra() {
        return this.extra;
    }

    public Object getData() {
        return this.data;
    }
}

