/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.mcv.v1_18_R2.manager;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.api.event.PlayerGetUpPoseEvent;
import dev.geco.gsit.api.event.PlayerPoseEvent;
import dev.geco.gsit.api.event.PrePlayerGetUpPoseEvent;
import dev.geco.gsit.api.event.PrePlayerPoseEvent;
import dev.geco.gsit.manager.IPoseManager;
import dev.geco.gsit.mcv.v1_18_R2.objects.GPoseSeat;
import dev.geco.gsit.objects.GSeat;
import dev.geco.gsit.objects.GetUpReason;
import dev.geco.gsit.objects.IGPoseSeat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.event.Event;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PoseManager
implements IPoseManager {
    private final GSitMain GPM;
    private int feature_used = 0;
    private final List<IGPoseSeat> poses = new ArrayList<IGPoseSeat>();
    private final HashMap<IGPoseSeat, BukkitRunnable> rotate = new HashMap();

    public PoseManager(GSitMain GPluginMain) {
        this.GPM = GPluginMain;
    }

    @Override
    public int getFeatureUsedCount() {
        return this.feature_used;
    }

    @Override
    public void resetFeatureUsedCount() {
        this.feature_used = 0;
    }

    @Override
    public List<IGPoseSeat> getPoses() {
        return new ArrayList<IGPoseSeat>(this.poses);
    }

    @Override
    public boolean isPosing(Player Player2) {
        return this.getPose(Player2) != null;
    }

    @Override
    public IGPoseSeat getPose(Player Player2) {
        return this.getPoses().stream().filter(pose -> Player2.equals(pose.getPlayer())).findFirst().orElse(null);
    }

    @Override
    public void clearPoses() {
        for (IGPoseSeat pose : this.getPoses()) {
            this.removePose(pose.getPlayer(), GetUpReason.PLUGIN);
        }
    }

    @Override
    public boolean kickPose(Block Block2, Player Player2) {
        if (this.GPM.getPoseUtil().isPoseBlock(Block2)) {
            if (!this.GPM.getPManager().hasPermission((CommandSender)Player2, "Kick.Pose", "Kick.*")) {
                return false;
            }
            for (IGPoseSeat p : this.GPM.getPoseUtil().getPoses(Block2)) {
                if (this.removePose(p.getPlayer(), GetUpReason.KICKED)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public IGPoseSeat createPose(Block Block2, Player Player2, Pose Pose2) {
        return this.createPose(Block2, Player2, Pose2, 0.0, 0.0, 0.0, Player2.getLocation().getYaw(), this.GPM.getCManager().CENTER_BLOCK, this.GPM.getCManager().GET_UP_SNEAK);
    }

    @Override
    public IGPoseSeat createPose(Block Block2, Player Player2, Pose Pose2, double XOffset, double YOffset, double ZOffset, float SeatRotation, boolean SitAtBlock, boolean GetUpSneak) {
        double offset;
        PrePlayerPoseEvent preEvent = new PrePlayerPoseEvent(Player2, Block2);
        Bukkit.getPluginManager().callEvent((Event)preEvent);
        if (preEvent.isCancelled()) {
            return null;
        }
        double d = offset = SitAtBlock ? Block2.getBoundingBox().getMinY() + Block2.getBoundingBox().getHeight() : 0.0;
        offset = (SitAtBlock ? (offset == 0.0 ? 1.0 : offset - (double)Block2.getY()) : offset) + this.GPM.getCManager().S_SITMATERIALS.getOrDefault(Block2.getType(), 0.0);
        Location playerLocation = Player2.getLocation().clone();
        Location returnLocation = playerLocation.clone();
        playerLocation = SitAtBlock ? Block2.getLocation().clone().add(0.5 + XOffset, YOffset + offset - 0.2, 0.5 + ZOffset) : playerLocation.add(XOffset, YOffset - 0.2 + this.GPM.getCManager().S_SITMATERIALS.getOrDefault(Block2.getType(), 0.0), ZOffset);
        if (!this.GPM.getSpawnUtil().checkLocation(playerLocation)) {
            return null;
        }
        playerLocation.setYaw(SeatRotation);
        Entity seatEntity = this.GPM.getSpawnUtil().createSeatEntity(playerLocation, (Entity)Player2);
        if (this.GPM.getCManager().P_POSE_MESSAGE) {
            this.GPM.getMManager().sendActionBarMessage(Player2, "Messages.action-pose-info", new Object[0]);
        }
        GSeat seat = new GSeat(Block2, playerLocation, (LivingEntity)Player2, seatEntity, returnLocation);
        GPoseSeat poseseat = new GPoseSeat(seat, Pose2);
        poseseat.spawn();
        seatEntity.setMetadata(this.GPM.NAME + "P", (MetadataValue)new FixedMetadataValue((Plugin)this.GPM, (Object)poseseat));
        this.poses.add(poseseat);
        this.GPM.getPoseUtil().setPoseBlock(Block2, poseseat);
        this.startRotateSeat(poseseat);
        ++this.feature_used;
        Bukkit.getPluginManager().callEvent((Event)new PlayerPoseEvent(poseseat));
        return poseseat;
    }

    private void startRotateSeat(final IGPoseSeat PoseSeat) {
        if (this.rotate.containsKey(PoseSeat)) {
            this.stopRotateSeat(PoseSeat);
        }
        BukkitRunnable task = new BukkitRunnable(){

            public void run() {
                if (!PoseManager.this.poses.contains(PoseSeat) || PoseSeat.getSeat().getSeatEntity().getPassengers().isEmpty()) {
                    this.cancel();
                    return;
                }
                Location location = ((Entity)PoseSeat.getSeat().getSeatEntity().getPassengers().get(0)).getLocation();
                PoseSeat.getSeat().getSeatEntity().setRotation(location.getYaw(), location.getPitch());
            }
        };
        task.runTaskTimer((Plugin)this.GPM, 0L, 2L);
        this.rotate.put(PoseSeat, task);
    }

    protected void stopRotateSeat(IGPoseSeat PoseSeat) {
        if (!this.rotate.containsKey(PoseSeat)) {
            return;
        }
        BukkitRunnable task = this.rotate.get(PoseSeat);
        if (task != null && !task.isCancelled()) {
            task.cancel();
        }
        this.rotate.remove(PoseSeat);
    }

    @Override
    public boolean removePose(Player Player2, GetUpReason Reason) {
        return this.removePose(Player2, Reason, true);
    }

    @Override
    public boolean removePose(Player Player2, GetUpReason Reason, boolean Safe) {
        Location returnLocation;
        if (!this.isPosing(Player2)) {
            return true;
        }
        IGPoseSeat poseSeat = this.getPose(Player2);
        PrePlayerGetUpPoseEvent preEvent = new PrePlayerGetUpPoseEvent(poseSeat, Reason);
        Bukkit.getPluginManager().callEvent((Event)preEvent);
        if (preEvent.isCancelled()) {
            return false;
        }
        this.GPM.getPoseUtil().removePoseBlock(poseSeat.getSeat().getBlock(), poseSeat);
        this.poses.remove(poseSeat);
        this.stopRotateSeat(poseSeat);
        poseSeat.remove();
        Location location = this.GPM.getCManager().GET_UP_RETURN ? poseSeat.getSeat().getReturn() : (returnLocation = poseSeat.getSeat().getLocation().add(0.0, 0.2 + (Tag.STAIRS.isTagged((Keyed)poseSeat.getSeat().getBlock().getType()) ? 0.5 : 0.0) - this.GPM.getCManager().S_SITMATERIALS.getOrDefault(poseSeat.getSeat().getBlock().getType(), 0.0), 0.0));
        if (!this.GPM.getCManager().GET_UP_RETURN) {
            returnLocation.setYaw(poseSeat.getPlayer().getLocation().getYaw());
            returnLocation.setPitch(poseSeat.getPlayer().getLocation().getPitch());
        }
        if (poseSeat.getPlayer().isValid() && Safe) {
            this.GPM.getPlayerUtil().posEntity((Entity)poseSeat.getPlayer(), returnLocation);
            this.GPM.getPlayerUtil().teleportEntity((Entity)poseSeat.getPlayer(), returnLocation, true);
        }
        if (poseSeat.getSeat().getSeatEntity().isValid()) {
            poseSeat.getSeat().getSeatEntity().remove();
        }
        Bukkit.getPluginManager().callEvent((Event)new PlayerGetUpPoseEvent(poseSeat, Reason));
        return true;
    }
}

