/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.mcv.v1_17_R1_2.objects;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.mcv.v1_17_R1_2.objects.BoxEntity;
import dev.geco.gsit.objects.GetUpReason;
import dev.geco.gsit.objects.IGCrawl;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityToggleSwimEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GCrawl
implements IGCrawl {
    private final GSitMain GPM = GSitMain.getInstance();
    private final Player player;
    private final EntityPlayer serverPlayer;
    protected final BoxEntity boxEntity;
    private Location blockLocation;
    private boolean blockPresent;
    private boolean boxPresent;
    protected final BlockData blockData = Material.BARRIER.createBlockData();
    private final Listener listener;
    private final Listener moveListener;
    private final Listener stopListener;

    public GCrawl(Player Player2) {
        this.player = Player2;
        this.serverPlayer = ((CraftPlayer)this.player).getHandle();
        this.boxEntity = new BoxEntity(this.player.getLocation());
        this.listener = new Listener(){

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void ETogSE(EntityToggleSwimEvent Event2) {
                if (Event2.getEntity() == GCrawl.this.player) {
                    Event2.setCancelled(true);
                }
            }

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void PIntE(PlayerInteractEvent Event2) {
                if (Event2.getPlayer() == GCrawl.this.player && GCrawl.this.blockPresent && Event2.getClickedBlock().equals(GCrawl.this.blockLocation.getBlock()) && Event2.getHand() == EquipmentSlot.HAND) {
                    Event2.setCancelled(true);
                    new BukkitRunnable(){

                        public void run() {
                            GCrawl.this.buildBlock();
                        }
                    }.runTaskAsynchronously((Plugin)GCrawl.this.GPM);
                }
            }
        };
        this.moveListener = new Listener(){

            @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
            public void PMovE(PlayerMoveEvent Event2) {
                if (Event2.getPlayer() == GCrawl.this.player) {
                    Location locationFrom = Event2.getFrom();
                    Location locationTo = Event2.getTo();
                    if (locationFrom.getX() != locationTo.getX() || locationFrom.getZ() != locationTo.getZ() || locationFrom.getY() != locationTo.getY()) {
                        GCrawl.this.tick(locationFrom);
                    }
                }
            }
        };
        this.stopListener = new Listener(){

            @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
            public void PTogSE(PlayerToggleSneakEvent Event2) {
                if (Event2.getPlayer() == GCrawl.this.player && Event2.isSneaking()) {
                    GCrawl.this.GPM.getCrawlManager().stopCrawl(GCrawl.this.player, GetUpReason.GET_UP);
                }
            }
        };
    }

    @Override
    public void start() {
        this.player.setSwimming(true);
        Bukkit.getPluginManager().registerEvents(this.listener, (Plugin)this.GPM);
        new BukkitRunnable(){

            public void run() {
                Bukkit.getPluginManager().registerEvents(GCrawl.this.moveListener, (Plugin)GCrawl.this.GPM);
                if (GCrawl.this.GPM.getCManager().C_GET_UP_SNEAK) {
                    Bukkit.getPluginManager().registerEvents(GCrawl.this.stopListener, (Plugin)GCrawl.this.GPM);
                }
                GCrawl.this.tick(GCrawl.this.player.getLocation());
            }
        }.runTaskLaterAsynchronously((Plugin)this.GPM, 1L);
    }

    private void tick(final Location Location2) {
        boolean canSetBarrier;
        if (!this.checkCrawlValid()) {
            return;
        }
        Location location = Location2.clone();
        final Block locationBlock = location.getBlock();
        final int blockSize = (int)((location.getY() - (double)location.getBlockY()) * 100.0);
        location.setY((double)location.getBlockY() + (blockSize >= 40 ? 2.49 : 1.49));
        Block aboveBlock = location.getBlock();
        boolean aboveBlockSolid = aboveBlock.getBoundingBox().contains(location.toVector()) && aboveBlock.getCollisionShape().getBoundingBoxes().size() > 0;
        boolean canPlaceBlock = this.isValidArea(locationBlock.getRelative(BlockFace.UP), aboveBlock, this.blockLocation != null ? this.blockLocation.getBlock() : null);
        boolean bl = canSetBarrier = canPlaceBlock && (aboveBlock.getType().isAir() || aboveBlockSolid);
        if (this.blockLocation == null || !aboveBlock.equals(this.blockLocation.getBlock())) {
            this.destoryBlock();
            this.blockLocation = location;
            if (canSetBarrier && !aboveBlockSolid) {
                this.buildBlock();
            }
        }
        if (!canSetBarrier && !aboveBlockSolid) {
            new BukkitRunnable(){

                public void run() {
                    Location playerLocation = Location2.clone();
                    int height = locationBlock.getBoundingBox().getHeight() >= 0.4 || playerLocation.getY() % 0.015625 == 0.0 ? ((double)GCrawl.this.player.getFallDistance() > 0.7 ? 0 : blockSize) : 0;
                    playerLocation.setY(playerLocation.getY() + (height >= 40 ? 1.5 : 0.5));
                    GCrawl.this.boxEntity.setPeek(height >= 40 ? 100 - height : 0);
                    if (GCrawl.this.boxPresent) {
                        GCrawl.this.serverPlayer.b.sendPacket((Packet)new PacketPlayOutEntityMetadata(GCrawl.this.boxEntity.getId(), GCrawl.this.boxEntity.getDataWatcher(), true));
                        GCrawl.this.boxEntity.enderTeleportAndLoad(playerLocation.getX(), playerLocation.getY(), playerLocation.getZ());
                        GCrawl.this.serverPlayer.b.sendPacket((Packet)new PacketPlayOutEntityTeleport((Entity)GCrawl.this.boxEntity));
                    } else {
                        GCrawl.this.boxEntity.setPosition(playerLocation.getX(), playerLocation.getY(), playerLocation.getZ());
                        GCrawl.this.serverPlayer.b.sendPacket((Packet)new PacketPlayOutSpawnEntity((Entity)GCrawl.this.boxEntity));
                        GCrawl.this.boxPresent = true;
                        GCrawl.this.serverPlayer.b.sendPacket((Packet)new PacketPlayOutEntityMetadata(GCrawl.this.boxEntity.getId(), GCrawl.this.boxEntity.getDataWatcher(), true));
                    }
                }
            }.runTask((Plugin)this.GPM);
        } else {
            this.destoryEntity();
        }
    }

    @Override
    public void stop() {
        HandlerList.unregisterAll((Listener)this.listener);
        HandlerList.unregisterAll((Listener)this.moveListener);
        HandlerList.unregisterAll((Listener)this.stopListener);
        this.player.setSwimming(false);
        if (this.blockLocation != null) {
            this.player.sendBlockChange(this.blockLocation, this.blockLocation.getBlock().getBlockData());
        }
        this.serverPlayer.b.sendPacket((Packet)new PacketPlayOutEntityDestroy(new int[]{this.boxEntity.getId()}));
    }

    private void buildBlock() {
        this.player.sendBlockChange(this.blockLocation, this.blockData);
        this.blockPresent = true;
    }

    private void destoryBlock() {
        if (this.blockPresent) {
            this.player.sendBlockChange(this.blockLocation, this.blockLocation.getBlock().getBlockData());
            this.blockPresent = false;
        }
    }

    private void destoryEntity() {
        if (this.boxPresent) {
            this.serverPlayer.b.sendPacket((Packet)new PacketPlayOutEntityDestroy(new int[]{this.boxEntity.getId()}));
            this.boxPresent = false;
        }
    }

    private boolean checkCrawlValid() {
        if (this.serverPlayer.isInWater() || this.player.isFlying()) {
            new BukkitRunnable(){

                public void run() {
                    GCrawl.this.GPM.getCrawlManager().stopCrawl(GCrawl.this.player, GetUpReason.ACTION);
                }
            }.runTask((Plugin)this.GPM);
            return false;
        }
        return true;
    }

    private boolean isValidArea(Block BlockUp, Block AboveBlock, Block LocationBlock) {
        return BlockUp.equals(AboveBlock) || BlockUp.equals(LocationBlock);
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    public String toString() {
        return this.boxEntity.getUniqueID().toString();
    }
}

