/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.mcv.v1_17_R1.objects;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import dev.geco.gsit.GSitMain;
import dev.geco.gsit.objects.GSeat;
import dev.geco.gsit.objects.IGPoseSeat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutNamedEntitySpawn;
import net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyBedPart;
import net.minecraft.world.level.block.state.properties.IBlockState;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.Statistic;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_17_R1.CraftServer;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerAnimationType;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GPoseSeat
implements IGPoseSeat {
    private final GSitMain GPM = GSitMain.getInstance();
    private final GSeat seat;
    private final Player seatPlayer;
    private final Pose pose;
    private Set<Player> nearPlayers = new HashSet<Player>();
    private final EntityPlayer serverPlayer;
    protected final EntityPlayer playerNpc;
    private final Location blockLocation;
    private final BlockData bedData;
    private final BlockPosition bedPos;
    private final EnumDirection direction;
    protected PacketPlayOutBlockChange setBedPacket;
    protected PacketPlayOutPlayerInfo addNpcInfoPacket;
    protected PacketPlayOutPlayerInfo removeNpcInfoPacket;
    protected PacketPlayOutEntityDestroy removeNpcPacket;
    protected PacketPlayOutNamedEntitySpawn createNpcPacket;
    protected PacketPlayOutEntityMetadata metaNpcPacket;
    protected PacketPlayOutEntityTeleport teleportNpcPacket;
    protected PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook rotateNpcPacket;
    private BukkitRunnable task;
    private final Listener listener;

    public GPoseSeat(GSeat Seat, Pose Pose2) {
        this.seat = Seat;
        this.seatPlayer = (Player)Seat.getEntity();
        this.pose = Pose2;
        Location seatLocation = this.seat.getLocation();
        this.serverPlayer = ((CraftPlayer)this.seatPlayer).getHandle();
        this.playerNpc = this.createNPC();
        this.playerNpc.setPositionRotation(seatLocation.getX(), seatLocation.getY() + (this.pose == Pose.SLEEPING ? 0.3125 : (this.pose == Pose.SPIN_ATTACK ? 0.2 : 0.0)), seatLocation.getZ(), 0.0f, 0.0f);
        this.blockLocation = seatLocation.clone();
        this.blockLocation.setY((double)this.blockLocation.getWorld().getMinHeight());
        this.bedData = this.blockLocation.getBlock().getBlockData();
        this.bedPos = new BlockPosition(this.blockLocation.getBlockX(), this.blockLocation.getBlockY(), this.blockLocation.getBlockZ());
        this.direction = this.getDirection();
        this.setNpcMeta();
        if (this.pose == Pose.SLEEPING) {
            this.setBedPacket = new PacketPlayOutBlockChange(this.bedPos, (IBlockData)((IBlockData)Blocks.aD.getBlockData().set((IBlockState)BlockBed.aE, (Comparable)this.direction.opposite())).set((IBlockState)BlockBed.a, (Comparable)BlockPropertyBedPart.a));
        }
        this.addNpcInfoPacket = new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.a, new EntityPlayer[]{this.playerNpc});
        this.removeNpcInfoPacket = new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.e, new EntityPlayer[]{this.playerNpc});
        this.removeNpcPacket = new PacketPlayOutEntityDestroy(this.playerNpc.getId());
        this.createNpcPacket = new PacketPlayOutNamedEntitySpawn((EntityHuman)this.playerNpc);
        this.metaNpcPacket = new PacketPlayOutEntityMetadata(this.playerNpc.getId(), this.playerNpc.getDataWatcher(), false);
        if (this.pose == Pose.SLEEPING) {
            this.teleportNpcPacket = new PacketPlayOutEntityTeleport((Entity)this.playerNpc);
        }
        if (this.pose == Pose.SPIN_ATTACK) {
            this.rotateNpcPacket = new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(this.playerNpc.getId(), 0, 0, 0, 0, this.getFixedRotation(-90.0f), true);
        }
        this.listener = new Listener(){

            @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
            public void PIntE(PlayerInteractEvent Event2) {
                if (Event2.getPlayer() == GPoseSeat.this.seatPlayer && !GPoseSeat.this.GPM.getCManager().P_INTERACT) {
                    Event2.setCancelled(true);
                }
            }

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void PIntE(PlayerInteractEntityEvent Event2) {
                if (Event2.getPlayer() == GPoseSeat.this.seatPlayer) {
                    Event2.setCancelled(true);
                }
            }

            @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
            public void EDamBEE(EntityDamageByEntityEvent Event2) {
                if (Event2.getDamager() == GPoseSeat.this.seatPlayer && !GPoseSeat.this.GPM.getCManager().P_INTERACT) {
                    Event2.setCancelled(true);
                }
            }

            @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
            public void EDamE(EntityDamageEvent Event2) {
                if (Event2.getEntity() == GPoseSeat.this.seatPlayer) {
                    GPoseSeat.this.playAnimation(1);
                }
            }

            @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
            public void PLauE(ProjectileLaunchEvent Event2) {
                if (Event2.getEntity().getShooter() == GPoseSeat.this.seatPlayer && !GPoseSeat.this.GPM.getCManager().P_INTERACT) {
                    Event2.setCancelled(true);
                }
            }

            @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
            public void PAniE(PlayerAnimationEvent Event2) {
                if (Event2.getPlayer() == GPoseSeat.this.seatPlayer && Event2.getAnimationType() == PlayerAnimationType.ARM_SWING) {
                    GPoseSeat.this.playAnimation(Event2.getPlayer().getMainHand().equals((Object)MainHand.RIGHT) ? 0 : 3);
                }
            }

            @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
            public void PGamMCE(PlayerGameModeChangeEvent Event2) {
                if (Event2.getPlayer() == GPoseSeat.this.seatPlayer && Event2.getNewGameMode() == GameMode.CREATIVE) {
                    GPoseSeat.this.setEquipmentVisibility(true);
                }
            }
        };
    }

    @Override
    public void spawn() {
        this.nearPlayers = this.getNearPlayers();
        this.playerNpc.setGlowingTag(this.serverPlayer.hasGlowingTag());
        if (this.serverPlayer.hasGlowingTag()) {
            this.serverPlayer.setGlowingTag(false);
        }
        this.serverPlayer.setInvisible(true);
        this.setEquipmentVisibility(false);
        this.playerNpc.getDataWatcher().set(DataWatcherRegistry.p.a(19), (Object)((NBTTagCompound)this.serverPlayer.getDataWatcher().get(DataWatcherRegistry.p.a(19))));
        this.playerNpc.getDataWatcher().set(DataWatcherRegistry.p.a(20), (Object)((NBTTagCompound)this.serverPlayer.getDataWatcher().get(DataWatcherRegistry.p.a(20))));
        this.serverPlayer.getDataWatcher().set(DataWatcherRegistry.p.a(19), (Object)new NBTTagCompound());
        this.serverPlayer.getDataWatcher().set(DataWatcherRegistry.p.a(20), (Object)new NBTTagCompound());
        if (this.pose == Pose.SLEEPING) {
            if (this.GPM.getCManager().P_LAY_NIGHT_SKIP) {
                this.seatPlayer.setSleepingIgnored(true);
            }
            if (this.GPM.getCManager().P_LAY_REST) {
                this.seatPlayer.setStatistic(Statistic.TIME_SINCE_REST, 0);
            }
        }
        for (Player nearPlayer : this.nearPlayers) {
            this.spawnToPlayer(nearPlayer);
        }
        Bukkit.getPluginManager().registerEvents(this.listener, (Plugin)this.GPM);
        this.startUpdate();
    }

    private void spawnToPlayer(Player Player2) {
        final EntityPlayer spawnPlayer = ((CraftPlayer)Player2).getHandle();
        spawnPlayer.b.sendPacket((Packet)this.addNpcInfoPacket);
        spawnPlayer.b.sendPacket((Packet)this.createNpcPacket);
        if (this.pose == Pose.SLEEPING) {
            spawnPlayer.b.sendPacket((Packet)this.setBedPacket);
        }
        spawnPlayer.b.sendPacket((Packet)this.metaNpcPacket);
        if (this.pose == Pose.SLEEPING) {
            spawnPlayer.b.sendPacket((Packet)this.teleportNpcPacket);
        }
        if (this.pose == Pose.SPIN_ATTACK) {
            spawnPlayer.b.sendPacket((Packet)this.rotateNpcPacket);
        }
        new BukkitRunnable(){

            public void run() {
                spawnPlayer.b.sendPacket((Packet)GPoseSeat.this.removeNpcInfoPacket);
            }
        }.runTaskLater((Plugin)this.GPM, 15L);
    }

    @Override
    public void remove() {
        this.stopUpdate();
        HandlerList.unregisterAll((Listener)this.listener);
        for (Player nearPlayer : this.nearPlayers) {
            this.removeToPlayer(nearPlayer);
        }
        if (this.pose == Pose.SLEEPING && this.GPM.getCManager().P_LAY_NIGHT_SKIP) {
            this.seatPlayer.setSleepingIgnored(false);
        }
        this.serverPlayer.setInvisible(false);
        this.setEquipmentVisibility(true);
        this.seatPlayer.setInvisible(false);
        this.serverPlayer.getDataWatcher().set(DataWatcherRegistry.p.a(19), (Object)((NBTTagCompound)this.playerNpc.getDataWatcher().get(DataWatcherRegistry.p.a(19))));
        this.serverPlayer.getDataWatcher().set(DataWatcherRegistry.p.a(20), (Object)((NBTTagCompound)this.playerNpc.getDataWatcher().get(DataWatcherRegistry.p.a(20))));
        this.serverPlayer.setGlowingTag(this.playerNpc.hasGlowingTag());
    }

    private void removeToPlayer(Player Player2) {
        EntityPlayer removePlayer = ((CraftPlayer)Player2).getHandle();
        removePlayer.b.sendPacket((Packet)this.removeNpcInfoPacket);
        removePlayer.b.sendPacket((Packet)this.removeNpcPacket);
        Player2.sendBlockChange(this.blockLocation, this.bedData);
    }

    private Set<Player> getNearPlayers() {
        HashSet<Player> playerList = new HashSet<Player>();
        this.seat.getLocation().getWorld().getPlayers().stream().filter(o -> this.seat.getLocation().distance(o.getLocation()) <= 250.0 && o.canSee(this.seatPlayer)).forEach(playerList::add);
        return playerList;
    }

    private void startUpdate() {
        this.task = new BukkitRunnable(){
            long sleepTick = 0L;

            public void run() {
                Set<Player> playerList = GPoseSeat.this.getNearPlayers();
                for (Player nearPlayer : playerList) {
                    if (GPoseSeat.this.nearPlayers.contains(nearPlayer)) continue;
                    GPoseSeat.this.nearPlayers.add(nearPlayer);
                    GPoseSeat.this.spawnToPlayer(nearPlayer);
                }
                for (Player nearPlayer : new HashSet<Player>(GPoseSeat.this.nearPlayers)) {
                    if (playerList.contains(nearPlayer)) continue;
                    GPoseSeat.this.nearPlayers.remove(nearPlayer);
                    GPoseSeat.this.removeToPlayer(nearPlayer);
                }
                if (GPoseSeat.this.pose != Pose.SPIN_ATTACK) {
                    GPoseSeat.this.updateDirection();
                }
                GPoseSeat.this.serverPlayer.setInvisible(true);
                GPoseSeat.this.updateEquipment();
                GPoseSeat.this.setEquipmentVisibility(false);
                GPoseSeat.this.updateSkin();
                if (GPoseSeat.this.pose == Pose.SLEEPING) {
                    for (Player nearPlayer : GPoseSeat.this.nearPlayers) {
                        ((CraftPlayer)nearPlayer).getHandle().b.sendPacket((Packet)GPoseSeat.this.setBedPacket);
                    }
                    if (GPoseSeat.this.GPM.getCManager().P_LAY_SNORING_SOUNDS) {
                        ++this.sleepTick;
                        if (this.sleepTick >= 90L) {
                            long tick = GPoseSeat.this.seatPlayer.getPlayerTime();
                            if (!GPoseSeat.this.GPM.getCManager().P_LAY_SNORING_NIGHT_ONLY || tick >= 12500L && tick <= 23500L) {
                                for (Player nearPlayer : GPoseSeat.this.nearPlayers) {
                                    nearPlayer.playSound(GPoseSeat.this.seat.getLocation(), Sound.ENTITY_FOX_SLEEP, SoundCategory.PLAYERS, 1.5f, 0.0f);
                                }
                            }
                            this.sleepTick = 0L;
                        }
                    }
                }
            }
        };
        this.task.runTaskTimerAsynchronously((Plugin)this.GPM, 5L, 1L);
    }

    private void stopUpdate() {
        if (this.task != null && !this.task.isCancelled()) {
            this.task.cancel();
        }
    }

    private void setNpcMeta() {
        this.playerNpc.getDataWatcher().set(DataWatcherRegistry.s.a(6), (Object)EntityPose.values()[this.pose.ordinal()]);
        this.playerNpc.getDataWatcher().set(DataWatcherRegistry.a.a(17), (Object)((Byte)this.serverPlayer.getDataWatcher().get(DataWatcherRegistry.a.a(17))));
        this.playerNpc.getDataWatcher().set(DataWatcherRegistry.a.a(18), (Object)((Byte)this.serverPlayer.getDataWatcher().get(DataWatcherRegistry.a.a(18))));
        if (this.pose == Pose.SPIN_ATTACK) {
            this.playerNpc.getDataWatcher().set(DataWatcherRegistry.a.a(8), (Object)4);
        }
        if (this.pose == Pose.SLEEPING) {
            this.playerNpc.getDataWatcher().set(DataWatcherRegistry.m.a(14), Optional.of(this.bedPos));
        }
    }

    private float fixYaw(float Yaw) {
        return (Yaw < 0.0f ? 360.0f + Yaw : Yaw) % 360.0f;
    }

    private void updateDirection() {
        if (this.pose == Pose.SWIMMING) {
            byte fixedRotation = this.getFixedRotation(this.seatPlayer.getLocation().getYaw());
            PacketPlayOutEntityHeadRotation rotateHeadPacket = new PacketPlayOutEntityHeadRotation((Entity)this.playerNpc, fixedRotation);
            PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook moveEntityPacket = new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(this.playerNpc.getId(), 0, 0, 0, fixedRotation, 0, true);
            for (Player nearPlayer : this.nearPlayers) {
                EntityPlayer player = ((CraftPlayer)nearPlayer).getHandle();
                player.b.sendPacket((Packet)rotateHeadPacket);
                player.b.sendPacket((Packet)moveEntityPacket);
            }
            return;
        }
        float playerYaw = this.seatPlayer.getLocation().getYaw();
        if (this.direction == EnumDirection.e) {
            playerYaw -= 90.0f;
        }
        if (this.direction == EnumDirection.f) {
            playerYaw += 90.0f;
        }
        if (this.direction == EnumDirection.c) {
            playerYaw -= 180.0f;
        }
        byte fixedRotation = this.getFixedRotation((playerYaw = this.fixYaw(playerYaw)) >= 315.0f ? playerYaw - 360.0f : (playerYaw <= 45.0f ? playerYaw : (playerYaw >= 180.0f ? -45.0f : 45.0f)));
        PacketPlayOutEntityHeadRotation rotateHeadPacket = new PacketPlayOutEntityHeadRotation((Entity)this.playerNpc, fixedRotation);
        for (Player nearPlayer : this.nearPlayers) {
            ((CraftPlayer)nearPlayer).getHandle().b.sendPacket((Packet)rotateHeadPacket);
        }
    }

    private void updateSkin() {
        DataWatcher entityData = this.playerNpc.getDataWatcher();
        entityData.set(DataWatcherRegistry.a.a(17), (Object)((Byte)this.serverPlayer.getDataWatcher().get(DataWatcherRegistry.a.a(17))));
        entityData.set(DataWatcherRegistry.a.a(18), (Object)((Byte)this.serverPlayer.getDataWatcher().get(DataWatcherRegistry.a.a(18))));
        PacketPlayOutEntityMetadata entityDataPacket = new PacketPlayOutEntityMetadata(this.playerNpc.getId(), entityData, false);
        for (Player nearPlayer : this.nearPlayers) {
            ((CraftPlayer)nearPlayer).getHandle().b.sendPacket((Packet)entityDataPacket);
        }
    }

    private void updateEquipment() {
        ArrayList<Pair> equipmentList = new ArrayList<Pair>();
        for (EnumItemSlot equipmentSlot : EnumItemSlot.values()) {
            net.minecraft.world.item.ItemStack itemStack = this.serverPlayer.getEquipment(equipmentSlot);
            if (itemStack == null) continue;
            equipmentList.add(Pair.of((Object)equipmentSlot, (Object)itemStack));
        }
        PacketPlayOutEntityEquipment setEquipmentPacket = new PacketPlayOutEntityEquipment(this.playerNpc.getId(), equipmentList);
        for (Player nearPlayer : this.nearPlayers) {
            ((CraftPlayer)nearPlayer).getHandle().b.sendPacket((Packet)setEquipmentPacket);
        }
    }

    private void setEquipmentVisibility(boolean Visibility) {
        ArrayList<Pair> equipmentList = new ArrayList<Pair>();
        net.minecraft.world.item.ItemStack nmsCopy = CraftItemStack.asNMSCopy((ItemStack)new ItemStack(Material.AIR));
        for (EnumItemSlot equipmentSlot : EnumItemSlot.values()) {
            net.minecraft.world.item.ItemStack itemStack = Visibility ? this.serverPlayer.getEquipment(equipmentSlot) : null;
            equipmentList.add(Pair.of((Object)equipmentSlot, (Object)(itemStack != null ? itemStack : nmsCopy)));
        }
        PacketPlayOutEntityEquipment setEquipmentPacket = new PacketPlayOutEntityEquipment(this.serverPlayer.getId(), equipmentList);
        for (Player nearPlayer : this.nearPlayers) {
            if (nearPlayer == this.seatPlayer) continue;
            ((CraftPlayer)nearPlayer).getHandle().b.sendPacket((Packet)setEquipmentPacket);
        }
        if (this.seatPlayer.getGameMode() != GameMode.CREATIVE) {
            this.seatPlayer.updateInventory();
            if (!Visibility) {
                this.serverPlayer.b.sendPacket((Packet)setEquipmentPacket);
            }
        }
    }

    private void playAnimation(int Arm) {
        PacketPlayOutAnimation animatePacket = new PacketPlayOutAnimation((Entity)this.playerNpc, Arm);
        for (Player nearPlayer : this.nearPlayers) {
            ((CraftPlayer)nearPlayer).getHandle().b.sendPacket((Packet)animatePacket);
        }
    }

    private byte getFixedRotation(float Yaw) {
        return (byte)(Yaw * 256.0f / 360.0f);
    }

    private EnumDirection getDirection() {
        float yaw = this.seat.getLocation().getYaw();
        return yaw >= 135.0f || yaw < -135.0f ? EnumDirection.c : (yaw >= -135.0f && yaw < -45.0f ? EnumDirection.f : (yaw >= -45.0f && yaw < 45.0f ? EnumDirection.d : (yaw >= 45.0f ? EnumDirection.e : EnumDirection.c)));
    }

    private EntityPlayer createNPC() {
        DedicatedServer minecraftServer = ((CraftServer)Bukkit.getServer()).getServer();
        WorldServer serverLevel = ((CraftWorld)this.seat.getLocation().getWorld()).getHandle();
        GameProfile gameProfile = new GameProfile(UUID.randomUUID(), this.seatPlayer.getName());
        gameProfile.getProperties().putAll((Multimap)this.serverPlayer.getProfile().getProperties());
        return new EntityPlayer((MinecraftServer)minecraftServer, serverLevel, gameProfile);
    }

    @Override
    public GSeat getSeat() {
        return this.seat;
    }

    @Override
    public Player getPlayer() {
        return this.seatPlayer;
    }

    @Override
    public Pose getPose() {
        return this.pose;
    }

    public String toString() {
        return this.seat.toString();
    }
}

