/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.mcv.v1_17_R1.manager;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.api.event.PlayerCrawlEvent;
import dev.geco.gsit.api.event.PlayerGetUpCrawlEvent;
import dev.geco.gsit.api.event.PrePlayerCrawlEvent;
import dev.geco.gsit.api.event.PrePlayerGetUpCrawlEvent;
import dev.geco.gsit.manager.ICrawlManager;
import dev.geco.gsit.mcv.v1_17_R1.objects.GCrawl;
import dev.geco.gsit.objects.GetUpReason;
import dev.geco.gsit.objects.IGCrawl;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class CrawlManager
implements ICrawlManager {
    private final GSitMain GPM;
    private int feature_used = 0;
    private final List<IGCrawl> crawls = new ArrayList<IGCrawl>();

    public CrawlManager(GSitMain GPluginMain) {
        this.GPM = GPluginMain;
    }

    @Override
    public int getFeatureUsedCount() {
        return this.feature_used;
    }

    @Override
    public void resetFeatureUsedCount() {
        this.feature_used = 0;
    }

    @Override
    public List<IGCrawl> getCrawls() {
        return new ArrayList<IGCrawl>(this.crawls);
    }

    @Override
    public boolean isCrawling(Player Player2) {
        return this.getCrawl(Player2) != null;
    }

    @Override
    public IGCrawl getCrawl(Player Player2) {
        return this.getCrawls().stream().filter(crawl -> Player2.equals(crawl.getPlayer())).findFirst().orElse(null);
    }

    @Override
    public void clearCrawls() {
        for (IGCrawl crawl : this.getCrawls()) {
            this.stopCrawl(crawl.getPlayer(), GetUpReason.PLUGIN);
        }
    }

    @Override
    public IGCrawl startCrawl(Player Player2) {
        PrePlayerCrawlEvent preEvent = new PrePlayerCrawlEvent(Player2);
        Bukkit.getPluginManager().callEvent((Event)preEvent);
        if (preEvent.isCancelled()) {
            return null;
        }
        GCrawl crawl = new GCrawl(Player2);
        crawl.start();
        this.crawls.add(crawl);
        ++this.feature_used;
        Bukkit.getPluginManager().callEvent((Event)new PlayerCrawlEvent(crawl));
        return crawl;
    }

    @Override
    public boolean stopCrawl(Player Player2, GetUpReason Reason) {
        if (!this.isCrawling(Player2)) {
            return true;
        }
        IGCrawl crawl = this.getCrawl(Player2);
        PrePlayerGetUpCrawlEvent preEvent = new PrePlayerGetUpCrawlEvent(crawl, Reason);
        Bukkit.getPluginManager().callEvent((Event)preEvent);
        if (preEvent.isCancelled()) {
            return false;
        }
        this.crawls.remove(crawl);
        crawl.stop();
        Bukkit.getPluginManager().callEvent((Event)new PlayerGetUpCrawlEvent(crawl, Reason));
        return true;
    }
}

