/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.manager;

import dev.geco.gsit.GSitMain;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ToggleManager {
    private final GSitMain GPM;
    private File toggleFile;
    private FileConfiguration toggleData;
    private final List<UUID> toggleList = new ArrayList<UUID>();
    private final List<UUID> playerToggleList = new ArrayList<UUID>();
    private final List<UUID> crawlToggleList = new ArrayList<UUID>();
    private BukkitRunnable task;

    public ToggleManager(GSitMain GPluginMain) {
        this.GPM = GPluginMain;
    }

    public boolean canSit(UUID UUID2) {
        return this.GPM.getCManager().S_DEFAULT_SIT_MODE != this.toggleList.contains(UUID2);
    }

    public boolean canPlayerSit(UUID UUID2) {
        return this.GPM.getCManager().PS_DEFAULT_SIT_MODE != this.playerToggleList.contains(UUID2);
    }

    public boolean canCrawl(UUID UUID2) {
        return !this.crawlToggleList.contains(UUID2);
    }

    public void setCanSit(UUID UUID2, boolean Toggle) {
        if (Toggle && this.GPM.getCManager().S_DEFAULT_SIT_MODE || !Toggle && !this.GPM.getCManager().S_DEFAULT_SIT_MODE) {
            this.toggleList.remove(UUID2);
        } else {
            this.toggleList.add(UUID2);
        }
    }

    public void setCanPlayerSit(UUID UUID2, boolean PlayerToggle) {
        if (PlayerToggle && this.GPM.getCManager().PS_DEFAULT_SIT_MODE || !PlayerToggle && !this.GPM.getCManager().PS_DEFAULT_SIT_MODE) {
            this.playerToggleList.remove(UUID2);
        } else {
            this.playerToggleList.add(UUID2);
        }
    }

    public void setCanCrawl(UUID UUID2, boolean Toggle) {
        if (Toggle) {
            this.crawlToggleList.remove(UUID2);
        } else {
            this.crawlToggleList.add(UUID2);
        }
    }

    public void loadToggleData() {
        this.toggleList.clear();
        this.playerToggleList.clear();
        this.crawlToggleList.clear();
        this.toggleFile = new File("plugins/" + this.GPM.NAME, "data/t.data");
        this.toggleData = YamlConfiguration.loadConfiguration((File)this.toggleFile);
        for (String uuid : this.toggleData.getStringList("T")) {
            this.toggleList.add(UUID.fromString(uuid));
        }
        for (String uuid : this.toggleData.getStringList("P")) {
            this.playerToggleList.add(UUID.fromString(uuid));
        }
        for (String uuid : this.toggleData.getStringList("C")) {
            this.crawlToggleList.add(UUID.fromString(uuid));
        }
        this.startAutoSave();
    }

    public void saveToggleData() {
        this.stopAutoSave();
        this.quickSaveToggleData();
    }

    private void quickSaveToggleData() {
        this.toggleData.set("T", null);
        this.toggleData.set("P", null);
        this.toggleData.set("C", null);
        ArrayList<String> toggles = new ArrayList<String>();
        for (UUID uUID : this.toggleList) {
            toggles.add(uUID.toString());
        }
        this.toggleData.set("T", toggles);
        ArrayList<String> playerToggles = new ArrayList<String>();
        for (UUID uuid : this.playerToggleList) {
            playerToggles.add(uuid.toString());
        }
        this.toggleData.set("P", playerToggles);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (UUID uuid : this.crawlToggleList) {
            arrayList.add(uuid.toString());
        }
        this.toggleData.set("C", arrayList);
        this.saveFile(this.toggleFile, this.toggleData);
    }

    private void startAutoSave() {
        this.stopAutoSave();
        this.task = new BukkitRunnable(){

            public void run() {
                ToggleManager.this.quickSaveToggleData();
            }
        };
        long time = 3600L;
        this.task.runTaskTimerAsynchronously((Plugin)this.GPM, time, time);
    }

    private void stopAutoSave() {
        if (this.task != null) {
            this.task.cancel();
        }
    }

    private void saveFile(File File2, FileConfiguration FileConfiguration2) {
        try {
            FileConfiguration2.save(File2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

