/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.manager;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.api.event.EntityGetUpSitEvent;
import dev.geco.gsit.api.event.EntitySitEvent;
import dev.geco.gsit.api.event.PreEntityGetUpSitEvent;
import dev.geco.gsit.api.event.PreEntitySitEvent;
import dev.geco.gsit.manager.ISitManager;
import dev.geco.gsit.manager.NMSManager;
import dev.geco.gsit.objects.GSeat;
import dev.geco.gsit.objects.GetUpReason;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SitManager
implements ISitManager {
    private final GSitMain GPM;
    private int feature_used = 0;
    private final List<GSeat> seats = new ArrayList<GSeat>();
    private final HashMap<GSeat, BukkitRunnable> rotate = new HashMap();

    public SitManager(GSitMain GPluginMain) {
        this.GPM = GPluginMain;
    }

    @Override
    public int getFeatureUsedCount() {
        return this.feature_used;
    }

    @Override
    public void resetFeatureUsedCount() {
        this.feature_used = 0;
    }

    @Override
    public List<GSeat> getSeats() {
        return new ArrayList<GSeat>(this.seats);
    }

    @Override
    public boolean isSitting(LivingEntity Entity2) {
        return this.getSeat(Entity2) != null;
    }

    @Override
    public GSeat getSeat(LivingEntity Entity2) {
        return this.getSeats().stream().filter(seat -> Entity2.equals(seat.getEntity())).findFirst().orElse(null);
    }

    @Override
    public void clearSeats() {
        for (GSeat seat : this.getSeats()) {
            this.removeSeat(seat.getEntity(), GetUpReason.PLUGIN);
        }
    }

    @Override
    public boolean kickSeat(Block Block2, LivingEntity Entity2) {
        if (this.GPM.getSitUtil().isSeatBlock(Block2)) {
            if (!this.GPM.getPManager().hasPermission((CommandSender)Entity2, "Kick.Sit")) {
                return false;
            }
            for (GSeat seat : this.GPM.getSitUtil().getSeats(Block2)) {
                if (this.removeSeat(seat.getEntity(), GetUpReason.KICKED)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public GSeat createSeat(Block Block2, LivingEntity Entity2) {
        return this.createSeat(Block2, Entity2, true, 0.0, 0.0, 0.0, Entity2.getLocation().getYaw(), this.GPM.getCManager().CENTER_BLOCK, true);
    }

    @Override
    public GSeat createSeat(Block Block2, LivingEntity Entity2, boolean Rotate, double XOffset, double YOffset, double ZOffset, float SeatRotation, boolean SitAtBlock, boolean GetUpSneak) {
        double offset;
        PreEntitySitEvent preEvent = new PreEntitySitEvent(Entity2, Block2);
        Bukkit.getPluginManager().callEvent((Event)preEvent);
        if (preEvent.isCancelled()) {
            return null;
        }
        double d = offset = SitAtBlock ? Block2.getBoundingBox().getMinY() + Block2.getBoundingBox().getHeight() : 0.0;
        offset = (SitAtBlock ? (offset == 0.0 ? 1.0 : offset - (double)Block2.getY()) : offset) + this.GPM.getCManager().S_SITMATERIALS.getOrDefault(Block2.getType(), 0.0);
        Location location = Entity2.getLocation().clone();
        Location returnLocation = location.clone();
        location = SitAtBlock ? Block2.getLocation().clone().add(0.5 + XOffset, YOffset + offset - 0.2, 0.5 + ZOffset) : location.add(XOffset, YOffset - 0.2 + this.GPM.getCManager().S_SITMATERIALS.getOrDefault(Block2.getType(), 0.0), ZOffset);
        if (!this.GPM.getSpawnUtil().checkLocation(location)) {
            return null;
        }
        location.setYaw(SeatRotation);
        Entity seatEntity = this.GPM.getSpawnUtil().createSeatEntity(location, (Entity)Entity2);
        if (this.GPM.getCManager().S_SIT_MESSAGE && Entity2 instanceof Player) {
            this.GPM.getMManager().sendActionBarMessage((Player)Entity2, "Messages.action-sit-info", new Object[0]);
        }
        GSeat seat = new GSeat(Block2, location, Entity2, seatEntity, returnLocation);
        seatEntity.setMetadata(this.GPM.NAME, (MetadataValue)new FixedMetadataValue((Plugin)this.GPM, (Object)seat));
        this.seats.add(seat);
        this.GPM.getSitUtil().setSeatBlock(Block2, seat);
        if (Rotate) {
            this.startRotateSeat(seat);
        }
        ++this.feature_used;
        Bukkit.getPluginManager().callEvent((Event)new EntitySitEvent(seat));
        return seat;
    }

    @Override
    public void moveSeat(LivingEntity Entity2, final BlockFace BlockFace2) {
        if (!this.isSitting(Entity2)) {
            return;
        }
        final GSeat seat = this.getSeat(Entity2);
        new BukkitRunnable(){

            public void run() {
                SitManager.this.GPM.getSitUtil().removeSeatBlock(seat.getBlock(), seat);
                seat.setBlock(seat.getBlock().getRelative(BlockFace2));
                seat.setLocation(seat.getLocation().add((double)BlockFace2.getModX(), (double)BlockFace2.getModY(), (double)BlockFace2.getModZ()));
                SitManager.this.GPM.getSitUtil().setSeatBlock(seat.getBlock(), seat);
                SitManager.this.GPM.getPlayerUtil().posEntity(seat.getSeatEntity(), seat.getLocation());
            }
        }.runTaskLater((Plugin)this.GPM, 0L);
    }

    private void startRotateSeat(final GSeat Seat) {
        if (this.rotate.containsKey(Seat)) {
            this.stopRotateSeat(Seat);
        }
        BukkitRunnable task = new BukkitRunnable(){

            public void run() {
                if (!SitManager.this.seats.contains(Seat) || Seat.getSeatEntity().getPassengers().isEmpty()) {
                    this.cancel();
                    return;
                }
                Location location = ((Entity)Seat.getSeatEntity().getPassengers().get(0)).getLocation();
                Seat.getSeatEntity().setRotation(location.getYaw(), location.getPitch());
            }
        };
        task.runTaskTimer((Plugin)this.GPM, 0L, 2L);
        this.rotate.put(Seat, task);
    }

    protected void stopRotateSeat(GSeat Seat) {
        if (!this.rotate.containsKey(Seat)) {
            return;
        }
        BukkitRunnable task = this.rotate.get(Seat);
        if (task != null) {
            task.cancel();
        }
        this.rotate.remove(Seat);
    }

    @Override
    public boolean removeSeat(LivingEntity Entity2, GetUpReason Reason) {
        return this.removeSeat(Entity2, Reason, true);
    }

    @Override
    public boolean removeSeat(LivingEntity Entity2, GetUpReason Reason, boolean Safe) {
        Location returnLocation;
        if (!this.isSitting(Entity2)) {
            return true;
        }
        GSeat seat = this.getSeat(Entity2);
        PreEntityGetUpSitEvent preEvent = new PreEntityGetUpSitEvent(seat, Reason);
        Bukkit.getPluginManager().callEvent((Event)preEvent);
        if (preEvent.isCancelled()) {
            return false;
        }
        this.GPM.getSitUtil().removeSeatBlock(seat.getBlock(), seat);
        this.seats.remove(seat);
        this.stopRotateSeat(seat);
        Location location = this.GPM.getCManager().GET_UP_RETURN ? seat.getReturn() : (returnLocation = seat.getLocation().add(0.0, 0.2 + (Tag.STAIRS.isTagged((Keyed)seat.getBlock().getType()) ? 0.5 : 0.0) - this.GPM.getCManager().S_SITMATERIALS.getOrDefault(seat.getBlock().getType(), 0.0), 0.0));
        if (!this.GPM.getCManager().GET_UP_RETURN) {
            returnLocation.setYaw(seat.getEntity().getLocation().getYaw());
            returnLocation.setPitch(seat.getEntity().getLocation().getPitch());
        }
        if (seat.getEntity().isValid() && Safe && NMSManager.isNewerOrVersion(17L, 0)) {
            this.GPM.getPlayerUtil().posEntity((Entity)seat.getEntity(), returnLocation);
            this.GPM.getPlayerUtil().teleportEntity((Entity)seat.getEntity(), returnLocation, true);
        }
        if (seat.getSeatEntity().isValid()) {
            if (!NMSManager.isNewerOrVersion(17L, 0)) {
                this.GPM.getPlayerUtil().posEntity(seat.getSeatEntity(), returnLocation);
            }
            seat.getSeatEntity().remove();
        }
        Bukkit.getPluginManager().callEvent((Event)new EntityGetUpSitEvent(seat, Reason));
        return true;
    }
}

