/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.manager;

import dev.geco.gsit.GSitMain;
import dev.geco.gsit.api.event.PlayerGetUpPlayerSitEvent;
import dev.geco.gsit.api.event.PlayerPlayerSitEvent;
import dev.geco.gsit.api.event.PrePlayerGetUpPlayerSitEvent;
import dev.geco.gsit.api.event.PrePlayerPlayerSitEvent;
import dev.geco.gsit.manager.IPlayerSitManager;
import dev.geco.gsit.objects.GetUpReason;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class PlayerSitManager
implements IPlayerSitManager {
    private final GSitMain GPM;
    private int feature_used = 0;

    public PlayerSitManager(GSitMain GPluginMain) {
        this.GPM = GPluginMain;
    }

    @Override
    public int getFeatureUsedCount() {
        return this.feature_used;
    }

    @Override
    public void resetFeatureUsedCount() {
        this.feature_used = 0;
    }

    @Override
    public boolean sitOnPlayer(Player Player2, Player Target) {
        PrePlayerPlayerSitEvent preEvent = new PrePlayerPlayerSitEvent(Player2, Target);
        Bukkit.getPluginManager().callEvent((Event)preEvent);
        if (preEvent.isCancelled()) {
            return false;
        }
        if (!this.GPM.getSpawnUtil().checkPlayerLocation((Entity)Target)) {
            return false;
        }
        Entity playerSeatEntity = this.GPM.getSpawnUtil().createPlayerSeatEntity((Entity)Target, (Entity)Player2);
        if (this.GPM.getCManager().PS_SIT_MESSAGE) {
            this.GPM.getMManager().sendActionBarMessage(Player2, "Messages.action-playersit-info", new Object[0]);
        }
        playerSeatEntity.setMetadata(this.GPM.NAME + "A", (MetadataValue)new FixedMetadataValue((Plugin)this.GPM, (Object)Player2));
        ++this.feature_used;
        Bukkit.getPluginManager().callEvent((Event)new PlayerPlayerSitEvent(Player2, Target));
        return true;
    }

    @Override
    public boolean stopPlayerSit(Entity Entity2, GetUpReason Reason) {
        Entity vehicle;
        if (Entity2 instanceof Player) {
            PrePlayerGetUpPlayerSitEvent preEvent = new PrePlayerGetUpPlayerSitEvent((Player)Entity2, Reason);
            Bukkit.getPluginManager().callEvent((Event)preEvent);
            if (preEvent.isCancelled()) {
                return false;
            }
        }
        if (Entity2.hasMetadata(this.GPM.NAME + "A")) {
            Entity2.eject();
            Entity2.remove();
        }
        for (Entity passenger : Entity2.getPassengers()) {
            if (!passenger.hasMetadata(this.GPM.NAME + "A")) continue;
            passenger.eject();
            passenger.remove();
        }
        if (Entity2.isInsideVehicle() && (vehicle = Entity2.getVehicle()).hasMetadata(this.GPM.NAME + "A")) {
            vehicle.eject();
            vehicle.remove();
        }
        if (Entity2 instanceof Player) {
            Bukkit.getPluginManager().callEvent((Event)new PlayerGetUpPlayerSitEvent((Player)Entity2, Reason));
        }
        return true;
    }
}

