/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gsit.manager;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;

public class NMSManager {
    private static final Map<Class<?>, Class<?>> CORRESPONDING_TYPES = new HashMap();

    private static Class<?> getPrimitiveType(Class<?> Class2) {
        return CORRESPONDING_TYPES.getOrDefault(Class2, Class2);
    }

    private static Class<?>[] toPrimitiveTypeArray(Class<?>[] Classes) {
        int length = Classes != null ? Classes.length : 0;
        Class[] type = new Class[length];
        for (int count = 0; count < length; ++count) {
            type[count] = NMSManager.getPrimitiveType(Classes[count]);
        }
        return type;
    }

    private static boolean equalsTypeArray(Class<?>[] Type2, Class<?>[] OtherType) {
        if (Type2.length != OtherType.length) {
            return false;
        }
        for (int count = 0; count < Type2.length; ++count) {
            if (Type2[count].equals(OtherType[count]) || Type2[count].isAssignableFrom(OtherType[count])) continue;
            return false;
        }
        return true;
    }

    private static boolean classListEqual(Class<?>[] Type2, Class<?>[] OtherType) {
        if (Type2.length != OtherType.length) {
            return false;
        }
        for (int count = 0; count < Type2.length; ++count) {
            if (Type2[count] == OtherType[count]) continue;
            return false;
        }
        return true;
    }

    public static String getClassVersion() {
        String version = Bukkit.getServer().getClass().getPackage().getName();
        return version.substring(version.lastIndexOf(46) + 1);
    }

    public static String getPackageVersion() {
        return NMSManager.getClassVersion() + (NMSManager.isVersion(17L, 1) || NMSManager.isVersion(19L, 1) || NMSManager.isVersion(19L, 2) ? "_2" : "");
    }

    public static String getVersion() {
        return Bukkit.getBukkitVersion().substring(0, Bukkit.getBukkitVersion().indexOf(45));
    }

    public static boolean isNewerOrVersion(long Version2, int SubVersion) {
        String[] version = NMSManager.getVersion().split("\\.");
        return version.length > 1 && (version.length > 2 ? Long.parseLong(version[1]) >= Version2 && Long.parseLong(version[2]) >= (long)SubVersion : Long.parseLong(version[1]) >= Version2);
    }

    public static boolean isVersion(long Version2, int SubVersion) {
        String[] version = NMSManager.getVersion().split("\\.");
        return version.length > 1 && (version.length > 2 ? Long.parseLong(version[1]) == Version2 && Long.parseLong(version[2]) == (long)SubVersion : Long.parseLong(version[1]) == Version2 && SubVersion == 0);
    }

    public static Field getField(Class<?> Class2, String Field2) {
        try {
            Field F = Class2.getDeclaredField(Field2);
            F.setAccessible(true);
            return F;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getPackageObject(String Name, String ClassName, Object O) {
        try {
            Class<?> sm = Class.forName("dev.geco." + Name + ".mcv." + NMSManager.getPackageVersion() + "." + ClassName);
            return O == null ? sm.getConstructor(new Class[0]).newInstance(new Object[0]) : sm.getConstructor(O.getClass()).newInstance(O);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Class<?> getNMSClass(String ClassName) {
        Object C = null;
        try {
            return Class.forName("net.minecraft.server." + NMSManager.getClassVersion() + "." + ClassName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Class<?> getOBCClass(String ClassName) {
        Object C = null;
        try {
            return Class.forName("org.bukkit.craftbukkit." + NMSManager.getClassVersion() + "." + ClassName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Method getMethod(Class<?> Class2, String ClassName, Class<?> ... Parameters) {
        for (Method method : Class2.getMethods()) {
            if (!method.getName().equals(ClassName) || Parameters.length != 0 && !NMSManager.classListEqual(Parameters, method.getParameterTypes())) continue;
            method.setAccessible(true);
            return method;
        }
        return null;
    }

    public static Method getMethod(String MethodName, Class<?> Class2, Class<?> ... Parameters) {
        Class<?>[] type = NMSManager.toPrimitiveTypeArray(Parameters);
        for (Method method : Class2.getMethods()) {
            if (!method.getName().equals(MethodName) || !NMSManager.equalsTypeArray(NMSManager.toPrimitiveTypeArray(method.getParameterTypes()), type)) continue;
            return method;
        }
        return null;
    }

    public static Class<?> getClass(Class<?> Class2, String Search) {
        for (Class<?> sClass : Class2.getClasses()) {
            if (!sClass.getSimpleName().equals(Search)) continue;
            return sClass;
        }
        return null;
    }

    public static Object invokeMethod(String MethodName, Object Parameter2) {
        try {
            return NMSManager.getMethod(MethodName, Parameter2.getClass(), new Class[0]).invoke(Parameter2, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getHandle(Object O) {
        try {
            Method m = O.getClass().getDeclaredMethod("getHandle", new Class[0]);
            m.setAccessible(true);
            return m.invoke(O, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return O;
        }
    }

    public static boolean set(Object Object2, String Field2, Object Value) {
        for (Class<?> C = Object2.getClass(); C != null; C = C.getSuperclass()) {
            try {
                Field F = C.getDeclaredField(Field2);
                F.setAccessible(true);
                F.set(Object2, Value);
                return true;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return false;
    }
}

